/*
 * Decompiled with CFR 0.152.
 */
package jmaki.ant;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import jmaki.model.Widget;
import jmaki.model.WidgetArg;
import jmaki.model.WidgetArgValue;
import jmaki.model.WidgetTopic;
import jmaki.model.WidgetValue;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.json.JSONObject;

public class GenWidgetDocTask
extends Task {
    private StringBuffer pageTemplate = null;
    private StringBuffer libraryTemplate = null;
    private String targetDirectory = "docs";
    private ArrayList targetDirs = new ArrayList();
    private ArrayList filesets = new ArrayList();
    String message;
    boolean fail = false;
    Vector messages = new Vector();

    public void setTodir(String td) {
        this.targetDirectory = td;
    }

    public void addLibrarybase(String libbase) {
        this.targetDirs.add(libbase);
    }

    public void addFileSet(FileSet fileset) {
        if (!this.filesets.contains(fileset)) {
            this.filesets.add(fileset);
        }
    }

    public void setFail(boolean b) {
        this.fail = b;
    }

    public void addText(String text) {
        this.message = text;
    }

    public void execute() {
        File targetFile = null;
        if (this.pageTemplate == null) {
            try {
                FileInputStream fis = new FileInputStream("templates/page.html");
                this.pageTemplate = GenWidgetDocTask.loadTemplate(fis);
            }
            catch (FileNotFoundException fnfx) {
                System.err.println("GenWidgetDocTask Error: " + fnfx);
            }
        }
        Iterator fit = this.filesets.iterator();
        while (fit.hasNext()) {
            FileSet fs;
            try {
                FileInputStream fis = new FileInputStream("templates/library.html");
                this.libraryTemplate = GenWidgetDocTask.loadTemplate(fis);
            }
            catch (FileNotFoundException fnfx) {
                System.err.println("GenWidgetDocTask Error: " + fnfx);
            }
            if ((targetFile = (fs = (FileSet)fit.next()).getDir()) == null) continue;
            ArrayList widgets = new ArrayList();
            StringBuffer pbuff = new StringBuffer();
            try {
                String base = targetFile.getAbsolutePath();
                this.findWidgets(base, targetFile, widgets);
                Iterator it = widgets.iterator();
                String packageName = null;
                while (it != null && it.hasNext()) {
                    Widget w = (Widget)it.next();
                    if (packageName == null) {
                        packageName = w.getPackageName();
                    }
                    pbuff.append("<p><a href=\"" + w.getPath().replace("\\", "/") + "/doc.html\">" + w.getShortName() + "</a></p>");
                    this.genDocs(w);
                }
                System.out.println("packageName " + packageName);
                if (packageName != null) {
                    String packageNameBefore = packageName;
                    char c = packageName.charAt(0);
                    packageName = Character.toUpperCase(c) + packageName.substring(1, packageName.length());
                    GenWidgetDocTask.replace(this.libraryTemplate, "${body}", pbuff.toString());
                    GenWidgetDocTask.replace(this.libraryTemplate, "${library}", packageName);
                    File b = new File(this.targetDirectory);
                    FileOutputStream fos = new FileOutputStream(new File(b, packageNameBefore + ".html"));
                    this.writeHTML(new ByteArrayInputStream(this.libraryTemplate.toString().getBytes()), fos);
                    continue;
                }
                System.out.println("Could not find any Widgets for " + targetFile);
            }
            catch (Exception e) {
                System.out.println("Error parsing Widgets: " + e);
                e.printStackTrace();
            }
        }
        if (this.fail) {
            throw new BuildException("Fail requested.");
        }
    }

    public void findWidgets(String base, File f, ArrayList widgets) {
        if (f.isDirectory()) {
            String[] children = f.list();
            for (int i = 0; i < children.length; ++i) {
                this.findWidgets(base, new File(f, children[i]), widgets);
            }
        } else if ("widget.json".equals(f.getName())) {
            Widget w = new Widget(base, f);
            widgets.add(w);
        }
    }

    public boolean genDocs(Widget w) {
        String widgetName = w.getName();
        System.out.println("Processing " + widgetName);
        try {
            StringBuffer template = new StringBuffer(this.pageTemplate);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("widgetName", w.getName());
            if (w.getVersion() != null) {
                map.put("widgetVersion", w.getVersion());
            } else {
                map.put("widgetVersion", "");
            }
            if (w.getAuthor() != null) {
                map.put("widgetAuthor", w.getAuthor());
            } else {
                map.put("widgetAuthor", "");
            }
            if (w.getURL() != null) {
                map.put("widgetURL", w.getURL());
            } else {
                map.put("widgetURL", "");
            }
            if (w.getDescription() != null) {
                map.put("widgetDescription", w.getDescription());
            }
            String argsBody = "";
            if (w.getArgs().size() > 0) {
                argsBody = argsBody + "<table class='argsTable'>";
                argsBody = argsBody + "<thead><th>Name</th><th>Description</th><th>Type</th><th>Value Options</th><th>Default Value</th></thead>";
                Iterator it = w.getArgs().iterator();
                while (it.hasNext()) {
                    WidgetArg arg = (WidgetArg)it.next();
                    argsBody = argsBody + " <tr>";
                    String ain = arg.getKey();
                    if (ain != null) {
                        argsBody = argsBody + "<td>" + ain + "</td>";
                        argsBody = arg.getDescription() != null ? argsBody + "<td>" + arg.getDescription() + "</td>" : argsBody + "<td></td>";
                        argsBody = arg.getType() != null ? argsBody + "<td>" + arg.getType() + "</td>" : argsBody + "<td></td>";
                        if (arg.getValues().size() > 0) {
                            Iterator vit = arg.getValues().iterator();
                            String valString = "";
                            while (vit.hasNext()) {
                                WidgetArgValue ivals = (WidgetArgValue)vit.next();
                                String ext = "";
                                if (ivals.getDescription() != null) {
                                    ext = " - " + ivals.getDescription();
                                }
                                valString = valString + ivals.getValue() + ext;
                                if (!vit.hasNext()) continue;
                                valString = valString + "<br>";
                            }
                            argsBody = argsBody + "<td>" + valString + "</td>";
                        } else {
                            argsBody = argsBody + "<td></td>";
                        }
                        argsBody = arg.getDefaultValue() != null ? argsBody + "<td>" + arg.getDefaultValue() + "</td>" : argsBody + "<td></td>";
                    }
                    argsBody = argsBody + " </tr>";
                }
                argsBody = argsBody + "</table>";
            } else {
                argsBody = "N/A";
            }
            map.put("argsBody", argsBody);
            String vb = "";
            if (w.getValue() != null) {
                WidgetValue valo = w.getValue();
                vb = vb + "<table class='valueTable'>";
                vb = vb + "<thead><th>Required</th><th>Type</th><th>Default Value</th></thead>";
                vb = vb + "<tr>";
                vb = valo.isRequired() ? vb + "<td>" + valo.isRequired() + "</td>" : vb + "<td></td>";
                vb = valo.getType() != null ? vb + "<td>" + valo.getType() + "</td>" : vb + "<td></td>";
                vb = valo.getDefaultValue() != null ? vb + "<td>" + valo.getDefaultValue() + "</td>" : vb + "<td></td>";
                vb = vb + "</tr></table>";
            } else {
                vb = "N/A";
            }
            String tb = "";
            if (w.getTopic() != null) {
                WidgetTopic tilo = w.getTopic();
                tb = tb + "<table class='topicTable'>";
                tb = tb + "<thead><th>topicName</th><th>Type</th><th>Description </th></thead>";
                tb = tb + "<tr>";
                tb = tilo.gettopicName() != null ? tb + "<td>" + tilo.gettopicName() + "</td>" : tb + "<td></td>";
                tb = tilo.getType() != null ? tb + "<td>" + tilo.getType() + "</td>" : tb + "<td></td>";
                tb = tilo.getDescription() != null ? tb + "<td>" + tilo.getDescription() + "</td>" : tb + "<td></td>";
                tb = tb + "</tr></table>";
            } else {
                tb = "N/A";
            }
            map.put("valueBody", vb);
            map.put("topicBody", tb);
            map.put("widgetId", w.getName());
            map.put("widgetPackage", w.getPackageName());
            File dir = new File(this.targetDirectory + File.separator + w.getPath());
            boolean s = dir.mkdirs();
            if (w.getImage() != null) {
                try {
                    File img = new File(w.getFile().getParent(), w.getImage());
                    File imgo = new File(dir, "widget.jpg");
                    imgo.createNewFile();
                    if (imgo.exists()) {
                        FileInputStream fis2 = new FileInputStream(img);
                        FileOutputStream fos = new FileOutputStream(imgo);
                        byte[] buffer = new byte[1024];
                        int read = 0;
                        while ((read = fis2.read(buffer)) > 0) {
                            fos.write(buffer, 0, read);
                        }
                        fis2.close();
                        fos.close();
                        map.put("widgetImage", "widget.jpg");
                    }
                }
                catch (IOException iox) {
                    System.err.println("GenWidgetDocTask Error: " + iox);
                    map.put("widgetImage", "");
                }
            }
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                GenWidgetDocTask.replace(template, "${" + key + "}", (String)map.get(key));
            }
            FileOutputStream fos = new FileOutputStream(new File(dir, "doc.html"));
            this.writeHTML(new ByteArrayInputStream(template.toString().getBytes()), fos);
            return true;
        }
        catch (FileNotFoundException fnfx) {
            System.err.println("GenWidgetDocTask Error: " + fnfx);
        }
        catch (IOException iox) {
            System.err.println("GenWidgetDocTask Error: " + iox);
        }
        return false;
    }

    public Message createMessage() {
        Message msg = new Message();
        this.messages.add(msg);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject loadJSONObject(InputStream in) {
        ByteArrayOutputStream out = null;
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            out = new ByteArrayOutputStream();
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            JSONObject jSONObject = new JSONObject(out.toString());
            return jSONObject;
        }
        catch (Exception e) {
            System.out.println("GenWidgetDocTask: error reading in json " + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer loadTemplate(InputStream in) {
        ByteArrayOutputStream out = null;
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            out = new ByteArrayOutputStream();
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            StringBuffer stringBuffer = new StringBuffer(out.toString("UTF-8"));
            return stringBuffer;
        }
        catch (Exception e) {
            System.out.println("GenWidgetDocTask: error reading in json " + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static void replace(StringBuffer buff, String target, String replacement) {
        if (buff == null || target == null || replacement == null) {
            return;
        }
        for (int index = 0; index < buff.length() && (index = buff.indexOf(target)) != -1; index += replacement.length() + 1) {
            buff.replace(index, index + target.length(), replacement);
        }
    }

    private void writeHTML(InputStream in, OutputStream out) {
        byte[] bytes = new byte[1024];
        try {
            int read = 0;
            while ((read = in.read(bytes)) > 0) {
                out.write(bytes, 0, read);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            System.out.println("GenWidgetDocTask:read from stream error:" + e);
        }
    }

    public class Message {
        String msg;

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

