/*
 * Decompiled with CFR 0.152.
 */
package jmaki.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ReNamespaceTask
extends Task {
    private String ns = null;
    private ArrayList targetDirs = new ArrayList();
    private ArrayList filesets = new ArrayList();
    private String[] tokens = new String[0];
    private ArrayList targets = new ArrayList();
    private boolean success = false;
    private int gt = 0;
    private int fc = 0;
    private String renameFile = null;
    private String renameFileTo = null;
    private String[] fileTypes = new String[]{"js", "json", "html", "css"};
    boolean fail = false;

    public void setNs(String ns) {
        this.ns = ns;
    }

    public void setRenameFile(String renameFile) {
        this.renameFile = renameFile;
    }

    public void setRenameFileTo(String renameFileTo) {
        this.renameFileTo = renameFileTo;
    }

    public void setTokens(String t) {
        this.tokens = t.split(",");
    }

    public void setExtensions(String t) {
        this.fileTypes = t.split(",");
    }

    public void addFileSet(FileSet fileset) {
        if (!this.filesets.contains(fileset)) {
            this.filesets.add(fileset);
        }
    }

    public void setFail(boolean b) {
        this.fail = b;
    }

    public void execute() {
        File targetFile = null;
        Iterator fit = this.filesets.iterator();
        while (fit.hasNext()) {
            FileSet fs = (FileSet)fit.next();
            targetFile = fs.getDir();
            if (targetFile == null) continue;
            ArrayList targets = new ArrayList();
            try {
                String base = targetFile.getAbsolutePath();
                this.findTargets(base, targetFile, targets);
                Iterator it = targets.iterator();
                while (it != null && it.hasNext()) {
                    File f = (File)it.next();
                    this.processFile(f);
                }
            }
            catch (Exception e) {
                System.out.println("Error processing: " + e);
                this.fail = true;
            }
            if (this.fail) {
                this.log("Failed.");
                continue;
            }
            this.log("Successfully replaced " + this.gt + " tokens in " + this.fc + " files.");
        }
        if (this.fail) {
            throw new BuildException("Failed to Re-Namespace.");
        }
    }

    private void processFile(File f) {
        StringBuffer buff = null;
        try {
            FileInputStream fis = new FileInputStream(f);
            buff = ReNamespaceTask.loadFile(fis);
        }
        catch (FileNotFoundException fnfx) {
            System.err.println("Rens Error: " + fnfx);
        }
        int t = 0;
        for (int i = 0; i < this.tokens.length; ++i) {
            String token = this.tokens[i];
            t += ReNamespaceTask.replace(buff, token, this.ns);
        }
        this.log("Processed : " + f + " replaced : " + t);
        this.gt += t;
        ++this.fc;
        if (buff != null) {
            try {
                FileOutputStream fos = new FileOutputStream(f);
                OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                this.writeFile(buff.toString(), osr);
            }
            catch (Exception ex) {
                System.out.println("Error processing: " + ex);
                this.fail = true;
            }
        }
        if (this.renameFile != null && f.getName().endsWith(this.renameFile)) {
            String mt = this.renameFileTo;
            if (mt == null) {
                int last = f.getName().lastIndexOf(".");
                mt = this.ns;
                if (last != -1) {
                    String ext = f.getName().substring(last, f.getName().length());
                    mt = mt + ext;
                }
            }
            File nf = new File(f.getParentFile(), mt);
            f.renameTo(nf);
            this.log("Moved file " + this.renameFile + " to " + mt);
        }
    }

    public void findTargets(String base, File f, ArrayList targets) {
        if (f.isDirectory()) {
            String[] children = f.list();
            for (int i = 0; i < children.length; ++i) {
                this.findTargets(base, new File(f, children[i]), targets);
            }
        } else {
            for (int i = 0; i < this.fileTypes.length; ++i) {
                if (!f.getName().endsWith(this.fileTypes[i])) continue;
                targets.add(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer loadFile(InputStream in) {
        ByteArrayOutputStream out = null;
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            out = new ByteArrayOutputStream();
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            StringBuffer stringBuffer = new StringBuffer(out.toString("UTF-8"));
            return stringBuffer;
        }
        catch (Exception e) {
            System.out.println("RennsTask: error reading file " + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static int replace(StringBuffer buff, String target, String replacement) {
        int count = 0;
        if (buff == null || target == null || replacement == null) {
            return 0;
        }
        for (int index = 0; index < buff.length() && (index = buff.indexOf(target)) != -1; index += replacement.length() + 1) {
            buff.replace(index, index + target.length(), replacement);
            ++count;
        }
        return count;
    }

    private void writeFile(String buff, OutputStreamWriter out) {
        try {
            int len = buff.length();
            out.write(buff, 0, len);
            out.close();
        }
        catch (IOException e) {
            System.out.println("ReNamespace stream error:" + e);
            this.fail = true;
        }
    }
}

