/*
 * Decompiled with CFR 0.152.
 */
package jmaki.model;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import jmaki.model.WidgetArg;
import jmaki.model.WidgetArgValue;
import jmaki.model.WidgetTopic;
import jmaki.model.WidgetValue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Widget {
    private String name = null;
    private String shortName = null;
    private String base = null;
    private File f = null;
    private String image = null;
    private String path = null;
    private String packageName = null;
    private WidgetValue value = null;
    private WidgetTopic topic = null;
    private String version = null;
    private String jmakiVersion = null;
    private String author = null;
    private String url = null;
    private String description = null;
    private ArrayList args = new ArrayList();

    public Widget(String base, File f) {
        this.base = base;
        this.f = f;
        this.path = f.getAbsolutePath().substring(base.length() + 1, f.getAbsolutePath().length() - "widget.json".length() - 1);
        this.name = this.path.replace(File.separator, ".");
        int first = this.getName().indexOf(".");
        this.packageName = first != -1 ? this.name.substring(0, first) : this.name;
        int last = this.getName().lastIndexOf(".");
        this.shortName = last != -1 ? this.name.substring(last + 1, this.name.length()) : this.name;
        try {
            FileInputStream fis = new FileInputStream(f);
            JSONObject jo = this.loadJSONObject(fis);
            this.loadWidget(jo);
        }
        catch (FileNotFoundException fnf) {
            System.err.println("Error parsing widget: " + fnf);
        }
    }

    public File getFile() {
        return this.f;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getJMakiVersion() {
        return this.jmakiVersion;
    }

    public String getImage() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getPath() {
        return this.path;
    }

    public String getURL() {
        return this.url;
    }

    public WidgetValue getValue() {
        return this.value;
    }

    public WidgetTopic getTopic() {
        return this.topic;
    }

    public String getDescription() {
        return this.description;
    }

    public ArrayList getArgs() {
        return this.args;
    }

    public String toString() {
        return "{ packageName=" + this.packageName + " name=" + this.name + " path=" + this.path + " args=" + this.args + "}";
    }

    private void loadWidget(JSONObject jo) {
        try {
            if (jo.has("image")) {
                this.image = jo.getString("image");
            }
            if (jo.has("version")) {
                this.version = jo.getString("version");
            }
            if (jo.has("author")) {
                this.author = jo.getString("author");
            }
            if (jo.has("url")) {
                this.url = jo.getString("url");
            }
            if (jo.has("description")) {
                this.description = jo.getString("description");
            }
            ArrayList wArgs = new ArrayList();
            if (jo.has("args")) {
                JSONArray ja = jo.getJSONArray("args");
                for (int i = 0; i < ja.length(); ++i) {
                    JSONObject ai = ja.getJSONObject(i);
                    Iterator it = ai.keys();
                    String ain = null;
                    if (it.hasNext()) {
                        ain = (String)it.next();
                    } else {
                        System.err.println("Error parsing args[" + i + "] : No first property for key.");
                    }
                    if (ain == null) continue;
                    JSONObject arg = ai.getJSONObject(ain);
                    String description = null;
                    if (arg.has("description")) {
                        description = arg.getString("description");
                    }
                    String type = null;
                    if (arg.has("type")) {
                        type = arg.getString("type");
                    }
                    String defaultValue = null;
                    if (arg.has("defaultValue")) {
                        defaultValue = arg.getString("defaultValue");
                    }
                    ArrayList<WidgetArgValue> values = new ArrayList<WidgetArgValue>();
                    if (arg.has("values")) {
                        JSONArray vals = arg.getJSONArray("values");
                        String valString = "";
                        for (int vi = 0; vi < vals.length(); ++vi) {
                            JSONObject ivals = vals.getJSONObject(vi);
                            String ides = null;
                            if (ivals.has("description")) {
                                ides = ivals.getString("description");
                            }
                            String ival = null;
                            if (ivals.has("value")) {
                                ival = ivals.getString("value");
                            }
                            values.add(new WidgetArgValue(ival, ides));
                        }
                    }
                    this.args.add(new WidgetArg(ain, type, defaultValue, description, values));
                }
            }
            if (jo.has("value")) {
                JSONObject valo = jo.getJSONObject("value");
                boolean lr = false;
                if (valo.has("required")) {
                    lr = valo.getBoolean("required");
                }
                String lt = null;
                if (valo.has("type")) {
                    lt = valo.getString("type");
                }
                String ldv = null;
                if (valo.has("defaultValue")) {
                    ldv = valo.getString("defaultValue");
                }
                String ld = null;
                if (valo.has("description")) {
                    ld = valo.getString("description");
                }
                this.value = new WidgetValue(lt, ldv, lr, ld);
            }
            if (jo.has("topicInfo")) {
                JSONObject tilo = jo.getJSONObject("topicInfo");
                String tt = null;
                if (tilo.has("type")) {
                    tt = tilo.getString("type");
                }
                String td = null;
                if (tilo.has("description")) {
                    td = tilo.getString("description");
                }
                String tn = null;
                if (tilo.has("topicName")) {
                    tn = tilo.getString("topicName");
                }
                this.topic = new WidgetTopic(tt, tn, td);
            }
        }
        catch (JSONException jex) {
            System.err.println("Error parsing widget: " + (Object)((Object)jex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject loadJSONObject(InputStream in) {
        ByteArrayOutputStream out = null;
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            out = new ByteArrayOutputStream();
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            JSONObject jSONObject = new JSONObject(out.toString());
            return jSONObject;
        }
        catch (Exception e) {
            System.out.println("GenWidgetDocTask: error reading in json " + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

