// define the namespaces
jmaki.namespace("jmaki.widgets.yahoo.weather");

/**
 * Yahoo Weather Widget
 *   This widget lets you find the weather forecast using Yahoo Weather RSS feed.
 *   It uses the XMLHttpProxy to access the RSS feed. It can operate in hidden mode 
 *   if needed.
 * 
 *   US Zipcodes are already valid location ids. To find out another location id outside
 *   USA, you can use http://xoap.weather.com/search/search?where=city,country
 *
 * @author Ahmad M. Zawawi <ahmad.zawawi@gmail.com>  
 *
 * @see http://developer.yahoo.com/weather/
 */
jmaki.widgets.yahoo.weather.Widget = function(wargs) {
    
    var topic = "/yahoo/weather";
    var uuid = wargs.uuid;
    var self = this;
    
    //shorthand for libs
    var Dom = YAHOO.util.Dom;
    
    // we run on the xhp now
    var service = jmaki.xhp;
    
    var shown = true;
    
    //read configuration arguments
    if (typeof wargs.args != 'undefined') {
        //overide topic name if needed
        if(typeof wargs.args.topic != 'undefined') {
            topic = wargs.args.topic;
            jmaki.log("Yahoo weather: widget uses deprecated topic. Use publish instead.");
        }
        if(typeof wargs.args.shown != 'hidden') {
            shown = wargs.args.shown;
        }
    }
    if (wargs.publish) topic = wargs.publish; 
    
    if(shown) {
        //show the controls since it is hidden
        Dom.setStyle(uuid,'display','block');
    }
    
    /**
     * Returns the current weather forecast for location and unit
     * if the one of the optional parameters is not set,
     * they will be pulled automatically from the controls.
     *
     * @param location location id or zipcode (optional)
     * @param unit 'f' for Fahrenheit and 'c' for Celsius (optional)
     */
    this.getForecast = function(location,unit) {
        if((typeof location == 'undefined') || (typeof unit == 'undefined')) {
            //take them from controls...
            location = encodeURIComponent(document.getElementById(uuid + "_location").value);
            unit = encodeURIComponent(document.getElementById(uuid + "_unit").value);
        }
        var encodedParam = encodeURIComponent("p=" + location + "&u=" + unit);
        var url = service + "?id=yahooweather&urlparams=" + encodedParam;
        jmaki.doAjax({
            url: url, 
            callback: function(req) { 
                var _req = req;
                postProcess(_req);
            }
        });
    }
    
    /**
     * called by doAjax after finishing an HTTP request
     */
    function postProcess(req) {
        if (req.readyState == 4) {
            if (req.status == 200) {
                var v = {success:false};
                if(req.responseText.length > 0) {
                    var response = eval("(" + req.responseText + ")");
                    if(response.data.ok) {
                        v = {success:true,data:response.data}; 
                        var r = document.getElementById(uuid + "_results");
                        if(typeof v.data.forecast[0] != 'undefined')  {
                            if(typeof v.data.forecast[0].description != 'undefined')  {    
                                r.innerHTML = v.data.forecast[0].description;
                            }
                        }
                    } 
                } 
                //the new format is here (as in v)
                //with status flag sent
                jmaki.publish(topic + "/onChange", {id: uuid, value:v} )                
            } 
        }
        
    }
}