// add subscriber mapping for geocoder
jmaki.subscribe("/jmaki/mapLocation", function(loc) {
       var location = "location="+ loc + ",ca";
       jmaki.doAjax({
           url: jmaki.xhp + "?key=yahoogeocoder&urlparams=" + encodeURIComponent(location),
           callback : function(req) {
               var data = eval("(" + req.responseText + ")");
               jmaki.publish("/jmaki/plotmap", data.coordinates);
           }
       });
});

jmaki.namespace("jmaki.filters");

// convert an rss feed to the jMaki table format
jmaki.filters.clTableFilter = function(input) {
    var _columns = [
            {label: 'Location', id : 'loc'},
            {label: 'City', id : 'city'},            
            {label: 'Price', id : 'price'}
            ];
    var _rows = [];
    // parse each title to get the name, city, and price
    // title contains description (city / district | neighborhood) $00000    
    for (var _i=0; _i < input.channel.items.length;_i++) {
      var _link = input.channel.items[_i].link;      
      var _title = input.channel.items[_i].title;
      var _name = "";
      var cityStart = _title.lastIndexOf("(");
      if (cityStart != -1) _name = _title.substring(0, cityStart);
      var cityEnd = _title.indexOf(")", cityStart);
      var _city = "";
      if (cityStart != -1 && cityEnd != -1) {
          _city = _title.substring(cityStart + 1, cityEnd);
          // get rid of downtown north south east and west
          _city = _city.replace("downtown", "").replace("north", "");
          _city = _city.replace("south", "").replace("east", "");
          _city = _city.replace("west", "");
          // only go for the city when district is mentioned
          if (_city.indexOf("/") != -1) _city = _city.substring(0, _city.indexOf("/") -1);
	   _cityString = _city;
          _city= jmaki.trim(_city);
          _city = _city.replace(" ","+");
      }
      // create a link that will publish and event to map the city
      var _cityLink = "<a href=\"javascript:jmaki.publish('/jmaki/mapLocation','" +
                _city + "');\">" + _cityString + "</a>";
      var _nameLink = "<a href=\"" + _link + "\" target=\"external\">" + _name + "</a>";                
      var _date = input.channel.items[_i].date;
      var _price = /\$[0-9]*/.exec(_title);
      var row = {
         'loc' : _nameLink,
         'city' : _cityLink,
         'price' : _price
      };
      _rows.push(row);
    }
    return {columns : _columns, rows : _rows};
}
