jmaki.namespace("jmaki.listeners");

// programatcially add a glue listener    
jmaki.subscribe( "/jmaki/showURL", "jmaki.listeners.urlHandler");

// this is the listener for /jmaki/showURL
// the args is a string in this case that is a link to a blog entry
jmaki.listeners.urlHandler = function(args) {
  // publish to the topic the RSS display is mapped to
  jmaki.publish("/jmaki/rssContents/setInclude", { value : args});
}


jmaki.namespace("jmaki.filters");

// convert an rss feed to the jMaki table format
jmaki.filters.rssTableFilter = function(input) {
    var _columns = [
	{label: 'Title', id : 'title'},
	//{label: 'Link', id : 'link'},
	{label: 'Date', id : 'date'},
	{label: 'Description', id : 'description'}];

    var _rows=[];

  // parse each title and get the description, link and date


    for (var _i=0; _i <input.channel.items.length; _i++)  {
    	var _link = input.channel.items[_i].link;
    	var _title = input.channel.items[_i].title;
    	var _date = input.channel.items[_i].date;
    	var _description = input.channel.items[_i].description;
    
     
      	var row = {
    	    title : "<a href=\"javascript:jmaki.publish('/jmaki/showURL',{ value :'" +
                    _link + "'});\">" + _title + "</a>",
    	    date : _date,
    	    description : _description
      	};
    	_rows.push(row);
    }
    return {columns : _columns, rows : _rows};
}
