<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns:rss="http://purl.org/rss/1.0/"
  exclude-result-prefixes="rss rdf dc">
    
  <!-- "number" parameter can be passed. default = 3 enteries -->
  <xsl:param name="number">5</xsl:param>
  <xsl:output method="text" encoding="UTF-8"/>
  
  <!-- process for top channel -->
  <xsl:template match="/">
      <xsl:apply-templates select="rss" />
      <xsl:apply-templates select="rdf:RDF" />
  </xsl:template>
  
  <!-- RSS 1.0 -->
  <xsl:template match="rdf:RDF">
      <xsl:variable name="currentTitle" select="//rss:title" />
      <xsl:variable name="currentLink" select="//rss:link" />
      <xsl:variable name="currentDate" select="//dc:date" />
      <xsl:variable name="currentDesc" select="//rss:description" />

          {"columns": {
            "title" : "Title",
          <!--  "link" : "Link",-->
            "location" : "Location",
            "price" : "Price",
            "date" : "Date"
            },
            "rows" : [
            <xsl:apply-templates select="rss:item" />
            ]
            }
  </xsl:template>
  
  <!-- process each element item -->
  <xsl:template match="rss:item">
      <xsl:if test="($number = 0) or (position() &lt;= $number)">
          
          <xsl:call-template name="itemJson">
              <xsl:with-param name="link"><xsl:value-of select="rss:link"/></xsl:with-param>
              <xsl:with-param name="title"><xsl:value-of select="rss:title"/></xsl:with-param>
              <xsl:with-param name="date"><xsl:value-of select="dc:date"/></xsl:with-param>
              <xsl:with-param name="description"><xsl:value-of select="rss:description"/></xsl:with-param>
          </xsl:call-template>
      </xsl:if>
  </xsl:template>
  
  <!-- process each element item -->
  <xsl:template match="item">
      <xsl:if test="($number = 0) or (position() &lt;= $number)">
      
          <xsl:call-template name="itemJson">
              <xsl:with-param name="link"><xsl:value-of select="link"/></xsl:with-param>
              <xsl:with-param name="title"><xsl:value-of select="title"/></xsl:with-param>
              <xsl:with-param name="date"><xsl:value-of select="pubDate"/></xsl:with-param>
              <xsl:with-param name="description"><xsl:value-of select="description"/></xsl:with-param>
          </xsl:call-template>
      </xsl:if>
  </xsl:template>
  
  <xsl:template name="itemJson">
      
      <xsl:param name="title"></xsl:param>
      <xsl:param name="link"></xsl:param>
      <xsl:param name="description"></xsl:param>
      <xsl:param name="date"></xsl:param>      
      <xsl:variable name="quot">"</xsl:variable>
      <xsl:variable name="apos">'</xsl:variable>
      [
         <!--create a link back to the original post -->
        "&lt;a href='<xsl:value-of select="$link" />' target='_external';&gt;<xsl:value-of select="substring-before($title, '(')" />&lt;/a&gt;",
        <!-- find the location from the title location -->
        <xsl:variable name="before"><xsl:value-of select='substring-before($title, "(")'/></xsl:variable>
         <xsl:variable name="after"><xsl:value-of select='substring-after($title, ")")'/></xsl:variable>
         <xsl:variable name="len"><xsl:value-of select='floor(string-length($title) - string-length($after) - string-length($before))'/></xsl:variable>
         <xsl:variable name="loc"><xsl:value-of select='substring($title, string-length($before) + 2, $len - 2)'/></xsl:variable>
         <!-- get rid of quotes -->
         <xsl:variable name="cleanLoc"><xsl:value-of select="translate(translate(translate($loc, '//', ','), $apos, ''), $quot, '')" /></xsl:variable>
         <!-- create link to publish jmaki.publish('/jmaki/mapi', location) and remove quotes -->
         <xsl:variable name="llink"><xsl:value-of select="translate(translate(translate($loc, '//', ','), $apos, ''), $quot, '')" /></xsl:variable>     
         "&lt;a href='#' onclick=\&quot;javascript:jmaki.publish(&apos;/jmaki/mapit&apos;,&apos;<xsl:value-of select="$llink" />&apos;)\&quot;&gt;<xsl:value-of select='$cleanLoc' />&lt;/a&gt;",
        "$<xsl:value-of select='substring-after($title, ") $")'/>",
        "<xsl:value-of select='$date'/>"
      ]
      <!-- write the final comma -->
      <xsl:if test="(($number=0) and (position()!=last())) or (($number &gt; 0) and (position() != $number))">,</xsl:if>
     
  </xsl:template>

</xsl:stylesheet>