/*
// $Id: //open/mondrian/src/main/mondrian/gui/QueryPanel.java#11 $
// This software is subject to the terms of the Common Public License
// Agreement, available at the following URL:
// http://www.opensource.org/licenses/cpl.html.
// Copyright (C) 2002-2007 Julian Hyde and others
// Copyright (C) 2006-2007 Cincom Systems, Inc.
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
*/
package mondrian.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.text.DefaultEditorKit;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Query;
import mondrian.olap.Result;

import org.apache.log4j.Logger;

/**
 *
 * @author  sean
 * @version $Id: //open/mondrian/src/main/mondrian/gui/QueryPanel.java#11 $
 */
public class QueryPanel extends javax.swing.JPanel {

    private static final Logger LOGGER = Logger.getLogger(QueryPanel.class);

    Connection connection;
    JMenuItem queryMenuItem;
    int windowMenuIndex;
    Map schemaWindowMap;    // map of schema frames and schema menu items
    
    Workbench workbench;

    /** Creates new form QueryPanel */
    public QueryPanel(Workbench workbench) {
        this.workbench = workbench;
        initComponents();
    }

    public void setConnection(Connection c) {
        connection = c;
    }

    public Connection getConnection() {
        return connection;
    }

    //====================================================

    public void setMenuItem(JMenuItem mi) {
        this.queryMenuItem = mi;
    }

    public void setSchemaWindowMap(Map swindowMap) {
        this.schemaWindowMap = swindowMap;  // MAP OF FILE AND FRAME
        setCatalogs();
    }

    private void setCatalogs() {
        Vector v = new Vector();
        Iterator it = schemaWindowMap.values().iterator();  // schema menu items
        while (it.hasNext()) {
            JMenuItem elem = (JMenuItem) it.next();
            v.add(elem.getText());
        }
        ComboBoxModel cCatalogs = new DefaultComboBoxModel(v);
        schemaList.setModel(cCatalogs) ;
    }
    public void setWindowMenuIndex(int i) {
        this.windowMenuIndex = i;
    }

    /**
     * @return the workbench i18n converter
     */
    public I18n getResourceConverter() {
        return workbench.getResourceConverter();
    }

    public void initConnection(String smenutext) {
        schemaList.setSelectedItem(smenutext);
        connectButtonActionPerformed(null);
    }
    //=====================================================

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        jScrollPane3 = new javax.swing.JScrollPane();
        executeButton = new javax.swing.JButton();
        jSplitPane1 = new javax.swing.JSplitPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        queryTextPane = new javax.swing.JTextPane();
        jScrollPane2 = new javax.swing.JScrollPane();
        resultTextPane = new javax.swing.JTextPane();
        connectButton = new javax.swing.JButton();
        jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new DefaultEditorKit.CutAction());
        jPopupMenu.add(new DefaultEditorKit.CopyAction());
        jPopupMenu.add(new DefaultEditorKit.PasteAction());

        schemaScrollPane1 = new javax.swing.JScrollPane();
        schemaLabel = new javax.swing.JLabel();
        schemaList = new JComboBox( new String[] {getResourceConverter().getString("common.join.title","Join"),
                                                    getResourceConverter().getString("common.table.title","Table")} );
        //schemaScrollPane1.setViewportView(schemaList);
        schemaPanel = new JPanel();
        //schemaPanel.setLayout(new BorderLayout(25,0));
        schemaPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 10, 0));

        setLayout(new java.awt.BorderLayout());

        schemaLabel.setFont(new Font("Dialog", 1, 12));
        schemaLabel.setForeground((Color) UIManager.getDefaults().get("CheckBoxMenuItem.acceleratorForeground"));
        schemaLabel.setHorizontalAlignment(SwingConstants.CENTER);
        schemaLabel.setText(getResourceConverter().getString("common.schema.title","Schema"));
        //schemaLabel.setBorder(new EtchedBorder());

        schemaList.setBackground(Color.white);
        final JPanel qpanel = this;
        schemaList.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {


            }
        });
        connectButton.setText(getResourceConverter().getString("queryPanel.connect.title","Connect"));
        connectButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                connectButtonActionPerformed(evt);
            }
        });

        schemaPanel.add(schemaLabel); //java.awt.BorderLayout.WEST
        schemaPanel.add(schemaList);
        schemaPanel.add(connectButton);

        add(schemaPanel, java.awt.BorderLayout.NORTH);

        executeButton.setText(getResourceConverter().getString("queryPanel.execute.title","Execute"));
        executeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                executeButtonActionPerformed(evt);
            }
        });

        add(executeButton, java.awt.BorderLayout.SOUTH);

        jSplitPane1.setDividerLocation(100);
        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        queryTextPane.setFont(new java.awt.Font("Courier New", 0, 12));
        queryTextPane.setText("");
        queryTextPane.addMouseListener(new MouseAdapter() {
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int x = e.getX();
                    int y = e.getY();

                    jPopupMenu.show(queryTextPane, x, y);

                }
            }
        });

        jScrollPane1.setViewportView(queryTextPane);

        jSplitPane1.setTopComponent(jScrollPane1);

        resultTextPane.setEditable(false);
        resultTextPane.setFont(new java.awt.Font("Courier New", 0, 12));
        jScrollPane2.setViewportView(resultTextPane);

        jSplitPane1.setBottomComponent(jScrollPane2);

        add(jSplitPane1, java.awt.BorderLayout.CENTER);

    }

    private void executeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:T://event_executeButtonActionPerformed
        //run the query, and show the results.
        try {
            if (connection == null) {
                JOptionPane.showMessageDialog(this, getResourceConverter().getString("queryPanel.noConnection.alert","No Mondrian connection. Select a Schema to connect."), 
                        getResourceConverter().getString("common.alertDialog.title","Alert"), JOptionPane.WARNING_MESSAGE);
                return;
            }//common.alertDialog.title
            Query q = connection.parseQuery(queryTextPane.getText());
            Result r = connection.execute(q);

            //document = DOMBuilder.build(getResult());
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            r.print(pw);

            resultTextPane.setText(sw.getBuffer().toString());
        } catch (Exception ex) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();

            PrintStream p = new PrintStream(os);

            Throwable e = ex;
            while (e != null) {
                p.println(e.getLocalizedMessage());
                LOGGER.error("", e);
                Throwable prev = e;
                e = e.getCause();
                if (e == prev)
                  break;
                p.println();
              }

            resultTextPane.setText(os.toString());
        }

    }//GEN-LAST:T://event_executeButtonActionPerformed


    private void connectButtonActionPerformed(java.awt.event.ActionEvent evt) {
        File sfile = null;
        try {
            JInternalFrame sf = null;

            String sfname = (String) schemaList.getSelectedItem();
            Iterator it = schemaWindowMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry elem = (Map.Entry) it.next();
                if (((JMenuItem) elem.getValue()).getText().equals(sfname)) {
                    sf = (JInternalFrame) elem.getKey();
                    break;
                }
            }

            if (sf == null) {
                // this case may arise when a schema file is opened, mdx query is opened and the schema frame is closed
                JOptionPane.showMessageDialog(this, getResourceConverter().getString("queryPanel.schemaNotOpen.alert","Schema file is not open"), 
                                getResourceConverter().getString("common.errorDialog.title","Error"), JOptionPane.ERROR_MESSAGE);
                return;
            }

            //JInternalFrame sf = (JInternalFrame) schemaWindowMap.get(sfile);
            SchemaExplorer se = (SchemaExplorer) sf.getContentPane().getComponent(0);
            if (se.isNewFile()) {
                JOptionPane.showMessageDialog(this, getResourceConverter().getString("queryPanel.saveSchemaFirst.alert","You must first save the Schema to open a Mondrian connection"), 
                                getResourceConverter().getString("common.alertDialog.title","Alert"), JOptionPane.WARNING_MESSAGE);
                sf.setSelected(true);
                return;
            }
            sfile = se.getSchemaFile();

            String connectString = "Provider=mondrian;" + "Jdbc=" + se.getJdbcConnectionUrl() + ";" + "Catalog=" + se.getSchemaFile().toURL().toString() + ";";
            if (se.getJdbcUsername() != null && se.getJdbcUsername().length() > 0) {
                connectString = connectString + "JdbcUser=" + se.getJdbcUsername() + ";";
            }
            if (se.getJdbcPassword() != null && se.getJdbcPassword().length() > 0) {
                connectString = connectString + "JdbcPassword=" + se.getJdbcPassword() + ";";
            }

            Connection con = DriverManager.getConnection(connectString, null);
            if (con != null) {
                connection = con;
                queryMenuItem.setText(getResourceConverter().getFormattedString("queryPanel.successfulConnection.menuItem", 
                        "{0} MDX - {1}", 
                        new String[] { Integer.toString(windowMenuIndex), se.getSchemaFile().getName() }));
                Component o =  this;
                while (o != null) {
                    //System.out.println(""+o.getClass());
                    if (o.getClass() == JInternalFrame.class) {
                        ((JInternalFrame) o).setTitle(getResourceConverter().getFormattedString("queryPanel.successfulConnection.internalFrame.title", 
                                "MDX Query - connected to {0}", 
                                new String[] { se.getSchemaFile().getName() }));
                        break;
                    }
                    o =  o.getParent();
                }
                JOptionPane.showMessageDialog(this, "Mondrian connection Successful.", 
                        getResourceConverter().getString("common.informationDialog.title","Information") , JOptionPane.INFORMATION_MESSAGE);
            } else {
                JOptionPane.showMessageDialog(this, getResourceConverter().getFormattedString("queryPanel.unsuccessfulConnection.alert", 
                        "Mondrian connection could not be done for - {0}", 
                        new String[] { se.getSchemaFile().getName() }), 
                        getResourceConverter().getString("common.errorDialog.title","Error"), JOptionPane.ERROR_MESSAGE);
            }
        } catch (Exception ex) {
            LOGGER.error("Exception: "+ex.getMessage(), ex);
            JOptionPane.showMessageDialog(this, getResourceConverter().getFormattedString("queryPanel.unsuccessfulConnection.exception", 
                    "Mondrian connection could not be done for - {0}", 
                    new String[] { sfile == null ? getResourceConverter().getString("queryPanel.selectedSchema.alert","selected Schema") : sfile.getName() }), 
                        getResourceConverter().getString("common.errorDialog.title","Error"), JOptionPane.ERROR_MESSAGE);
        }
    }
    // Variables declaration - do not modify
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextPane resultTextPane;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextPane queryTextPane;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JButton executeButton;
    private javax.swing.JComboBox schemaList;
    private JLabel schemaLabel;
    private JPanel schemaPanel;
    private javax.swing.JScrollPane schemaScrollPane1;
    private javax.swing.JButton connectButton;
    private JPopupMenu jPopupMenu;

    // End of variables declaration

}

// End QueryPanel.java