/*
// $Id: //open/dt/dev/farrago/src/org/eigenbase/util/property/BooleanProperty.java#7 $
// Package org.eigenbase is a class library of data management components.
// Copyright (C) 2005-2005 The Eigenbase Project
// Copyright (C) 2002-2005 Disruptive Tech
// Copyright (C) 2005-2005 LucidEra, Inc.
// Portions Copyright (C) 2003-2005 John V. Sichi
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
//
// This library is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

package org.eigenbase.util.property;

import java.util.Properties;


/**
 * Definition and accessor for a boolean property.
 *
 * @author jhyde
 * @since May 4, 2004
 * @version $Id: //open/dt/dev/farrago/src/org/eigenbase/util/property/BooleanProperty.java#7 $
 **/
public class BooleanProperty extends Property
{
    //~ Constructors ----------------------------------------------------------

    /**
     * Creates a Boolean property.
     *
     * @param properties Properties object which holds values for this
     *    property.
     * @param path Name by which this property is serialized to a properties
     *    file, for example "com.acme.trace.Verbosity".
     * @param defaultValue Default value, null if there is no default.
     */
    public BooleanProperty(
        Properties properties,
        String path,
        boolean defaultValue)
    {
        super(properties, path, defaultValue ? "true" : "false");
    }

    /**
     * Creates a Boolean property which has no default value.
     *
     * @param properties Properties object which holds values for this
     *    property.
     * @param path Name by which this property is serialized to a properties
     *    file, for example "com.acme.trace.Verbosity".
     */
    public BooleanProperty(
        Properties properties,
        String path)
    {
        super(properties, path, null);
    }

    //~ Methods ---------------------------------------------------------------

    /**
     * Retrieves the value of this boolean property.
     *
     * <p>Returns <code>true</code> if the property exists,
     * and its value is <code>1</code>, <code>true</code>
     * or <code>yes</code>;
     * returns <code>false</code> otherwise.
     */
    public boolean get()
    {
        return booleanValue();
    }

    /**
     * Retrieves the value of this boolean property.
     *
     * <p>Returns <code>true</code> if the property exists,
     * and its value is <code>1</code>, <code>true</code>
     * or <code>yes</code>;
     * returns <code>false</code> otherwise.
     */
    public boolean get(boolean defaultValue)
    {
        final String value = getInternal(null, false);
        if (value == null) {
            return defaultValue;
        }
        return toBoolean(value);
    }

}


// End BooleanProperty.java
