/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.wcf.tree.TreeBounding;
import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.tree.TreeModelChangeEvent;
import com.tonbeller.wcf.tree.TreeModelChangeListener;
import com.tonbeller.wcf.tree.TreeModelChangeSupport;
import com.tonbeller.wcf.tree.TreeModelDecorator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class EnumBoundedTreeModelDecorator
extends TreeModelDecorator
implements TreeBounding,
TreeModelChangeListener {
    Map childrenMap;
    TreeModelChangeSupport changeSupport;

    public EnumBoundedTreeModelDecorator(TreeModel decoree) {
        super(decoree);
        this.childrenMap = new HashMap();
        this.changeSupport = new TreeModelChangeSupport(this);
        this.setDecoree(decoree);
    }

    public EnumBoundedTreeModelDecorator(TreeModel decoree, Comparator nodeComparator) {
        super(decoree);
        this.childrenMap = new TreeMap(nodeComparator);
        this.changeSupport = new TreeModelChangeSupport(this);
        this.setDecoree(decoree);
    }

    public void setDecoree(TreeModel model) {
        TreeModel decoree = this.getDecoree();
        if (decoree != null) {
            decoree.removeTreeModelChangeListener(this);
        }
        super.setDecoree(model);
        decoree = this.getDecoree();
        if (decoree != null) {
            decoree.addTreeModelChangeListener(this);
        }
    }

    public boolean isBounded(Object parent) {
        return this.childrenMap.containsKey(parent);
    }

    public void unbound(Object parent) {
        if (this.childrenMap.remove(parent) != null) {
            this.changeSupport.fireModelChanged(false, parent);
        }
    }

    public boolean hasChildren(Object node) {
        Object[] children = (Object[])this.childrenMap.get(node);
        if (children != null) {
            return true;
        }
        return super.hasChildren(node);
    }

    public Object[] getChildren(Object node) {
        Object[] children = (Object[])this.childrenMap.get(node);
        if (children != null) {
            return children;
        }
        return super.getChildren(node);
    }

    public void setVisible(Collection nodes) {
        this.setVisible(this.getDecoree(), nodes);
    }

    public void setVisible(TreeModel model, Collection nodes) {
        this.childrenMap.clear();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            Object node = it.next();
            while (node != null) {
                Object parent = model.getParent(node);
                this.addVisible(parent, node);
                node = parent;
            }
        }
    }

    private void addVisible(Object parent, Object child) {
        if (parent == null || child == null) {
            return;
        }
        Object[] children = (Object[])this.childrenMap.get(parent);
        if (children == null) {
            this.childrenMap.put(parent, new Object[]{child});
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].equals(child)) continue;
            return;
        }
        Object[] newChildren = new Object[children.length + 1];
        System.arraycopy(children, 0, newChildren, 0, children.length);
        newChildren[children.length] = child;
        this.childrenMap.put(parent, newChildren);
    }

    public void addTreeModelChangeListener(TreeModelChangeListener l) {
        this.changeSupport.addTreeModelChangeListener(l);
    }

    public void fireModelChanged(boolean identityChanged) {
        this.changeSupport.fireModelChanged(identityChanged);
    }

    public void removeTreeModelChangeListener(TreeModelChangeListener l) {
        this.changeSupport.removeTreeModelChangeListener(l);
    }

    public void treeModelChanged(TreeModelChangeEvent event) {
        this.changeSupport.fireModelChanged(event);
    }
}

