/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.controller;

import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestContextFactory;
import com.tonbeller.wcf.controller.RequestContextFactoryImpl;
import com.tonbeller.wcf.utils.SoftException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class RequestContextFactoryFinder {
    private static Logger logger = Logger.getLogger((Class)RequestContextFactoryFinder.class);
    private static final String SESSION_KEY = RequestContextFactory.class.getName();
    private static final String CONTEXT_KEY = "com.tonbeller.wcf.controller.RequestContextFactory";

    public static RequestContextFactory findFactory(HttpSession session) {
        RequestContextFactory rcf;
        try {
            rcf = (RequestContextFactory)session.getAttribute(SESSION_KEY);
            if (rcf == null) {
                ServletContext context = session.getServletContext();
                String className = context.getInitParameter(CONTEXT_KEY);
                if (className == null) {
                    className = RequestContextFactoryImpl.class.getName();
                }
                rcf = (RequestContextFactory)Class.forName(className).newInstance();
                session.setAttribute(SESSION_KEY, (Object)rcf);
            }
        }
        catch (InstantiationException e) {
            logger.error(null, (Throwable)e);
            throw new SoftException(e);
        }
        catch (IllegalAccessException e) {
            logger.error(null, (Throwable)e);
            throw new SoftException(e);
        }
        catch (ClassNotFoundException e) {
            logger.error(null, (Throwable)e);
            throw new SoftException(e);
        }
        return rcf;
    }

    public static RequestContext createContext(HttpServletRequest request, HttpServletResponse response, boolean threadLocal) {
        HttpSession session = request.getSession(true);
        RequestContextFactory rcf = RequestContextFactoryFinder.findFactory(session);
        RequestContext context = rcf.createContext(request, response);
        if (threadLocal) {
            RequestContext.setInstance(context);
        }
        return context;
    }
}

