/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.table;

import com.tonbeller.wcf.table.AbstractTableModel;
import com.tonbeller.wcf.table.DefaultCell;
import com.tonbeller.wcf.table.DefaultTableRow;
import com.tonbeller.wcf.table.TableRow;
import java.sql.Date;
import java.text.DecimalFormat;
import java.util.Random;

public class TestModel
extends AbstractTableModel {
    String[] columnTitles = new String[]{"String", "Date", "Double", "Integer", "Click Me", "Image 1", "Image 2"};
    TableRow[] rows;
    Random rnd = new Random(1234527L);
    String title = "Test Table model";

    public TestModel() {
        int N = 20;
        this.rows = new TableRow[N];
        DecimalFormat df = new DecimalFormat("00");
        for (int i = 0; i < N; ++i) {
            DefaultCell h1 = new DefaultCell("/", new Integer(this.rnd.nextInt(1000)), null);
            DefaultCell h2 = new DefaultCell("/", null, this.nextImg());
            DefaultCell h3 = new DefaultCell("/", "Text " + this.rnd.nextInt(100), this.nextImg());
            String s = "2002-02-" + df.format(i + 1);
            Object[] values = new Object[]{"Hello World: " + i, Date.valueOf(s), new Double((double)this.rnd.nextInt(10000) / (double)this.rnd.nextInt(100)), new Integer(this.rnd.nextInt(1000)), h1, h2, h3};
            this.rows[i] = new DefaultTableRow(values);
        }
    }

    public String nextImg() {
        if (this.rnd.nextBoolean()) {
            return "wcf/table/sort-ac.png";
        }
        return "wcf/table/sort-dn.png";
    }

    public int getRowCount() {
        return this.rows.length;
    }

    public TableRow getRow(int rowIndex) {
        return this.rows[rowIndex];
    }

    public int getColumnCount() {
        return this.columnTitles.length;
    }

    public String getColumnTitle(int columnIndex) {
        return this.columnTitles[columnIndex];
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }
}

