/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.format;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.format.Formatter;
import com.tonbeller.wcf.utils.SoftException;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FormatterFactory {
    private static Logger logger = Logger.getLogger((Class)FormatterFactory.class);

    private FormatterFactory() {
    }

    public static Formatter instance(Locale locale) {
        URL defaultXml = Formatter.class.getResource("config.xml");
        Formatter formatter = new Formatter();
        FormatterFactory.fillFormatter(formatter, locale, defaultXml);
        String s = Resources.instance().getOptionalString("wcf.formatter.config.xml", null);
        if (s != null) {
            URL analyseXml = Formatter.class.getResource(s);
            FormatterFactory.fillFormatter(formatter, locale, analyseXml);
        }
        return formatter;
    }

    private static void fillFormatter(Formatter formatter, Locale locale, URL configXml) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        URL rulesXml = Formatter.class.getResource("rules.xml");
        Digester digester = DigesterLoader.createDigester((URL)rulesXml);
        digester.setValidating(false);
        digester.push((Object)formatter);
        try {
            digester.parse(new InputSource(configXml.toExternalForm()));
        }
        catch (IOException e) {
            logger.error((Object)"exception caught", (Throwable)e);
            throw new SoftException(e);
        }
        catch (SAXException e) {
            logger.error((Object)"exception caught", (Throwable)e);
            throw new SoftException(e);
        }
        formatter.setLocale(locale);
    }
}

