/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.param;

import com.tonbeller.wcf.param.SqlAndExpr;
import com.tonbeller.wcf.param.SqlBetweenExpr;
import com.tonbeller.wcf.param.SqlColumnConstraint;
import com.tonbeller.wcf.param.SqlDummyExpr;
import com.tonbeller.wcf.param.SqlEqualExpr;
import com.tonbeller.wcf.param.SqlExpr;
import com.tonbeller.wcf.param.SqlExprVisitor;
import com.tonbeller.wcf.param.SqlExprWithOperands;
import com.tonbeller.wcf.param.SqlInExpr;
import com.tonbeller.wcf.param.SqlOrExpr;
import com.tonbeller.wcf.utils.SqlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SqlGenerator
implements SqlExprVisitor {
    StringBuffer sb;
    Map columnMap;
    public static final String DEFAULT_COLUMN_ID = "DEFAULT_COLUMN_ID";

    public SqlGenerator() {
        this.columnMap = new HashMap();
    }

    public SqlGenerator(String defaultColumn) {
        this.columnMap = new HashMap();
        this.columnMap.put(DEFAULT_COLUMN_ID, defaultColumn);
    }

    public SqlGenerator(Map columnMap) {
        this.columnMap = columnMap;
    }

    protected SqlGenerator copyGenerator() {
        return new SqlGenerator(this.columnMap);
    }

    protected String generateOpd(SqlExpr opd) {
        return this.copyGenerator().generate(opd);
    }

    protected String getColumnName(SqlColumnConstraint scc) {
        String qname;
        String columnId = scc.getColumnId();
        if (columnId == null) {
            columnId = DEFAULT_COLUMN_ID;
        }
        if ((qname = (String)this.columnMap.get(columnId)) != null) {
            return qname;
        }
        return columnId;
    }

    public void genAndOr(SqlExprWithOperands exp, String keyword) {
        Iterator it = exp.getOperands().iterator();
        SqlExpr opd = (SqlExpr)it.next();
        this.sb.append("(");
        this.sb.append(this.generateOpd(opd));
        while (it.hasNext()) {
            this.sb.append(" ");
            this.sb.append(keyword);
            this.sb.append(" ");
            opd = (SqlExpr)it.next();
            this.sb.append(this.generateOpd(opd));
        }
        this.sb.append(")");
    }

    public void visitSqlAndExpr(SqlAndExpr exp) {
        this.genAndOr(exp, "AND");
    }

    public void visitSqlOrExpr(SqlOrExpr exp) {
        this.genAndOr(exp, "OR");
    }

    public void visitSqlBetweenExpr(SqlBetweenExpr exp) {
        this.sb.append(this.getColumnName(exp));
        this.sb.append(" BETWEEN ");
        this.sb.append(SqlUtils.escapeSql(exp.getFirst()));
        this.sb.append(" AND ");
        this.sb.append(SqlUtils.escapeSql(exp.getLast()));
    }

    public void visitSqlEqualExpr(SqlEqualExpr exp) {
        this.generateEquals(exp, exp.getSqlValue());
    }

    private void generateEquals(SqlColumnConstraint exp, Object sqlValue) {
        this.sb.append(this.getColumnName(exp));
        if (sqlValue == null) {
            this.sb.append(" IS NULL");
        } else {
            this.sb.append(" = ");
            this.sb.append(SqlUtils.escapeSql(sqlValue));
        }
    }

    public void visitSqlDummyExpr(SqlDummyExpr exp) {
        this.sb.append("1 = 1");
    }

    public void visitSqlInExpr(SqlInExpr exp) {
        Object[] values = exp.getSqlValues();
        String cname = this.getColumnName(exp);
        boolean containsNull = this.containsNull(values);
        if (containsNull) {
            values = this.removeNulls(values);
        }
        if (values.length == 0) {
            if (containsNull) {
                this.sb.append(cname).append(" IS NULL");
            } else {
                this.sb.append("1=0");
            }
        } else if (values.length == 1) {
            if (containsNull) {
                this.sb.append("(");
                this.sb.append(cname);
                this.sb.append(" = ");
                this.sb.append(SqlUtils.escapeSql(values[0]));
                this.sb.append(" OR ");
                this.sb.append(cname);
                this.sb.append(" IS NULL)");
            } else {
                this.sb.append(cname);
                this.sb.append(" = ");
                this.sb.append(SqlUtils.escapeSql(values[0]));
            }
        } else {
            String list = this.generateList(values);
            if (containsNull) {
                this.sb.append("(");
                this.sb.append(cname);
                this.sb.append(" IN (");
                this.sb.append(list);
                this.sb.append(") OR ");
                this.sb.append(cname);
                this.sb.append(" IS NULL)");
            } else {
                this.sb.append(cname);
                this.sb.append(" IN (");
                this.sb.append(list);
                this.sb.append(")");
            }
        }
    }

    protected String generateList(Object[] values) {
        StringBuffer list = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                list.append(", ");
            }
            list.append(SqlUtils.escapeSql(values[i]));
        }
        return list.toString();
    }

    protected Object[] removeNulls(Object[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            list.add(values[i]);
        }
        return list.toArray();
    }

    protected boolean containsNull(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            return true;
        }
        return false;
    }

    public String generate(SqlExpr sqlExpr) {
        this.sb = new StringBuffer();
        sqlExpr.accept(this);
        return this.sb.toString();
    }

    public Map getColumnMap() {
        return this.columnMap;
    }

    public void setColumnMap(Map columnMap) {
        this.columnMap = columnMap;
    }
}

