/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLLicencePanel
extends IzPanel
implements HyperlinkListener,
ActionListener {
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    private JLabel infoLabel;
    private JEditorPane textArea;
    private JLabel agreeLabel;
    private JRadioButton yesRadio;
    private JRadioButton noRadio;

    public HTMLLicencePanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        Serializable serializable;
        this.setLayout(this.layout);
        this.loadLicence();
        this.infoLabel = new JLabel(installerFrame.langpack.getString("LicencePanel.info"), installerFrame.icons.getImageIcon("history"), 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, 0, 2, 1, 1.0, 0.0);
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 17;
        this.layout.addLayoutComponent(this.infoLabel, this.gbConstraints);
        this.add(this.infoLabel);
        try {
            this.textArea = new JEditorPane();
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(this);
            serializable = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadLicence());
            installerFrame.buildConstraints(this.gbConstraints, 0, 1, 2, 1, 1.0, 1.0);
            this.gbConstraints.anchor = 10;
            this.gbConstraints.fill = 1;
            this.layout.addLayoutComponent((Component)serializable, this.gbConstraints);
            this.add((Component)serializable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.agreeLabel = new JLabel(installerFrame.langpack.getString("LicencePanel.agree"), installerFrame.icons.getImageIcon("help"), 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, 2, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 17;
        this.gbConstraints.fill = 0;
        this.layout.addLayoutComponent(this.agreeLabel, this.gbConstraints);
        this.add(this.agreeLabel);
        serializable = new ButtonGroup();
        this.yesRadio = new JRadioButton(installerFrame.langpack.getString("LicencePanel.yes"), false);
        ((ButtonGroup)serializable).add(this.yesRadio);
        installerFrame.buildConstraints(this.gbConstraints, 0, 3, 1, 1, 0.5, 0.0);
        this.gbConstraints.anchor = 17;
        this.layout.addLayoutComponent(this.yesRadio, this.gbConstraints);
        this.add(this.yesRadio);
        this.yesRadio.addActionListener(this);
        this.noRadio = new JRadioButton(installerFrame.langpack.getString("LicencePanel.no"), false);
        ((ButtonGroup)serializable).add(this.noRadio);
        installerFrame.buildConstraints(this.gbConstraints, 1, 3, 1, 1, 0.5, 0.0);
        this.gbConstraints.anchor = 13;
        this.layout.addLayoutComponent(this.noRadio, this.gbConstraints);
        this.add(this.noRadio);
        this.noRadio.addActionListener(this);
    }

    private URL loadLicence() {
        String string = "HTMLLicencePanel.licence";
        try {
            return ResourceManager.getInstance().getURL(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        try {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.textArea.setPage(hyperlinkEvent.getURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }
}

