/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.modules;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.modules.Messages;

public class CmsDependenciesOverview
extends CmsWidgetDialog {
    public static final String DIALOG_TYPE = "DependenciesOverview";
    public static final String[] PAGES = new String[]{"page1"};
    private CmsModuleDependency m_dependency;
    private String m_paramDependency;
    private String m_paramModule;

    public CmsDependenciesOverview(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDependenciesOverview(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
    }

    public String buildDialogForm() {
        StringBuffer result = new StringBuffer(1024);
        try {
            result.append(this.createDialogHtml(this.getParamPage()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result.toString();
    }

    public String getCancelAction() {
        this.setParamPage((String)this.getPages().get(0));
        return "set";
    }

    public String getParamDependency() {
        return this.m_paramDependency;
    }

    public String getParamModule() {
        return this.m_paramModule;
    }

    public void setParamDependency(String paramDependency) {
        this.m_paramDependency = paramDependency;
    }

    public void setParamModule(String paramModule) {
        this.m_paramModule = paramModule;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("label.dependencyinformation")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 1));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initModule();
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_dependency, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_dependency, "version.version", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initModule() {
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction()) ? (CmsStringUtil.isNotEmpty((String)this.m_paramModule) ? OpenCms.getModuleManager().getModule(this.m_paramModule) : null) : this.getDialogObject();
        CmsModule module = !(o instanceof CmsModule) ? new CmsModule() : (CmsModule)((CmsModule)o).clone();
        List dependencies = module.getDependencies();
        this.m_dependency = new CmsModuleDependency();
        if (dependencies != null && dependencies.size() > 0) {
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                CmsModuleDependency dependency = (CmsModuleDependency)i.next();
                if (!dependency.getName().equals(this.m_paramDependency)) continue;
                this.m_dependency = dependency;
            }
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(DIALOG_TYPE);
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_dependency);
    }

    protected void validateParamaters() throws Exception {
        String moduleName = this.getParamModule();
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        if (module == null) {
            throw new Exception();
        }
        Iterator it = module.getDependencies().iterator();
        while (it.hasNext()) {
            CmsModuleDependency dep = (CmsModuleDependency)it.next();
            if (!dep.getName().equals(this.getParamDependency())) continue;
            return;
        }
        throw new Exception();
    }
}

