/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.modules;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsExportPoint;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.modules.Messages;

public class CmsExportpointsOverview
extends CmsWidgetDialog {
    public static final String DIALOG_TYPE = "ExportpointsOverview";
    public static final String[] PAGES = new String[]{"page1"};
    private CmsExportPoint m_exportpoint;
    private String m_paramExportpoint;
    private String m_paramModule;

    public CmsExportpointsOverview(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsExportpointsOverview(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
    }

    public String buildDialogForm() {
        StringBuffer result = new StringBuffer(1024);
        try {
            result.append(this.createDialogHtml(this.getParamPage()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result.toString();
    }

    public String getCancelAction() {
        this.setParamPage((String)this.getPages().get(0));
        return "set";
    }

    public String getParamExportpoint() {
        return this.m_paramExportpoint;
    }

    public String getParamModule() {
        return this.m_paramModule;
    }

    public void setParamExportpoint(String paramExportpoint) {
        this.m_paramExportpoint = paramExportpoint;
    }

    public void setParamModule(String paramModule) {
        this.m_paramModule = paramModule;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("label.exportpointinformation")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 2));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initModule();
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportpoint, "uri", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportpoint, "configuredDestination", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportpoint, "destinationPath", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initModule() {
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction()) ? (CmsStringUtil.isNotEmpty((String)this.m_paramModule) ? OpenCms.getModuleManager().getModule(this.m_paramModule) : null) : this.getDialogObject();
        CmsModule module = !(o instanceof CmsModule) ? new CmsModule() : (CmsModule)((CmsModule)o).clone();
        List exportpoints = module.getExportPoints();
        this.m_exportpoint = new CmsExportPoint();
        if (exportpoints != null && exportpoints.size() > 0) {
            Iterator i = exportpoints.iterator();
            while (i.hasNext()) {
                CmsExportPoint exportpoint = (CmsExportPoint)i.next();
                if (!exportpoint.getUri().equals(this.m_paramExportpoint)) continue;
                this.m_exportpoint = exportpoint;
            }
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(DIALOG_TYPE);
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_exportpoint);
    }

    protected void validateParamaters() throws Exception {
        String moduleName = this.getParamModule();
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        if (module == null) {
            throw new Exception();
        }
        Iterator it = module.getExportPoints().iterator();
        while (it.hasNext()) {
            CmsExportPoint ep = (CmsExportPoint)it.next();
            if (!ep.getUri().equals(this.getParamExportpoint())) continue;
            return;
        }
        throw new Exception();
    }
}

