/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.modules;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsExportPoint;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.modules.CmsModulesList;
import org.opencms.workplace.tools.modules.Messages;

public class CmsModulesEditBase
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "modules";
    public static final String DIALOG_TYPE = "ModulesEdit";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PATH_CLASSES = "classes/";
    public static final String PATH_ELEMENTS = "elements/";
    public static final String PATH_LIB = "lib/";
    public static final String PATH_RESOURCES = "resources/";
    public static final String PATH_TEMPLATES = "templates/";
    protected CmsModule m_module;
    protected String m_paramModule;

    public CmsModulesEditBase(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsModulesEditBase(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        Map objects;
        if (!this.hasCommitErrors()) {
            Set moduleNames = OpenCms.getModuleManager().getModuleNames();
            if (moduleNames.contains(this.m_module.getName())) {
                try {
                    OpenCms.getModuleManager().updateModule(this.getCms(), this.m_module);
                }
                catch (CmsException e) {
                    this.addCommitError((Exception)((Object)e));
                }
            } else {
                try {
                    this.m_module = this.createModuleFolders((CmsModule)this.m_module.clone());
                    OpenCms.getModuleManager().addModule(this.getCms(), this.m_module);
                }
                catch (CmsException e) {
                    this.addCommitError((Exception)((Object)e));
                }
            }
        }
        if (!this.hasCommitErrors() && (objects = (Map)this.getSettings().getListObject()) != null) {
            objects.remove(CmsModulesList.class.getName());
        }
    }

    public String getCancelAction() {
        this.setParamPage((String)this.getPages().get(0));
        return "set";
    }

    public String getParamModule() {
        return this.m_paramModule;
    }

    public void setParamModule(String paramModule) {
        this.m_paramModule = paramModule;
    }

    protected void defineWidgets() {
        this.initModule();
        this.setKeyPrefix(KEY_PREFIX);
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initModule() {
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction()) ? (CmsStringUtil.isNotEmpty((String)this.m_paramModule) ? OpenCms.getModuleManager().getModule(this.m_paramModule) : null) : this.getDialogObject();
        this.m_module = !(o instanceof CmsModule) ? new CmsModule() : (CmsModule)((CmsModule)o).clone();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(DIALOG_TYPE);
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_module);
    }

    protected void validateParamaters() throws Exception {
        CmsModule module;
        String moduleName = this.getParamModule();
        if (!this.isNewModule() && (module = OpenCms.getModuleManager().getModule(moduleName)) == null) {
            throw new Exception();
        }
    }

    private CmsModule createModuleFolders(CmsModule module) throws CmsException {
        CmsExportPoint exp;
        String path;
        String modulePath = "/system/modules/" + module.getName() + "/";
        List exportPoints = module.getExportPoints();
        List resources = module.getResources();
        if (module.isCreateClassesFolder() || module.isCreateElementsFolder() || module.isCreateLibFolder() || module.isCreateResourcesFolder() || module.isCreateTemplateFolder()) {
            module.setCreateModuleFolder(true);
        }
        if (module.isCreateModuleFolder()) {
            this.getCms().createResource(modulePath, CmsResourceTypeFolder.getStaticTypeId());
            resources.add(modulePath);
            module.setResources(resources);
        }
        if (module.isCreateTemplateFolder()) {
            path = modulePath + PATH_TEMPLATES;
            this.getCms().createResource(path, CmsResourceTypeFolder.getStaticTypeId());
        }
        if (module.isCreateElementsFolder()) {
            path = modulePath + PATH_ELEMENTS;
            this.getCms().createResource(path, CmsResourceTypeFolder.getStaticTypeId());
        }
        if (module.isCreateTemplateFolder()) {
            path = modulePath + PATH_RESOURCES;
            this.getCms().createResource(path, CmsResourceTypeFolder.getStaticTypeId());
        }
        if (module.isCreateLibFolder()) {
            path = modulePath + PATH_LIB;
            this.getCms().createResource(path, CmsResourceTypeFolder.getStaticTypeId());
            exp = new CmsExportPoint(path, "WEB-INF/lib/");
            exportPoints.add(exp);
            module.setExportPoints(exportPoints);
        }
        if (module.isCreateClassesFolder()) {
            path = modulePath + PATH_CLASSES;
            this.getCms().createResource(path, CmsResourceTypeFolder.getStaticTypeId());
            exp = new CmsExportPoint(path, "WEB-INF/classes/");
            exportPoints.add(exp);
            module.setExportPoints(exportPoints);
            StringTokenizer tok = new StringTokenizer(this.m_module.getName(), ".");
            while (tok.hasMoreTokens()) {
                String folder = tok.nextToken();
                path = path + folder + "/";
                this.getCms().createResource(path, CmsResourceTypeFolder.getStaticTypeId());
            }
        }
        return module;
    }

    private boolean isNewModule() {
        return this.getCurrentToolPath().equals("/modules/modules_new");
    }
}

