/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.modules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.modules.CmsModulesListGroupFormatter;
import org.opencms.workplace.tools.modules.Messages;

public class CmsModulesList
extends A_CmsListDialog {
    public static final String LIST_ACTION_DELETE = "ad";
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_ACTION_EXPORT = "ax";
    public static final String LIST_ACTION_OVERVIEW = "ao";
    public static final String LIST_COLUMN_DELETE = "cd";
    public static final String LIST_COLUMN_EDIT = "ce";
    public static final String LIST_COLUMN_EXPORT = "cx";
    public static final String LIST_COLUMN_GROUP = "cg";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_NICENAME = "cc";
    public static final String LIST_COLUMN_VERSION = "cv";
    public static final String LIST_DETAIL_AUTHORINFO = "da";
    public static final String LIST_DETAIL_DEPENDENCIES = "dd";
    public static final String LIST_DETAIL_RESOURCES = "resourcestinfo";
    public static final String LIST_DETAIL_RESTYPES = "restypesinfo";
    public static final String LIST_ID = "modules";
    public static final String LIST_MACTION_DELETE = "md";
    public static final String PARAM_MODULE = "module";
    public static final String PATH_BUTTONS = "tools/modules/buttons/";
    public static final String PATH_REPORTS = "/system/workplace/admin/modules/reports/";

    public CmsModulesList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_MODULES_LIST_NAME_0"), LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsModulesList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() throws IOException, ServletException {
        if (this.getParamListAction().equals(LIST_MACTION_DELETE)) {
            String moduleList = "";
            Iterator itItems = this.getSelectedItems().iterator();
            StringBuffer modules = new StringBuffer(32);
            while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                modules.append(listItem.getId());
                modules.append(",");
            }
            moduleList = new String(modules);
            moduleList = moduleList.substring(0, moduleList.length() - 1);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(PARAM_MODULE, moduleList);
            params.put("action", "initial");
            params.put("style", "new");
            this.getToolManager().jspForwardPage((CmsWorkplace)this, "/system/workplace/admin/modules/reports/delete.jsp", params);
        }
        this.listSave();
    }

    public void executeListSingleActions() throws IOException, ServletException {
        String module = this.getSelectedItem().getId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_MODULE, module);
        if (this.getParamListAction().equals(LIST_ACTION_EDIT)) {
            params.put("action", "initial");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/modules/edit/edit", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_OVERVIEW)) {
            params.put("action", "initial");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/modules/edit", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_DELETE)) {
            params.put("action", "initial");
            params.put("style", "new");
            this.getToolManager().jspForwardPage((CmsWorkplace)this, "/system/workplace/admin/modules/reports/delete.jsp", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_EXPORT)) {
            params.put("action", "initial");
            params.put("style", "new");
            this.getToolManager().jspForwardPage((CmsWorkplace)this, "/system/workplace/admin/modules/reports/export.jsp", params);
        }
        this.listSave();
    }

    protected void fillDetails(String detailId) {
        List moduleNames = this.getList().getAllContent();
        Iterator i = moduleNames.iterator();
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        while (i.hasNext()) {
            CmsListItem item = (CmsListItem)i.next();
            String moduleName = item.getId();
            CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
            StringBuffer html = new StringBuffer(32);
            if (detailId.equals(LIST_DETAIL_AUTHORINFO)) {
                html.append(module.getAuthorName());
                html.append("&nbsp;(");
                html.append(module.getAuthorEmail());
                html.append(")");
            } else if (detailId.equals(LIST_DETAIL_RESOURCES)) {
                Iterator j = module.getResources().iterator();
                while (j.hasNext()) {
                    String resource = (String)j.next();
                    html.append(resource);
                    html.append("<br>");
                }
            } else if (detailId.equals(LIST_DETAIL_DEPENDENCIES)) {
                Iterator k = module.getDependencies().iterator();
                while (k.hasNext()) {
                    CmsModuleDependency dep = (CmsModuleDependency)k.next();
                    html.append(dep.getName());
                    html.append("&nbsp;Version:");
                    html.append(dep.getVersion());
                    html.append("<br>");
                }
            } else {
                if (!detailId.equals(LIST_DETAIL_RESTYPES)) continue;
                StringBuffer restypes = new StringBuffer(32);
                Iterator l = module.getResourceTypes().iterator();
                boolean addRestypes = false;
                while (l.hasNext()) {
                    addRestypes = true;
                    I_CmsResourceType resourceType = (I_CmsResourceType)l.next();
                    restypes.append(messages.key("GUI_MODULES_LABEL_RESTYPES_DETAIL_0"));
                    restypes.append(":&nbsp;");
                    restypes.append(resourceType.getTypeName());
                    restypes.append("&nbsp;ID:");
                    restypes.append(resourceType.getTypeId());
                    restypes.append("<br>");
                }
                StringBuffer explorersettings = new StringBuffer(32);
                Iterator m = module.getExplorerTypes().iterator();
                boolean addExplorersettings = false;
                while (m.hasNext()) {
                    addExplorersettings = true;
                    CmsExplorerTypeSettings settings = (CmsExplorerTypeSettings)m.next();
                    explorersettings.append(messages.key("GUI_MODULES_LABEL_EXPLORERSETTINGSS_DETAIL_0"));
                    explorersettings.append(":&nbsp;");
                    explorersettings.append(settings.getName());
                    explorersettings.append("&nbsp;(");
                    explorersettings.append(settings.getReference());
                    explorersettings.append(")<br>");
                }
                if (addRestypes) {
                    html.append(restypes);
                }
                if (addExplorersettings) {
                    html.append(explorersettings);
                }
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected List getListItems() {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        Set moduleNames = OpenCms.getModuleManager().getModuleNames();
        Iterator i = moduleNames.iterator();
        while (i.hasNext()) {
            String moduleName = (String)i.next();
            CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
            CmsListItem item = this.getList().newItem(module.getName());
            item.set(LIST_COLUMN_NAME, (Object)moduleName);
            item.set(LIST_COLUMN_NICENAME, (Object)module.getNiceName());
            item.set(LIST_COLUMN_VERSION, (Object)module.getVersion());
            item.set(LIST_COLUMN_GROUP, (Object)module.getGroup());
            ret.add(item);
        }
        return ret;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editCol.setName(Messages.get().container("GUI_MODULES_LIST_COLS_EDIT_0"));
        editCol.setWidth("20");
        editCol.setSorteable(false);
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        CmsListDirectAction editColAction = new CmsListDirectAction(LIST_ACTION_EDIT);
        editColAction.setName(Messages.get().container("GUI_MODULES_LIST_ACTION_EDIT_NAME_0"));
        editColAction.setHelpText(Messages.get().container("GUI_MODULES_LIST_ACTION_EDIT_HELP_0"));
        editColAction.setIconPath("tools/modules/buttons/modules.png");
        editColAction.setEnabled(true);
        editColAction.setConfirmationMessage(null);
        editCol.addDirectAction((I_CmsListDirectAction)editColAction);
        metadata.addColumn(editCol);
        CmsListColumnDefinition expCol = new CmsListColumnDefinition(LIST_COLUMN_EXPORT);
        expCol.setName(Messages.get().container("GUI_MODULES_LIST_COLS_EXPORT_0"));
        expCol.setWidth("20");
        expCol.setSorteable(false);
        expCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        CmsListDirectAction expModule = new CmsListDirectAction(LIST_ACTION_EXPORT);
        expModule.setName(Messages.get().container("GUI_MODULES_LIST_ACTION_EXPORT_NAME_0"));
        expModule.setConfirmationMessage(Messages.get().container("GUI_MODULES_LIST_ACTION_EXPORT_CONF_0"));
        expModule.setIconPath("tools/modules/buttons/export.png");
        expModule.setEnabled(true);
        expModule.setHelpText(Messages.get().container("GUI_MODULES_LIST_ACTION_EXPORT_HELP_0"));
        expCol.addDirectAction((I_CmsListDirectAction)expModule);
        metadata.addColumn(expCol);
        CmsListColumnDefinition delCol = new CmsListColumnDefinition(LIST_COLUMN_DELETE);
        delCol.setName(Messages.get().container("GUI_MODULES_LIST_COLS_DELETE_0"));
        delCol.setWidth("20");
        delCol.setSorteable(false);
        delCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        CmsListDirectAction delModule = new CmsListDirectAction(LIST_ACTION_DELETE);
        delModule.setName(Messages.get().container("GUI_MODULES_LIST_ACTION_DELETE_NAME_0"));
        delModule.setConfirmationMessage(Messages.get().container("GUI_MODULES_LIST_ACTION_DELETE_CONF_0"));
        delModule.setIconPath("list/delete.png");
        delModule.setEnabled(true);
        delModule.setHelpText(Messages.get().container("GUI_MODULES_LIST_ACTION_DELETE_HELP_0"));
        delCol.addDirectAction((I_CmsListDirectAction)delModule);
        metadata.addColumn(delCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_MODULES_LIST_COLS_NAME_0"));
        nameCol.setWidth("30%");
        nameCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        CmsListDefaultAction nameColAction = new CmsListDefaultAction(LIST_ACTION_OVERVIEW);
        nameColAction.setName(Messages.get().container("GUI_MODULES_LIST_ACTION_OVERVIEW_NAME_0"));
        nameColAction.setIconPath(null);
        nameColAction.setHelpText(Messages.get().container("GUI_MODULES_LIST_ACTION_OVERVIEW_HELP_0"));
        nameColAction.setEnabled(true);
        nameColAction.setConfirmationMessage(null);
        nameCol.addDefaultAction(nameColAction);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition nicenameCol = new CmsListColumnDefinition(LIST_COLUMN_NICENAME);
        nicenameCol.setName(Messages.get().container("GUI_MODULES_LIST_COLS_NICENAME_0"));
        nicenameCol.setWidth("50%");
        nicenameCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        metadata.addColumn(nicenameCol);
        CmsListColumnDefinition groupCol = new CmsListColumnDefinition(LIST_COLUMN_GROUP);
        groupCol.setName(Messages.get().container("GUI_MODULES_LIST_COLS_GROUP_0"));
        groupCol.setWidth("10%");
        groupCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        CmsModulesListGroupFormatter groupFormatter = new CmsModulesListGroupFormatter();
        groupCol.setFormatter((I_CmsListFormatter)groupFormatter);
        metadata.addColumn(groupCol);
        CmsListColumnDefinition versionCol = new CmsListColumnDefinition(LIST_COLUMN_VERSION);
        versionCol.setName(Messages.get().container("GUI_MODULES_LIST_COLS_VERSION_0"));
        versionCol.setWidth("10%");
        versionCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        metadata.addColumn(versionCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails modulesAuthorInfoDetails = new CmsListItemDetails(LIST_DETAIL_AUTHORINFO);
        modulesAuthorInfoDetails.setAtColumn(LIST_COLUMN_NAME);
        modulesAuthorInfoDetails.setVisible(false);
        modulesAuthorInfoDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_MODULES_LABEL_AUTHOR_0")));
        modulesAuthorInfoDetails.setShowActionName(Messages.get().container("GUI_MODULES_DETAIL_SHOW_AUTHORINFO_NAME_0"));
        modulesAuthorInfoDetails.setShowActionHelpText(Messages.get().container("GUI_MODULES_DETAIL_SHOW_AUTHORINFO_HELP_0"));
        modulesAuthorInfoDetails.setHideActionName(Messages.get().container("GUI_MODULES_DETAIL_HIDE_AUTHORINFO_NAME_0"));
        modulesAuthorInfoDetails.setHideActionHelpText(Messages.get().container("GUI_MODULES_DETAIL_HIDE_AUTHORINFO_HELP_0"));
        metadata.addItemDetails(modulesAuthorInfoDetails);
        CmsListItemDetails resourcesDetails = new CmsListItemDetails(LIST_DETAIL_RESOURCES);
        resourcesDetails.setAtColumn(LIST_COLUMN_NAME);
        resourcesDetails.setVisible(false);
        resourcesDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_MODULES_LABEL_RESOURCES_0")));
        resourcesDetails.setShowActionName(Messages.get().container("GUI_MODULES_DETAIL_SHOW_RESOURCES_NAME_0"));
        resourcesDetails.setShowActionHelpText(Messages.get().container("GUI_MODULES_DETAIL_SHOW_RESOURCES_HELP_0"));
        resourcesDetails.setHideActionName(Messages.get().container("GUI_MODULES_DETAIL_HIDE_RESOURCES_NAME_0"));
        resourcesDetails.setHideActionHelpText(Messages.get().container("GUI_MODULES_DETAIL_HIDE_RESOURCES_HELP_0"));
        metadata.addItemDetails(resourcesDetails);
        CmsListItemDetails dependenciesDetails = new CmsListItemDetails(LIST_DETAIL_DEPENDENCIES);
        dependenciesDetails.setAtColumn(LIST_COLUMN_NAME);
        dependenciesDetails.setVisible(false);
        dependenciesDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_MODULES_LABEL_DEPENDENCIES_0")));
        dependenciesDetails.setShowActionName(Messages.get().container("GUI_MODULES_DETAIL_SHOW_DEPENDENCIES_NAME_0"));
        dependenciesDetails.setShowActionHelpText(Messages.get().container("GUI_MODULES_DETAIL_SHOW_DEPENDENCIES_HELP_0"));
        dependenciesDetails.setHideActionName(Messages.get().container("GUI_MODULES_DETAIL_HIDE_DEPENDENCIES_NAME_0"));
        dependenciesDetails.setHideActionHelpText(Messages.get().container("GUI_MODULES_DETAIL_HIDE_DEPENDENCIES_HELP_0"));
        metadata.addItemDetails(dependenciesDetails);
        CmsListItemDetails restypesDetails = new CmsListItemDetails(LIST_DETAIL_RESTYPES);
        restypesDetails.setAtColumn(LIST_COLUMN_NAME);
        restypesDetails.setVisible(false);
        restypesDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_MODULES_LABEL_RESTYPES_0")));
        restypesDetails.setShowActionName(Messages.get().container("GUI_MODULES_DETAIL_SHOW_RESTYPES_NAME_0"));
        restypesDetails.setShowActionHelpText(Messages.get().container("GUI_MODULES_DETAIL_SHOW_RESTYPES_HELP_0"));
        restypesDetails.setHideActionName(Messages.get().container("GUI_MODULES_DETAIL_HIDE_RESTYPES_NAME_0"));
        restypesDetails.setHideActionHelpText(Messages.get().container("GUI_MODULES_DETAIL_HIDE_RESTYPES_HELP_0"));
        metadata.addItemDetails(restypesDetails);
        CmsListSearchAction searchAction = new CmsListSearchAction(metadata.getColumnDefinition(LIST_COLUMN_NAME));
        searchAction.addColumn(metadata.getColumnDefinition(LIST_COLUMN_GROUP));
        metadata.setSearchAction(searchAction);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction deleteModules = new CmsListMultiAction(LIST_MACTION_DELETE);
        deleteModules.setName(Messages.get().container("GUI_MODULES_LIST_ACTION_MDELETE_NAME_0"));
        deleteModules.setConfirmationMessage(Messages.get().container("GUI_MODULES_LIST_ACTION_MDELETE_CONF_0"));
        deleteModules.setIconPath("list/multi_delete.png");
        deleteModules.setEnabled(true);
        deleteModules.setHelpText(Messages.get().container("GUI_MODULES_LIST_ACTION_MDELETE_HELP_0"));
        metadata.addMultiAction(deleteModules);
    }
}

