/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.modules;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.modules.CmsModulesList;
import org.opencms.workplace.tools.modules.Messages;

public class CmsModulesUploadFromServer
extends CmsWidgetDialog {
    public static final String DIALOG_TYPE = "ModulesUploadServer";
    protected static final String IMPORT_ACTION_REPORT = "/system/workplace/admin/modules/reports/import.jsp";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_MODULENAME = "modulename";
    protected static final String REPLACE_ACTION_REPORT = "/system/workplace/admin/modules/reports/replace.jsp";
    private String m_moduleupload;

    public CmsModulesUploadFromServer(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsModulesUploadFromServer(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() throws IOException, ServletException {
        ArrayList<CmsRuntimeException> errors = new ArrayList<CmsRuntimeException>();
        CmsModule module = null;
        try {
            String importpath = OpenCms.getSystemInfo().getPackagesRfsPath();
            importpath = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(importpath + "modules/" + this.m_moduleupload);
            module = CmsModuleImportExportHandler.readModuleFromImport((String)importpath);
            List dependencies = OpenCms.getModuleManager().checkDependencies(module, 1);
            if (!dependencies.isEmpty()) {
                StringBuffer dep = new StringBuffer(32);
                for (int i = 0; i < dependencies.size(); ++i) {
                    CmsModuleDependency dependency = (CmsModuleDependency)dependencies.get(i);
                    dep.append("\n - ");
                    dep.append(dependency.getName());
                    dep.append(" (Version: ");
                    dep.append(dependency.getVersion());
                    dep.append(")");
                }
                errors.add(new CmsRuntimeException(Messages.get().container("ERR_ACTION_MODULE_DEPENDENCY_2", (Object)this.m_moduleupload, (Object)new String(dep))));
            }
        }
        catch (CmsConfigurationException e) {
            errors.add(new CmsRuntimeException(Messages.get().container("ERR_ACTION_MODULE_UPLOAD_1", (Object)this.m_moduleupload), (Throwable)e));
        }
        if (module != null && errors.isEmpty()) {
            Map objects = (Map)this.getSettings().getListObject();
            if (objects != null) {
                objects.remove(CmsModulesList.class.getName());
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("module", this.m_moduleupload);
            param.put("style", "new");
            param.put("closelink", CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)"/modules"));
            if (OpenCms.getModuleManager().hasModule(module.getName())) {
                param.put(PARAM_MODULENAME, module.getName());
                this.getToolManager().jspForwardPage((CmsWorkplace)this, REPLACE_ACTION_REPORT, param);
            } else {
                this.getToolManager().jspForwardPage((CmsWorkplace)this, IMPORT_ACTION_REPORT, param);
            }
        }
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("label.uploadfromserver")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 0));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        List selectOptions = this.getModulesFromServer();
        if (selectOptions.isEmpty()) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "moduleupload", PAGES[0], (I_CmsWidget)new CmsDisplayWidget(this.key("GUI_MODULES_IMPORT_NOT_AVAILABLE_0"))));
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "moduleupload", PAGES[0], (I_CmsWidget)new CmsSelectWidget(selectOptions)));
        }
    }

    private List getModulesFromServer() {
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        String exportpath = OpenCms.getSystemInfo().getPackagesRfsPath();
        exportpath = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(exportpath + "modules");
        File folder = new File(exportpath);
        String[] list = folder.list();
        for (int i = 0; i < list.length; ++i) {
            try {
                File diskFile = new File(exportpath, list[i]);
                if (diskFile.isFile() && diskFile.getName().endsWith(".zip")) {
                    result.add(new CmsSelectWidgetOption(diskFile.getName()));
                    continue;
                }
                if (!diskFile.isDirectory() || !new File(diskFile + File.separator + "manifest.xml").exists()) continue;
                result.add(new CmsSelectWidgetOption(diskFile.getName()));
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        Collections.sort(result, new ComparatorSelectWidgetOption());
        return result;
    }

    public String getModuleupload() {
        return this.m_moduleupload;
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(DIALOG_TYPE);
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_moduleupload);
    }

    public void setModuleupload(String module) {
        this.m_moduleupload = module;
    }

    protected class ComparatorSelectWidgetOption
    implements Comparator {
        private Collator m_collator;

        protected ComparatorSelectWidgetOption() {
            this.m_collator = Collator.getInstance(CmsModulesUploadFromServer.this.getLocale());
        }

        public int compare(Object arg0, Object arg1) {
            CmsSelectWidgetOption o1 = (CmsSelectWidgetOption)arg0;
            CmsSelectWidgetOption o2 = (CmsSelectWidgetOption)arg1;
            return this.m_collator.compare(o1.getOption(), o2.getOption());
        }
    }
}

