/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.opencms.frontend.templateone.form.CmsCheckboxField;
import org.opencms.frontend.templateone.form.CmsFieldItem;
import org.opencms.frontend.templateone.form.CmsFormHandler;
import org.opencms.frontend.templateone.form.CmsRadioButtonField;
import org.opencms.frontend.templateone.form.CmsSelectionField;
import org.opencms.frontend.templateone.form.I_CmsField;
import org.opencms.frontend.templateone.form.Messages;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsField
implements I_CmsField {
    private static final Log LOG = CmsLog.getLog((Object)CmsFormHandler.class);
    private String m_errorMessage;
    private List m_items = new ArrayList();
    private String m_label;
    private boolean m_mandatory = false;
    private String m_name;
    private int m_placeholder = 0;
    private int m_position = 0;
    private String m_validationExpression = "";
    private String m_value = "";

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public List getItems() {
        return this.m_items;
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getName() {
        return this.m_name;
    }

    public int getPlaceholder() {
        return this.m_placeholder;
    }

    public int getPosition() {
        return this.m_position;
    }

    public String getValidationExpression() {
        return this.m_validationExpression;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public boolean needsItems() {
        return CmsCheckboxField.class.isAssignableFrom(this.getClass()) || CmsSelectionField.class.isAssignableFrom(this.getClass()) || CmsRadioButtonField.class.isAssignableFrom(this.getClass());
    }

    public void setPlaceholder(int placeholder) {
        this.m_placeholder = placeholder;
    }

    public void setPosition(int position) {
        this.m_position = position;
    }

    public String toString() {
        String result;
        if (this.needsItems()) {
            StringBuffer fieldValue = new StringBuffer(8);
            Iterator k = this.getItems().iterator();
            boolean isSelected = false;
            while (k.hasNext()) {
                CmsFieldItem currentItem = (CmsFieldItem)k.next();
                if (!currentItem.isSelected()) continue;
                if (isSelected) {
                    fieldValue.append(", ");
                }
                fieldValue.append(currentItem.getLabel());
                isSelected = true;
            }
            result = fieldValue.toString();
        } else {
            result = this.getValue();
        }
        return result;
    }

    public String validate(CmsFormHandler formHandler) {
        String validationError = this.validateConstraints();
        if (CmsStringUtil.isEmpty((String)validationError)) {
            validationError = this.validateValue();
        }
        return validationError;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.m_items != null) {
                this.m_items.clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    protected void incrementPlaceholder(String message) {
        int parse = 0;
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)message) && !message.startsWith("?")) {
            parse = Integer.parseInt(message.trim());
        }
        this.m_placeholder += parse;
    }

    protected void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    protected void setItems(List items) {
        this.m_items = items;
    }

    protected void setLabel(String description) {
        this.m_label = description;
    }

    protected void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    protected void setName(String name) {
        this.m_name = name;
    }

    protected void setValidationExpression(String expression) {
        this.m_validationExpression = expression;
    }

    protected void setValue(String value) {
        this.m_value = value;
    }

    protected boolean showRowEnd(String colSizeTwo) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)colSizeTwo) || !colSizeTwo.trim().equalsIgnoreCase("true")) {
            return true;
        }
        boolean result = false;
        if (this.m_position != 0) {
            result = true;
        }
        this.m_position = this.m_position == 0 ? 1 : 0;
        if (this.m_position == 1 && this.m_placeholder >= 1) {
            result = true;
            this.m_position = 0;
            --this.m_placeholder;
        }
        return result;
    }

    protected boolean showRowStart(String colSizeTwo) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)colSizeTwo) || !colSizeTwo.trim().equalsIgnoreCase("true")) {
            return true;
        }
        return this.m_position == 0;
    }

    protected String validateConstraints() {
        if (this.isMandatory()) {
            if (this.needsItems()) {
                Iterator k = this.m_items.iterator();
                boolean isSelected = false;
                while (k.hasNext()) {
                    CmsFieldItem currentItem = (CmsFieldItem)k.next();
                    if (!currentItem.isSelected()) continue;
                    isSelected = true;
                }
                if (!isSelected) {
                    return "mandatory";
                }
            } else if (CmsStringUtil.isEmpty((String)this.m_value)) {
                return "mandatory";
            }
        }
        return null;
    }

    protected String validateValue() {
        block4: {
            if (CmsStringUtil.isNotEmpty((String)this.m_value) && !"".equals(this.m_validationExpression)) {
                Pattern pattern = null;
                try {
                    pattern = Pattern.compile(this.m_validationExpression);
                    if (!pattern.matcher(this.m_value).matches()) {
                        return "validation";
                    }
                }
                catch (PatternSyntaxException e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_PATTERN_SYNTAX_0"), (Throwable)e);
                }
            }
        }
        return null;
    }
}

