/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.form;

import com.jhlabs.image.WaterFilter;
import com.octo.captcha.CaptchaFactory;
import com.octo.captcha.component.image.backgroundgenerator.BackgroundGenerator;
import com.octo.captcha.component.image.backgroundgenerator.FileReaderRandomBackgroundGenerator;
import com.octo.captcha.component.image.backgroundgenerator.UniColorBackgroundGenerator;
import com.octo.captcha.component.image.color.ColorGenerator;
import com.octo.captcha.component.image.color.SingleColorGenerator;
import com.octo.captcha.component.image.deformation.ImageDeformation;
import com.octo.captcha.component.image.deformation.ImageDeformationByFilters;
import com.octo.captcha.component.image.fontgenerator.FontGenerator;
import com.octo.captcha.component.image.fontgenerator.RandomFontGenerator;
import com.octo.captcha.component.image.textpaster.DecoratedRandomTextPaster;
import com.octo.captcha.component.image.textpaster.TextPaster;
import com.octo.captcha.component.image.textpaster.textdecorator.BaffleTextDecorator;
import com.octo.captcha.component.image.textpaster.textdecorator.TextDecorator;
import com.octo.captcha.component.image.wordtoimage.DeformedComposedWordToImage;
import com.octo.captcha.component.image.wordtoimage.WordToImage;
import com.octo.captcha.component.word.wordgenerator.RandomWordGenerator;
import com.octo.captcha.component.word.wordgenerator.WordGenerator;
import com.octo.captcha.engine.CaptchaEngineException;
import com.octo.captcha.engine.image.ImageCaptchaEngine;
import com.octo.captcha.image.ImageCaptcha;
import com.octo.captcha.image.ImageCaptchaFactory;
import com.octo.captcha.image.gimpy.GimpyFactory;
import java.awt.image.ImageFilter;
import java.util.Locale;
import org.opencms.frontend.templateone.form.CmsCaptchaSettings;
import org.opencms.main.OpenCms;

public class CmsCaptchaEngine
extends ImageCaptchaEngine {
    private ImageCaptchaFactory m_factory;
    private CmsCaptchaSettings m_settings;

    public CmsCaptchaEngine(CmsCaptchaSettings captchaSettings) {
        this.m_settings = captchaSettings;
        this.initGimpyFactory();
    }

    public ImageCaptcha getNextImageCaptcha() {
        return this.m_factory.getImageCaptcha();
    }

    public ImageCaptcha getNextImageCaptcha(Locale locale) {
        return this.m_factory.getImageCaptcha(locale);
    }

    public void setSettings(CmsCaptchaSettings settings) {
        this.m_settings = settings;
        this.initGimpyFactory();
    }

    protected void initGimpyFactory() {
        WaterFilter water = new WaterFilter();
        water.setAmplitude((double)this.m_settings.getFilterAmplitude());
        water.setAntialias(true);
        water.setPhase(0.0);
        water.setWavelength((double)this.m_settings.getFilterWaveLength());
        ImageDeformationByFilters backgroundDeformation = new ImageDeformationByFilters(new ImageFilter[0]);
        ImageDeformationByFilters textDeformation = new ImageDeformationByFilters(new ImageFilter[0]);
        ImageDeformationByFilters postDeformation = new ImageDeformationByFilters(new ImageFilter[]{water});
        RandomWordGenerator randomWords = new RandomWordGenerator(this.m_settings.getCharacterPool());
        BaffleTextDecorator textDecorator = new BaffleTextDecorator(this.m_settings.getHolesPerGlyph(), this.m_settings.getFontColor());
        SingleColorGenerator colorGenerator = new SingleColorGenerator(this.m_settings.getFontColor());
        DecoratedRandomTextPaster paster = new DecoratedRandomTextPaster(new Integer(this.m_settings.getMinPhraseLength()), new Integer(this.m_settings.getMaxPhraseLength()), (ColorGenerator)colorGenerator, new TextDecorator[]{textDecorator});
        Object background = this.m_settings.isUseBackgroundImage() ? new FileReaderRandomBackgroundGenerator(new Integer(this.m_settings.getImageWidth()), new Integer(this.m_settings.getImageHeight()), OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebApplication("resources/captchabackgrounds/")) : new UniColorBackgroundGenerator(new Integer(this.m_settings.getImageWidth()), new Integer(this.m_settings.getImageHeight()), this.m_settings.getBackgroundColor());
        RandomFontGenerator font = new RandomFontGenerator(new Integer(this.m_settings.getMinFontSize()), new Integer(this.m_settings.getMaxFontSize()));
        DeformedComposedWordToImage wordToImage = new DeformedComposedWordToImage((FontGenerator)font, (BackgroundGenerator)background, (TextPaster)paster, (ImageDeformation)backgroundDeformation, (ImageDeformation)textDeformation, (ImageDeformation)postDeformation);
        this.m_factory = new GimpyFactory((WordGenerator)randomWords, (WordToImage)wordToImage);
    }

    public CaptchaFactory[] getFactories() {
        return new CaptchaFactory[]{this.m_factory};
    }

    public void setFactories(CaptchaFactory[] arg0) throws CaptchaEngineException {
    }
}

