/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.form;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.service.image.ImageCaptchaService;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.flex.CmsFlexController;
import org.opencms.frontend.templateone.form.A_CmsField;
import org.opencms.frontend.templateone.form.CmsCaptchaServiceCache;
import org.opencms.frontend.templateone.form.CmsCaptchaSettings;
import org.opencms.frontend.templateone.form.CmsFormHandler;
import org.opencms.frontend.templateone.form.Messages;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsCaptchaField
extends A_CmsField {
    public static final String C_PARAM_CAPTCHA_PHRASE = "captchaphrase";
    private static final Log LOG = CmsLog.getLog((Object)CmsCaptchaField.class);
    private static final String TYPE = "captcha";
    private CmsCaptchaSettings m_captchaSettings;

    public CmsCaptchaField(CmsCaptchaSettings captchaSettings, String fieldLabel, String fieldValue) {
        this.m_captchaSettings = captchaSettings;
        this.setName(C_PARAM_CAPTCHA_PHRASE);
        this.setValue(fieldValue);
        this.setLabel(fieldLabel);
        this.setMandatory(true);
    }

    public static String getStaticType() {
        return TYPE;
    }

    public String buildHtml(CmsFormHandler formHandler, CmsMessages messages, String errorKey) {
        StringBuffer buf = new StringBuffer();
        String fieldLabel = this.getLabel();
        String errorMessage = "";
        String mandatory = "";
        CmsCaptchaSettings captchaSettings = this.getCaptchaSettings();
        if (CmsStringUtil.isNotEmpty((String)errorKey)) {
            errorMessage = "mandatory".equals(errorKey) ? messages.key("form.error.mandatory") : (CmsStringUtil.isNotEmpty((String)this.getErrorMessage()) ? this.getErrorMessage() : messages.key("form.error.validation"));
            errorMessage = messages.key("form.html.error.start") + errorMessage + messages.key("form.html.error.end");
            fieldLabel = messages.key("form.html.label.error.start") + fieldLabel + messages.key("form.html.label.error.end");
        }
        if (this.isMandatory()) {
            mandatory = messages.key("form.html.mandatory");
        }
        if (this.showRowStart(messages.key("form.html.col.two"))) {
            buf.append(messages.key("form.html.row.start")).append("\n");
        }
        buf.append(messages.key("form.html.label.start")).append(fieldLabel).append(mandatory).append(messages.key("form.html.label.end")).append("\n");
        buf.append(messages.key("form.html.field.start")).append("\n");
        buf.append("<img src=\"").append(formHandler.link("/system/modules/org.opencms.frontend.templateone.form/pages/captcha?" + captchaSettings.toRequestParams(formHandler.getCmsObject()))).append("\" width=\"").append(captchaSettings.getImageWidth()).append("\" height=\"").append(captchaSettings.getImageHeight()).append("\" alt=\"\"/>").append("\n");
        buf.append("<br/>\n");
        buf.append("<input type=\"text\" name=\"").append(this.getName()).append("\" value=\"").append(this.getValue()).append("\"").append(formHandler.getFormConfiguration().getFormFieldAttributes()).append("/>").append(errorMessage).append(messages.key("form.html.field.end")).append("\n");
        if (this.showRowEnd(messages.key("form.html.col.two"))) {
            buf.append(messages.key("form.html.row.end")).append("\n");
        }
        return buf.toString();
    }

    public CmsCaptchaSettings getCaptchaSettings() {
        return this.m_captchaSettings;
    }

    public String getType() {
        return TYPE;
    }

    public boolean validateCaptchaPhrase(CmsJspActionElement jsp, String captchaPhrase) {
        ImageCaptchaService captchaService;
        boolean result = false;
        String sessionId = jsp.getRequest().getSession().getId();
        if (CmsStringUtil.isNotEmpty((String)captchaPhrase) && (captchaService = CmsCaptchaServiceCache.getSharedInstance().getCaptchaService(this.m_captchaSettings, jsp.getCmsObject())) != null) {
            result = captchaService.validateResponseForID(sessionId, (Object)captchaPhrase);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeCaptchaImage(CmsJspActionElement cms) throws IOException {
        block16: {
            ByteArrayOutputStream captchaImageOutput = new ByteArrayOutputStream();
            ServletOutputStream out = null;
            BufferedImage captchaImage = null;
            int maxTries = 10;
            do {
                try {
                    --maxTries;
                    String sessionId = cms.getRequest().getSession().getId();
                    Locale locale = cms.getRequestContext().getLocale();
                    captchaImage = CmsCaptchaServiceCache.getSharedInstance().getCaptchaService(this.m_captchaSettings, cms.getCmsObject()).getImageChallengeForID(sessionId, locale);
                }
                catch (CaptchaException cex) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)cex);
                        LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_CAPTCHA_CONFIG_IMAGE_SIZE_2", new Object[]{this.m_captchaSettings.getPresetPath(), new Integer(maxTries)}));
                    }
                    this.m_captchaSettings.setImageHeight(this.m_captchaSettings.getImageHeight() + 40);
                    this.m_captchaSettings.setImageWidth(this.m_captchaSettings.getImageWidth() + 80);
                }
            } while (captchaImage == null && maxTries > 0);
            JPEGImageEncoder jpegEncoder = JPEGCodec.createJPEGEncoder((OutputStream)captchaImageOutput);
            jpegEncoder.encode(captchaImage);
            CmsFlexController controller = CmsFlexController.getController((ServletRequest)cms.getRequest());
            HttpServletResponse response = controller.getTopResponse();
            response.setHeader("Cache-Control", "no-store");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setContentType("image/jpeg");
            out = cms.getResponse().getOutputStream();
            out.write(captchaImageOutput.toByteArray());
            out.flush();
            Object var10_11 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block16;
            }
            catch (Throwable t) {}
            break block16;
            {
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    cms.getResponse().sendError(500);
                    Object var10_12 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block16;
                    }
                    catch (Throwable t) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

