/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.form;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public final class CmsCaptchaSettings
implements Cloneable {
    public static final String C_PARAM_BACKGROUND_COLOR = "bgcol";
    public static final String C_PARAM_CHARACTERS = "crs";
    public static final String C_PARAM_FILTER_AMPLITUDE = "famplit";
    public static final String C_PARAM_FILTER_WAVE_LENGTH = "fwavlen";
    public static final String C_PARAM_FONT_COLOR = "fcol";
    public static final String C_PARAM_HOLES_PER_GLYPH = "holes";
    public static final String C_PARAM_IMAGE_HEIGHT = "h";
    public static final String C_PARAM_IMAGE_WIDTH = "w";
    public static final String C_PARAM_MAX_FONT_SIZE = "maxfs";
    public static final String C_PARAM_MAX_PHRASE_LENGTH = "maxpl";
    public static final String C_PARAM_MIN_FONT_SIZE = "minfs";
    public static final String C_PARAM_MIN_PHRASE_LENGTH = "minpl";
    public static final String C_PARAM_PRESET = "prst";
    public static final String C_PARAM_USE_BACKGROUND_IMAGE = "bgimg";
    public static final String NODE_CAPTCHAPRESET_BACKGROUNDCOLOR = "BackgroundColor";
    public static final String NODE_CAPTCHAPRESET_FILTER_AMPLITUDE = "FilterAmplitude";
    public static final String NODE_CAPTCHAPRESET_FILTER_WAVELENGTH = "FilterWaveLength";
    public static final String NODE_CAPTCHAPRESET_FONTCOLOR = "FontColor";
    public static final String NODE_CAPTCHAPRESET_HOLESPERGLYPH = "HolesPerGlyph";
    public static final String NODE_CAPTCHAPRESET_IMAGEHEIGHT = "ImageHeight";
    public static final String NODE_CAPTCHAPRESET_IMAGEWIDTH = "ImageWidth";
    public static final String NODE_CAPTCHAPRESET_MAX_FONT_SIZE = "MaxFontSize";
    public static final String NODE_CAPTCHAPRESET_MAX_PHRASE_LENGTH = "MaxPhraseLength";
    public static final String NODE_CAPTCHAPRESET_MIN_FONT_SIZE = "MinFontSize";
    public static final String NODE_CAPTCHAPRESET_MIN_PHRASE_LENGTH = "MinPhraseLength";
    private static final Log LOG = CmsLog.getLog((Object)CmsCaptchaSettings.class);
    private Color m_backgroundColor = Color.WHITE;
    private String m_characterPool = "abcdefghiklmnoprstuvwxyz";
    private int m_filterAmplitude = 2;
    private int m_filterWaveLength = 100;
    private Color m_fontColor = Color.BLACK;
    private Integer m_holesPerGlyp = new Integer(0);
    private int m_imageHeight = 50;
    private int m_imageWidth = 150;
    private int m_maxFontSize = 40;
    private int m_maxPhraseLength = 5;
    private int m_minFontSize = 30;
    private int m_minPhraseLength = 5;
    private Map m_parameterMap;
    private String m_presetPath = "factory defaults (classfile)";
    private boolean m_useBackgroundImage = true;

    private CmsCaptchaSettings() {
    }

    private CmsCaptchaSettings(CmsJspActionElement jsp) {
        this.init(jsp);
    }

    public static CmsCaptchaSettings getInstance(CmsJspActionElement jsp) {
        CmsCaptchaSettings result = new CmsCaptchaSettings(jsp);
        return (CmsCaptchaSettings)result.clone();
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public String getBackgroundColorString() {
        StringBuffer buf = new StringBuffer();
        buf.append("#");
        buf.append(this.toHexString(this.m_backgroundColor.getRed()));
        buf.append(this.toHexString(this.m_backgroundColor.getGreen()));
        buf.append(this.toHexString(this.m_backgroundColor.getBlue()));
        return buf.toString();
    }

    public int getFilterAmplitude() {
        return this.m_filterAmplitude;
    }

    public int getFilterWaveLength() {
        return this.m_filterWaveLength;
    }

    public Color getFontColor() {
        return this.m_fontColor;
    }

    public String getFontColorString() {
        StringBuffer buf = new StringBuffer();
        buf.append("#");
        buf.append(this.toHexString(this.m_fontColor.getRed()));
        buf.append(this.toHexString(this.m_fontColor.getGreen()));
        buf.append(this.toHexString(this.m_fontColor.getBlue()));
        return buf.toString();
    }

    public Integer getHolesPerGlyph() {
        return this.m_holesPerGlyp;
    }

    public int getImageHeight() {
        return this.m_imageHeight;
    }

    public int getImageWidth() {
        return this.m_imageWidth;
    }

    public int getMaxFontSize() {
        return this.m_maxFontSize;
    }

    public int getMaxPhraseLength() {
        return this.m_maxPhraseLength;
    }

    public int getMinFontSize() {
        return this.m_minFontSize;
    }

    public int getMinPhraseLength() {
        return this.m_minPhraseLength;
    }

    public void init(CmsJspActionElement jsp) {
        List mulipartFileItems = CmsRequestUtil.readMultipartFileItems((HttpServletRequest)jsp.getRequest());
        this.m_parameterMap = new HashMap();
        this.m_parameterMap = mulipartFileItems != null ? CmsRequestUtil.readParameterMapFromMultiPart((String)jsp.getRequestContext().getEncoding(), (List)mulipartFileItems) : jsp.getRequest().getParameterMap();
        String stringValue = this.getParameter(C_PARAM_IMAGE_WIDTH);
        if (CmsStringUtil.isNotEmpty((String)stringValue)) {
            this.m_imageWidth = Integer.parseInt(stringValue);
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_IMAGE_HEIGHT)))) {
            this.m_imageHeight = Integer.parseInt(stringValue);
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_MIN_PHRASE_LENGTH)))) {
            this.m_minPhraseLength = Integer.parseInt(stringValue);
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_MAX_PHRASE_LENGTH)))) {
            this.m_maxPhraseLength = Integer.parseInt(stringValue);
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_MIN_FONT_SIZE)))) {
            this.m_minFontSize = Integer.parseInt(stringValue);
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_MAX_FONT_SIZE)))) {
            this.m_maxFontSize = Integer.parseInt(stringValue);
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_FONT_COLOR)))) {
            stringValue = CmsEncoder.unescape((String)stringValue, (String)jsp.getRequestContext().getEncoding());
            this.setFontColor(stringValue);
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_BACKGROUND_COLOR)))) {
            stringValue = CmsEncoder.unescape((String)stringValue, (String)jsp.getRequestContext().getEncoding());
        }
        this.setBackgroundColor(stringValue);
        stringValue = this.getParameter(C_PARAM_HOLES_PER_GLYPH);
        if (CmsStringUtil.isNotEmpty((String)stringValue)) {
            this.setHolesPerGlyph(Integer.parseInt(stringValue));
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_FILTER_AMPLITUDE)))) {
            this.setFilterAmplitude(Integer.parseInt(stringValue));
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_FILTER_WAVE_LENGTH)))) {
            this.setFilterWaveLength(Integer.parseInt(stringValue));
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_USE_BACKGROUND_IMAGE)))) {
            this.setUseBackgroundImage(Boolean.valueOf(stringValue));
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_CHARACTERS)))) {
            this.setCharacterPool(stringValue);
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_CHARACTERS)))) {
            this.setCharacterPool(stringValue);
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = this.getParameter(C_PARAM_PRESET)))) {
            this.m_presetPath = stringValue;
        }
    }

    public void init(CmsObject cms, CmsXmlContent content, Locale locale) {
        block15: {
            try {
                String captchaSettingsPath = content.getStringValue(cms, "FormCaptcha" + "/" + "Preset", locale);
                if (CmsStringUtil.isNotEmpty((String)captchaSettingsPath)) {
                    Locale captchaSettingsLocale;
                    this.m_presetPath = captchaSettingsPath;
                    CmsFile captchaSettingsFile = cms.readFile(captchaSettingsPath);
                    CmsXmlContent preset = CmsXmlContentFactory.unmarshal((CmsObject)cms, (CmsFile)captchaSettingsFile);
                    String stringValue = preset.getStringValue(cms, NODE_CAPTCHAPRESET_IMAGEWIDTH, captchaSettingsLocale = Locale.ENGLISH);
                    if (CmsStringUtil.isNotEmpty((String)stringValue)) {
                        this.m_imageWidth = Integer.parseInt(stringValue);
                    }
                    if (CmsStringUtil.isNotEmpty((String)(stringValue = preset.getStringValue(cms, NODE_CAPTCHAPRESET_IMAGEHEIGHT, captchaSettingsLocale)))) {
                        this.m_imageHeight = Integer.parseInt(stringValue);
                    }
                    if (CmsStringUtil.isNotEmpty((String)(stringValue = preset.getStringValue(cms, NODE_CAPTCHAPRESET_MIN_PHRASE_LENGTH, captchaSettingsLocale)))) {
                        this.m_minPhraseLength = Integer.parseInt(stringValue);
                    }
                    if (CmsStringUtil.isNotEmpty((String)(stringValue = preset.getStringValue(cms, NODE_CAPTCHAPRESET_MAX_PHRASE_LENGTH, captchaSettingsLocale)))) {
                        this.m_maxPhraseLength = Integer.parseInt(stringValue);
                    }
                    if (CmsStringUtil.isNotEmpty((String)(stringValue = preset.getStringValue(cms, NODE_CAPTCHAPRESET_MIN_FONT_SIZE, captchaSettingsLocale)))) {
                        this.m_minFontSize = Integer.parseInt(stringValue);
                    }
                    if (CmsStringUtil.isNotEmpty((String)(stringValue = preset.getStringValue(cms, NODE_CAPTCHAPRESET_MAX_FONT_SIZE, captchaSettingsLocale)))) {
                        this.m_maxFontSize = Integer.parseInt(stringValue);
                    }
                    if (CmsStringUtil.isNotEmpty((String)(stringValue = preset.getStringValue(cms, NODE_CAPTCHAPRESET_FONTCOLOR, captchaSettingsLocale)))) {
                        this.setFontColor(stringValue);
                    }
                    stringValue = preset.getStringValue(cms, NODE_CAPTCHAPRESET_BACKGROUNDCOLOR, captchaSettingsLocale);
                    this.setBackgroundColor(stringValue);
                    stringValue = preset.getStringValue(cms, NODE_CAPTCHAPRESET_HOLESPERGLYPH, captchaSettingsLocale);
                    if (CmsStringUtil.isNotEmpty((String)stringValue)) {
                        this.setHolesPerGlyph(Integer.parseInt(stringValue));
                    }
                    if (CmsStringUtil.isNotEmpty((String)(stringValue = preset.getStringValue(cms, NODE_CAPTCHAPRESET_FILTER_AMPLITUDE, captchaSettingsLocale)))) {
                        this.setFilterAmplitude(Integer.parseInt(stringValue));
                    }
                    if (CmsStringUtil.isNotEmpty((String)(stringValue = preset.getStringValue(cms, NODE_CAPTCHAPRESET_FILTER_WAVELENGTH, captchaSettingsLocale)))) {
                        this.setFilterWaveLength(Integer.parseInt(stringValue));
                    }
                    if (CmsStringUtil.isNotEmpty((String)(stringValue = preset.getStringValue(cms, "Characters", captchaSettingsLocale)))) {
                        this.setCharacterPool(stringValue);
                    }
                    if (CmsStringUtil.isNotEmpty((String)stringValue)) {
                        this.setCharacterPool(stringValue);
                    }
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block15;
                LOG.error((Object)ex.getLocalizedMessage());
            }
        }
    }

    public boolean isUseBackgroundImage() {
        return this.m_useBackgroundImage;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.m_backgroundColor = backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        if (CmsStringUtil.isNotEmpty((String)backgroundColor)) {
            if (backgroundColor.startsWith("#")) {
                backgroundColor = backgroundColor.substring(1);
            }
            this.m_backgroundColor = new Color(Integer.valueOf(backgroundColor, 16));
            this.m_useBackgroundImage = false;
        } else if (backgroundColor != null) {
            this.m_useBackgroundImage = false;
            this.m_backgroundColor = Color.WHITE;
        } else {
            this.m_useBackgroundImage = true;
            this.m_backgroundColor = Color.WHITE;
        }
    }

    public void setFilterAmplitude(int i) {
        this.m_filterAmplitude = i;
    }

    public void setFilterWaveLength(int filterWaveLength) {
        this.m_filterWaveLength = filterWaveLength;
    }

    public void setFontColor(Color fontColor) {
        this.m_fontColor = fontColor;
    }

    public void setFontColor(String fontColor) {
        if (CmsStringUtil.isNotEmpty((String)fontColor)) {
            if (fontColor.startsWith("#")) {
                fontColor = fontColor.substring(1);
            }
            this.m_fontColor = new Color(Integer.valueOf(fontColor, 16));
        } else {
            this.m_fontColor = Color.BLACK;
        }
    }

    public void setHolesPerGlyph(int holes) {
        this.m_holesPerGlyp = new Integer(holes);
    }

    public void setImageHeight(int imageHeight) {
        this.m_imageHeight = imageHeight;
    }

    public void setImageWidth(int imageWidth) {
        this.m_imageWidth = imageWidth;
    }

    public void setMaxFontSize(int maxFontSize) {
        this.m_maxFontSize = maxFontSize;
    }

    public void setMaxPhraseLength(int maxPhraseLength) {
        this.m_maxPhraseLength = maxPhraseLength;
    }

    public void setMinFontSize(int minFontSize) {
        this.m_minFontSize = minFontSize;
    }

    public void setMinPhraseLength(int minPhraseLength) {
        this.m_minPhraseLength = minPhraseLength;
    }

    public void setUseBackgroundImage(boolean useBackgroundImage) {
        this.m_useBackgroundImage = useBackgroundImage;
    }

    public String toRequestParams(CmsObject cms) {
        StringBuffer buf = new StringBuffer();
        buf.append(C_PARAM_IMAGE_WIDTH).append("=").append(this.m_imageWidth);
        buf.append("&").append(C_PARAM_IMAGE_HEIGHT).append("=").append(this.m_imageHeight);
        buf.append("&").append(C_PARAM_MIN_FONT_SIZE).append("=").append(this.m_minFontSize);
        buf.append("&").append(C_PARAM_MAX_FONT_SIZE).append("=").append(this.m_maxFontSize);
        buf.append("&").append(C_PARAM_MIN_PHRASE_LENGTH).append("=").append(this.m_minPhraseLength);
        buf.append("&").append(C_PARAM_MAX_PHRASE_LENGTH).append("=").append(this.m_maxPhraseLength);
        buf.append("&").append(C_PARAM_FONT_COLOR).append("=").append(CmsEncoder.escape((String)this.getFontColorString(), (String)cms.getRequestContext().getEncoding()));
        buf.append("&").append(C_PARAM_BACKGROUND_COLOR).append("=").append(CmsEncoder.escape((String)this.getBackgroundColorString(), (String)cms.getRequestContext().getEncoding()));
        buf.append("&").append(C_PARAM_HOLES_PER_GLYPH).append("=").append(this.m_holesPerGlyp);
        buf.append("&").append(C_PARAM_FILTER_AMPLITUDE).append("=").append(this.m_filterAmplitude);
        buf.append("&").append(C_PARAM_FILTER_WAVE_LENGTH).append("=").append(this.m_filterWaveLength);
        buf.append("&").append(C_PARAM_CHARACTERS).append("=").append(this.m_characterPool);
        buf.append("&").append(C_PARAM_PRESET).append("=").append(this.m_presetPath);
        buf.append("&").append(C_PARAM_USE_BACKGROUND_IMAGE).append("=").append(Boolean.toString(this.m_useBackgroundImage));
        return buf.toString();
    }

    protected Object clone() {
        CmsCaptchaSettings result = new CmsCaptchaSettings();
        result.m_backgroundColor = this.m_backgroundColor;
        result.m_filterAmplitude = this.m_filterAmplitude;
        result.m_filterWaveLength = this.m_filterWaveLength;
        result.m_fontColor = this.m_fontColor;
        result.m_holesPerGlyp = this.m_holesPerGlyp;
        result.m_imageHeight = this.m_imageHeight;
        result.m_imageWidth = this.m_imageWidth;
        result.m_maxFontSize = this.m_maxFontSize;
        result.m_maxPhraseLength = this.m_maxPhraseLength;
        result.m_minFontSize = this.m_minFontSize;
        result.m_useBackgroundImage = this.m_useBackgroundImage;
        result.m_minPhraseLength = this.m_minPhraseLength;
        result.m_characterPool = this.m_characterPool;
        result.m_presetPath = this.m_presetPath;
        return result;
    }

    String getCharacterPool() {
        return this.m_characterPool;
    }

    String getPresetPath() {
        return this.m_presetPath;
    }

    void setCharacterPool(String characterPool) {
        this.m_characterPool = characterPool;
    }

    private String getParameter(String parameter) {
        try {
            return ((String[])this.m_parameterMap.get(parameter))[0];
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private String toHexString(int colorRange) {
        if (colorRange < 10) {
            return "0" + Integer.toHexString(colorRange);
        }
        return Integer.toHexString(colorRange);
    }
}

