/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.form;

import java.util.Iterator;
import org.opencms.frontend.templateone.form.A_CmsField;
import org.opencms.frontend.templateone.form.CmsFieldItem;
import org.opencms.frontend.templateone.form.CmsFormHandler;
import org.opencms.i18n.CmsMessages;
import org.opencms.util.CmsStringUtil;

public class CmsCheckboxField
extends A_CmsField {
    private static final String TYPE = "checkbox";

    public String getType() {
        return TYPE;
    }

    public static String getStaticType() {
        return TYPE;
    }

    public String buildHtml(CmsFormHandler formHandler, CmsMessages messages, String errorKey) {
        StringBuffer buf = new StringBuffer();
        String fieldLabel = this.getLabel();
        String errorMessage = "";
        String mandatory = "";
        if (CmsStringUtil.isNotEmpty((String)errorKey)) {
            errorMessage = "mandatory".equals(errorKey) ? messages.key("form.error.mandatory") : (CmsStringUtil.isNotEmpty((String)this.getErrorMessage()) ? this.getErrorMessage() : messages.key("form.error.validation"));
            errorMessage = messages.key("form.html.error.start") + errorMessage + messages.key("form.html.error.end");
            fieldLabel = messages.key("form.html.label.error.start") + fieldLabel + messages.key("form.html.label.error.end");
        }
        if (this.isMandatory()) {
            mandatory = messages.key("form.html.mandatory");
        }
        if (this.showRowStart(messages.key("form.html.col.two"))) {
            buf.append(messages.key("form.html.row.start")).append("\n");
        }
        buf.append(messages.key("form.html.label.start")).append(fieldLabel).append(mandatory).append(messages.key("form.html.label.end")).append("\n");
        buf.append(messages.key("form.html.field.start")).append("\n");
        Iterator i = this.getItems().iterator();
        while (i.hasNext()) {
            CmsFieldItem curOption = (CmsFieldItem)i.next();
            String checked = "";
            if (curOption.isSelected()) {
                checked = " checked=\"checked\"";
            }
            buf.append("<input type=\"checkbox\" name=\"").append(this.getName()).append("\" value=\"").append(curOption.getValue()).append("\"").append(checked).append("/>").append(curOption.getLabel());
            if (i.hasNext()) {
                buf.append(messages.key("form.html.checkbox.seperator"));
            }
            buf.append("\n");
        }
        buf.append(errorMessage).append("\n");
        buf.append(messages.key("form.html.field.end")).append("\n");
        if (this.showRowEnd(messages.key("form.html.col.two"))) {
            buf.append(messages.key("form.html.row.end")).append("\n");
        }
        return buf.toString();
    }
}

