/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.form;

import java.util.HashMap;
import org.opencms.frontend.templateone.form.A_CmsField;
import org.opencms.frontend.templateone.form.CmsFormHandler;
import org.opencms.frontend.templateone.form.Messages;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsFileUploadField
extends A_CmsField {
    private static final String TYPE = "file";
    private int m_fileSize;

    public String getType() {
        return TYPE;
    }

    public static String getStaticType() {
        return TYPE;
    }

    public String buildHtml(CmsFormHandler formHandler, CmsMessages messages, String errorKey) {
        StringBuffer buf = new StringBuffer();
        String fieldLabel = this.getLabel();
        String errorMessage = "";
        String mandatory = "";
        if (CmsStringUtil.isNotEmpty((String)errorKey)) {
            errorMessage = "mandatory".equals(errorKey) ? messages.key("form.error.mandatory") : (CmsStringUtil.isNotEmpty((String)this.getErrorMessage()) ? this.getErrorMessage() : messages.key("form.error.validation"));
            errorMessage = messages.key("form.html.error.start") + errorMessage + messages.key("form.html.error.end");
            fieldLabel = messages.key("form.html.label.error.start") + fieldLabel + messages.key("form.html.label.error.end");
        }
        if (this.isMandatory()) {
            mandatory = messages.key("form.html.mandatory");
        }
        if (this.showRowStart(messages.key("form.html.col.two"))) {
            buf.append(messages.key("form.html.row.start")).append("\n");
        }
        buf.append(messages.key("form.html.label.start")).append(fieldLabel).append(mandatory).append(messages.key("form.html.label.end")).append("\n");
        buf.append(messages.key("form.html.field.start")).append("<input type=\"file\" name=\"").append(this.getName()).append("\" value=\"").append(CmsStringUtil.escapeHtml((String)this.getValue())).append("\"").append(formHandler.getFormConfiguration().getFormFieldAttributes()).append("/>").append(errorMessage).append(messages.key("form.html.field.end")).append("\n");
        if (this.showRowEnd(messages.key("form.html.col.two"))) {
            buf.append(messages.key("form.html.row.end")).append("\n");
        }
        return buf.toString();
    }

    protected String validateValue() {
        if (CmsStringUtil.isNotEmpty((String)this.getValue()) && CmsStringUtil.isNotEmpty((String)this.getValidationExpression())) {
            HashMap<String, String> substitutions = new HashMap<String, String>();
            substitutions.put("<", "");
            substitutions.put("kb", "");
            int maxSize = Integer.parseInt(CmsStringUtil.substitute((String)this.getValidationExpression(), substitutions)) * 1024;
            try {
                if (this.m_fileSize > maxSize) {
                    return "validation";
                }
            }
            catch (Exception e) {
                CmsLog.getLog((Object)CmsFileUploadField.class).error((Object)Messages.get().getBundle().key("LOG_ERR_PATTERN_SYNTAX_0"), (Throwable)e);
            }
        }
        return "";
    }

    protected void setFileSize(int fileSize) {
        this.m_fileSize = fileSize;
    }
}

