/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.fileupload.FileItem;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.frontend.templateone.form.A_CmsField;
import org.opencms.frontend.templateone.form.CmsCaptchaField;
import org.opencms.frontend.templateone.form.CmsCaptchaSettings;
import org.opencms.frontend.templateone.form.CmsCheckboxField;
import org.opencms.frontend.templateone.form.CmsEmailField;
import org.opencms.frontend.templateone.form.CmsFieldFactory;
import org.opencms.frontend.templateone.form.CmsFieldItem;
import org.opencms.frontend.templateone.form.CmsFileUploadField;
import org.opencms.frontend.templateone.form.CmsFormHandler;
import org.opencms.frontend.templateone.form.I_CmsField;
import org.opencms.frontend.templateone.form.Messages;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.CmsXmlHtmlValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsForm {
    public static final String MAILTYPE_HTML = "html";
    public static final String MAILTYPE_TEXT = "text";
    public static final String NODE_CAPTCHA = "FormCaptcha";
    public static final String NODE_CONFIRMATIONMAILCHECKBOXLABEL = "ConfirmationCheckboxLabel";
    public static final String NODE_CONFIRMATIONMAILENABLED = "ConfirmationMailEnabled";
    public static final String NODE_CONFIRMATIONMAILFIELD = "ConfirmationField";
    public static final String NODE_CONFIRMATIONMAILOPTIONAL = "ConfirmationMailOptional";
    public static final String NODE_CONFIRMATIONMAILSUBJECT = "ConfirmationMailSubject";
    public static final String NODE_CONFIRMATIONMAILTEXT = "ConfirmationMailText";
    public static final String NODE_EMAIL = "Email";
    public static final String NODE_FIELDDEFAULTVALUE = "FieldDefault";
    public static final String NODE_FIELDERRORMESSAGE = "FieldErrorMessage";
    public static final String NODE_FIELDITEM = "FieldItem";
    public static final String NODE_FIELDLABEL = "FieldLabel";
    public static final String NODE_FIELDMANDATORY = "FieldMandatory";
    public static final String NODE_FIELDTYPE = "FieldType";
    public static final String NODE_FIELDVALIDATION = "FieldValidation";
    public static final String NODE_FORMATTRIBUTES = "FormAttributes";
    public static final String NODE_FORMCHECKTEXT = "CheckText";
    public static final String NODE_FORMCONFIRMATION = "FormConfirmation";
    public static final String NODE_FORMFIELDATTRIBUTES = "FormFieldAttributes";
    public static final String NODE_FORMTEXT = "FormText";
    public static final String NODE_INPUTFIELD = "InputField";
    public static final String NODE_ITEMDESCRIPTION = "ItemDescription";
    public static final String NODE_ITEMSELECTED = "ItemSelected";
    public static final String NODE_ITEMVALUE = "ItemValue";
    public static final String NODE_MAILBCC = "MailBCC";
    public static final String NODE_MAILCC = "MailCC";
    public static final String NODE_MAILFROM = "MailFrom";
    public static final String NODE_MAILSUBJECT = "MailSubject";
    public static final String NODE_MAILTEXT = "MailText";
    public static final String NODE_MAILTO = "MailTo";
    public static final String NODE_MAILTYPE = "MailType";
    public static final String NODE_OPTIONALCONFIGURATION = "OptionalFormConfiguration";
    public static final String NODE_OPTIONALCONFIRMATION = "OptionalConfirmationMail";
    public static final String NODE_SHOWCHECK = "ShowCheck";
    public static final String NODE_TARGET_URI = "TargetUri";
    public static final String PARAM_SENDCONFIRMATION = "sendconfirmation";
    private static final String TYPE_NAME = "emailform";
    private CmsCaptchaField m_captchaField;
    private List m_configurationErrors;
    private String m_confirmationMailCheckboxLabel;
    private boolean m_confirmationMailEnabled;
    private int m_confirmationMailField;
    private boolean m_confirmationMailOptional;
    private String m_confirmationMailSubject;
    private String m_confirmationMailText;
    private String m_confirmationMailTextPlain;
    private List m_fields;
    private Map m_fieldsByName;
    private String m_formAction;
    private String m_formAttributes;
    private String m_formCheckText;
    private String m_formConfirmationText;
    private String m_formFieldAttributes;
    private String m_formText;
    private boolean m_hasMandatoryFields;
    private String m_mailBCC;
    private String m_mailCC;
    private String m_mailFrom;
    private String m_mailSubject;
    private String m_mailSubjectPrefix;
    private String m_mailText;
    private String m_mailTextPlain;
    private String m_mailTo;
    private String m_mailType;
    private boolean m_showCheck;
    private String m_targetUri;
    public static final String NODE_CAPTCHA_PRESET = "Preset";
    public static final String NODE_CAPTCHA_CHARACTERS = "Characters";
    private Map m_parameterMap;
    static /* synthetic */ Class class$org$opencms$frontend$templateone$form$CmsCaptchaField;
    static /* synthetic */ Class class$org$opencms$frontend$templateone$form$CmsHiddenField;
    static /* synthetic */ Class class$org$opencms$frontend$templateone$form$CmsFileUploadField;

    public CmsForm(CmsFormHandler jsp, CmsMessages messages, boolean initial) throws Exception {
        this.init(jsp, messages, initial, null, null);
    }

    public CmsForm(CmsFormHandler jsp, CmsMessages messages, boolean initial, String formConfigUri, String formAction) throws Exception {
        this.init(jsp, messages, initial, formConfigUri, formAction);
    }

    public static String getStaticType() {
        return TYPE_NAME;
    }

    public boolean captchaFieldIsOnCheckPage() {
        return this.getShowCheck();
    }

    public boolean captchaFieldIsOnInputPage() {
        return !this.getShowCheck();
    }

    public CmsCaptchaField getCaptchaField() {
        return this.m_captchaField;
    }

    public List getConfigurationErrors() {
        return this.m_configurationErrors;
    }

    public String getConfirmationMailCheckboxLabel() {
        return this.m_confirmationMailCheckboxLabel;
    }

    public int getConfirmationMailField() {
        return this.m_confirmationMailField;
    }

    public String getConfirmationMailSubject() {
        return this.m_confirmationMailSubject;
    }

    public String getConfirmationMailText() {
        return this.m_confirmationMailText;
    }

    public String getConfirmationMailTextPlain() {
        return this.m_confirmationMailTextPlain;
    }

    public List getFields() {
        return this.m_fields;
    }

    public String getFieldStringValueByName(String fieldName) {
        I_CmsField field = (I_CmsField)this.m_fieldsByName.get(fieldName);
        if (field != null) {
            String fieldValue = field.getValue();
            return fieldValue != null ? fieldValue.trim() : "";
        }
        return "";
    }

    public String getFormAttributes() {
        return this.m_formAttributes;
    }

    public String getFormCheckText() {
        return this.m_formCheckText;
    }

    public String getFormConfirmationText() {
        return this.m_formConfirmationText;
    }

    public String getFormFieldAttributes() {
        return this.m_formFieldAttributes;
    }

    public String getFormText() {
        return this.m_formText;
    }

    public String getMailBCC() {
        return this.m_mailBCC;
    }

    public String getMailCC() {
        return this.m_mailCC;
    }

    public String getMailFrom() {
        return this.m_mailFrom;
    }

    public String getMailSubject() {
        return this.m_mailSubject;
    }

    public String getMailSubjectPrefix() {
        return this.m_mailSubjectPrefix;
    }

    public String getMailText() {
        return this.m_mailText;
    }

    public String getMailTextPlain() {
        return this.m_mailTextPlain;
    }

    public String getMailTo() {
        return this.m_mailTo;
    }

    public String getMailType() {
        return this.m_mailType;
    }

    public boolean getShowCheck() {
        return this.m_showCheck;
    }

    public String getTargetUri() {
        return this.m_targetUri;
    }

    public boolean hasCaptchaField() {
        return this.m_captchaField != null;
    }

    public boolean hasConfigurationErrors() {
        return this.m_configurationErrors.size() > 0;
    }

    public boolean hasMandatoryFields() {
        return this.m_hasMandatoryFields;
    }

    public boolean hasTargetUri() {
        return CmsStringUtil.isNotEmpty((String)this.m_targetUri);
    }

    public void init(CmsFormHandler jsp, CmsMessages messages, boolean initial, String formConfigUri, String formAction) throws Exception {
        this.m_parameterMap = jsp.getParameterMap();
        if (CmsStringUtil.isEmpty((String)formConfigUri)) {
            formConfigUri = jsp.getRequestContext().getUri();
        }
        CmsFile file = jsp.getCmsObject().readFile(formConfigUri);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal((CmsObject)jsp.getCmsObject(), (CmsFile)file);
        Locale locale = jsp.getRequestContext().getLocale();
        this.initMembers();
        this.m_formAction = formAction;
        this.m_fields = new ArrayList();
        this.m_fieldsByName = new HashMap();
        this.initFormGlobalConfiguration(content, jsp.getCmsObject(), locale, messages);
        this.initInputFields(content, jsp, locale, messages, initial);
        this.initCaptchaField(jsp, content, locale, initial);
        if (this.captchaFieldIsOnInputPage() && this.m_captchaField != null) {
            this.addField(this.m_captchaField);
        }
    }

    public boolean isCheckPageSubmitted() {
        return "confirmed".equals(this.m_formAction);
    }

    public boolean isConfirmationMailEnabled() {
        return this.m_confirmationMailEnabled;
    }

    public boolean isConfirmationMailOptional() {
        return this.m_confirmationMailOptional;
    }

    public boolean isInputFormSubmitted() {
        return "submit".equals(this.m_formAction);
    }

    public I_CmsField removeCaptchaField() {
        int n = this.m_fields.size();
        for (int i = 0; i < n; ++i) {
            I_CmsField field = (I_CmsField)this.m_fields.get(i);
            if (field == null || !(class$org$opencms$frontend$templateone$form$CmsCaptchaField == null ? CmsForm.class$("org.opencms.frontend.templateone.form.CmsCaptchaField") : class$org$opencms$frontend$templateone$form$CmsCaptchaField).isAssignableFrom(this.getClass())) continue;
            this.removeField(field);
            return field;
        }
        return null;
    }

    protected void addField(I_CmsField field) {
        this.m_fields.add(field);
        this.m_fieldsByName.put(field.getName(), field);
    }

    protected String readSelectedFromRequest(I_CmsField field, String value) {
        String result = "";
        if (field.needsItems()) {
            try {
                String[] values = (String[])this.m_parameterMap.get(field.getName());
                for (int i = 0; i < values.length; ++i) {
                    if (!CmsStringUtil.isNotEmpty((String)values[i]) || !values[i].equals(value)) continue;
                    result = Boolean.toString(true);
                }
            }
            catch (Exception e) {}
        } else {
            result = Boolean.toString(true);
        }
        return result;
    }

    protected void removeField(I_CmsField field) {
        this.m_fields.remove(field);
        this.m_fieldsByName.remove(field);
    }

    protected void setConfigurationErrors(List configurationErrors) {
        this.m_configurationErrors = configurationErrors;
    }

    protected void setConfirmationMailCheckboxLabel(String confirmationMailCheckboxLabel) {
        this.m_confirmationMailCheckboxLabel = confirmationMailCheckboxLabel;
    }

    protected void setConfirmationMailEnabled(boolean confirmationMailEnabled) {
        this.m_confirmationMailEnabled = confirmationMailEnabled;
    }

    protected void setConfirmationMailField(int confirmationMailFieldName) {
        this.m_confirmationMailField = confirmationMailFieldName;
    }

    protected void setConfirmationMailOptional(boolean confirmationMailOptional) {
        this.m_confirmationMailOptional = confirmationMailOptional;
    }

    protected void setConfirmationMailSubject(String confirmationMailSubject) {
        this.m_confirmationMailSubject = confirmationMailSubject;
    }

    protected void setConfirmationMailText(String confirmationMailText) {
        this.m_confirmationMailText = confirmationMailText;
    }

    protected void setConfirmationMailTextPlain(String confirmationMailTextPlain) {
        this.m_confirmationMailTextPlain = confirmationMailTextPlain;
    }

    protected void setFormAttributes(String formAttributes) {
        this.m_formAttributes = formAttributes;
    }

    protected void setFormCheckText(String formCheckText) {
        this.m_formCheckText = formCheckText;
    }

    protected void setFormConfirmationText(String formConfirmationText) {
        this.m_formConfirmationText = formConfirmationText;
    }

    protected void setFormFieldAttributes(String formFieldAttributes) {
        this.m_formFieldAttributes = formFieldAttributes;
    }

    protected void setFormText(String formText) {
        this.m_formText = formText;
    }

    protected void setHasMandatoryFields(boolean hasMandatoryFields) {
        this.m_hasMandatoryFields = hasMandatoryFields;
    }

    protected void setMailBCC(String mailBCC) {
        this.m_mailBCC = mailBCC;
    }

    protected void setMailCC(String mailCC) {
        this.m_mailCC = mailCC;
    }

    protected void setMailFrom(String mailFrom) {
        this.m_mailFrom = mailFrom;
    }

    protected void setMailSubject(String mailSubject) {
        this.m_mailSubject = mailSubject;
    }

    protected void setMailSubjectPrefix(String mailSubjectPrefix) {
        this.m_mailSubjectPrefix = mailSubjectPrefix;
    }

    protected void setMailText(String mailText) {
        this.m_mailText = mailText;
    }

    protected void setMailTextPlain(String mailTextPlain) {
        this.m_mailTextPlain = mailTextPlain;
    }

    protected void setMailTo(String mailTo) {
        this.m_mailTo = mailTo;
    }

    protected void setMailType(String mailType) {
        this.m_mailType = mailType;
    }

    protected void setShowCheck(boolean showCheck) {
        this.m_showCheck = showCheck;
    }

    protected void setTargetUri(String targetUri) {
        this.m_targetUri = targetUri;
    }

    private I_CmsField createConfirmationMailCheckbox(CmsMessages messages, boolean initial) {
        CmsCheckboxField field = new CmsCheckboxField();
        field.setName(PARAM_SENDCONFIRMATION);
        field.setLabel(messages.key("form.confirmation.label"));
        boolean isChecked = false;
        if (!initial && Boolean.valueOf(this.getParameter(PARAM_SENDCONFIRMATION)).booleanValue()) {
            isChecked = true;
        }
        CmsFieldItem item = new CmsFieldItem(Boolean.toString(true), this.getConfirmationMailCheckboxLabel(), isChecked);
        ArrayList<CmsFieldItem> items = new ArrayList<CmsFieldItem>(1);
        items.add(item);
        field.setItems(items);
        return field;
    }

    private String getConfigurationValue(String value, String defaultValue) {
        if (CmsStringUtil.isNotEmpty((String)value)) {
            return value;
        }
        return defaultValue;
    }

    private void initCaptchaField(CmsJspActionElement jsp, CmsXmlContent xmlContent, Locale locale, boolean initial) {
        boolean submittedCheckPage;
        boolean captchaFieldIsOnInputPage = this.captchaFieldIsOnInputPage();
        boolean displayCheckPage = this.captchaFieldIsOnCheckPage() && this.isInputFormSubmitted();
        boolean bl = submittedCheckPage = this.captchaFieldIsOnCheckPage() && this.isCheckPageSubmitted();
        if (captchaFieldIsOnInputPage || displayCheckPage || submittedCheckPage) {
            CmsObject cms = jsp.getCmsObject();
            I_CmsXmlContentValue xmlValueCaptcha = xmlContent.getValue(NODE_CAPTCHA, locale);
            if (xmlValueCaptcha != null) {
                String xPathCaptcha = xmlValueCaptcha.getPath() + "/";
                String stringValue = xmlContent.getStringValue(cms, xPathCaptcha + NODE_FIELDLABEL, locale);
                String fieldLabel = this.getConfigurationValue(stringValue, "");
                String fieldValue = "";
                if (!initial && (fieldValue = this.getParameter("captchaphrase")) == null) {
                    fieldValue = "";
                }
                CmsCaptchaSettings captchaSettings = CmsCaptchaSettings.getInstance(jsp);
                captchaSettings.init(cms, xmlContent, locale);
                this.m_captchaField = new CmsCaptchaField(captchaSettings, fieldLabel, fieldValue);
            }
        }
    }

    private void initFormGlobalConfiguration(CmsXmlContent content, CmsObject cms, Locale locale, CmsMessages messages) throws Exception {
        String stringValue = content.getStringValue(cms, NODE_FORMTEXT, locale);
        this.setFormText(this.getConfigurationValue(stringValue, ""));
        stringValue = content.getStringValue(cms, NODE_FORMCONFIRMATION, locale);
        this.setFormConfirmationText(this.getConfigurationValue(stringValue, ""));
        stringValue = content.getStringValue(cms, NODE_TARGET_URI, locale);
        this.setTargetUri(this.getConfigurationValue(stringValue, ""));
        stringValue = content.getStringValue(cms, NODE_MAILFROM, locale);
        this.setMailFrom(this.getConfigurationValue(stringValue, ""));
        stringValue = content.getStringValue(cms, NODE_MAILTO, locale);
        this.setMailTo(this.getConfigurationValue(stringValue, ""));
        stringValue = content.getStringValue(cms, NODE_MAILSUBJECT, locale);
        this.setMailSubject(this.getConfigurationValue(stringValue, ""));
        stringValue = messages.key("form.mailsubject.prefix");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)stringValue)) {
            this.setMailSubjectPrefix(stringValue + " ");
        } else {
            this.setMailSubjectPrefix("");
        }
        CmsXmlHtmlValue mailTextValue = (CmsXmlHtmlValue)content.getValue(NODE_MAILTEXT, locale);
        if (mailTextValue != null) {
            stringValue = mailTextValue.getPlainText(cms);
            this.setMailTextPlain(this.getConfigurationValue(stringValue, ""));
            stringValue = mailTextValue.getStringValue(cms);
            this.setMailText(this.getConfigurationValue(stringValue, ""));
        } else {
            this.setMailTextPlain("");
            this.setMailText("");
        }
        String pathPrefix = "OptionalFormConfiguration/";
        stringValue = content.getStringValue(cms, pathPrefix + NODE_MAILTYPE, locale);
        this.setMailType(this.getConfigurationValue(stringValue, MAILTYPE_HTML));
        stringValue = content.getStringValue(cms, pathPrefix + NODE_MAILCC, locale);
        this.setMailCC(this.getConfigurationValue(stringValue, ""));
        stringValue = content.getStringValue(cms, pathPrefix + NODE_MAILBCC, locale);
        this.setMailBCC(this.getConfigurationValue(stringValue, ""));
        stringValue = content.getStringValue(cms, pathPrefix + NODE_SHOWCHECK, locale);
        this.setShowCheck(Boolean.valueOf(stringValue));
        stringValue = content.getStringValue(cms, pathPrefix + NODE_FORMCHECKTEXT, locale);
        this.setFormCheckText(this.getConfigurationValue(stringValue, ""));
        stringValue = content.getStringValue(cms, pathPrefix + NODE_FORMATTRIBUTES, locale);
        if (CmsStringUtil.isNotEmpty((String)stringValue)) {
            this.setFormAttributes(" " + stringValue);
        }
        if (CmsStringUtil.isNotEmpty((String)(stringValue = content.getStringValue(cms, pathPrefix + NODE_FORMFIELDATTRIBUTES, locale)))) {
            this.setFormFieldAttributes(" " + stringValue);
        } else {
            String defaultAttributes = messages.key("form.field.default.attributes");
            if (CmsStringUtil.isNotEmpty((String)defaultAttributes)) {
                this.setFormFieldAttributes(" " + defaultAttributes);
            }
        }
        pathPrefix = "OptionalConfirmationMail/";
        stringValue = content.getStringValue(cms, pathPrefix + NODE_CONFIRMATIONMAILENABLED, locale);
        this.setConfirmationMailEnabled(Boolean.valueOf(stringValue));
        if (this.isConfirmationMailEnabled()) {
            stringValue = content.getStringValue(cms, pathPrefix + NODE_CONFIRMATIONMAILSUBJECT, locale);
            this.setConfirmationMailSubject(this.getConfigurationValue(stringValue, ""));
            mailTextValue = (CmsXmlHtmlValue)content.getValue(pathPrefix + NODE_CONFIRMATIONMAILTEXT, locale);
            if (mailTextValue != null) {
                stringValue = mailTextValue.getPlainText(cms);
                this.setConfirmationMailTextPlain(this.getConfigurationValue(stringValue, ""));
                stringValue = mailTextValue.getStringValue(cms);
                this.setConfirmationMailText(this.getConfigurationValue(stringValue, ""));
            } else {
                this.setConfirmationMailTextPlain("");
                this.setConfirmationMailText("");
            }
            stringValue = content.getStringValue(cms, pathPrefix + NODE_CONFIRMATIONMAILFIELD, locale);
            int fieldIndex = 1;
            try {
                fieldIndex = Integer.parseInt(this.getConfigurationValue(stringValue, "1")) - 1;
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setConfirmationMailField(fieldIndex);
            stringValue = content.getStringValue(cms, pathPrefix + NODE_CONFIRMATIONMAILOPTIONAL, locale);
            this.setConfirmationMailOptional(Boolean.valueOf(stringValue));
            stringValue = content.getStringValue(cms, pathPrefix + NODE_CONFIRMATIONMAILCHECKBOXLABEL, locale);
            this.setConfirmationMailCheckboxLabel(this.getConfigurationValue(stringValue, messages.key("form.confirmation.checkbox")));
        }
    }

    private void initInputFields(CmsXmlContent content, CmsJspActionElement jsp, Locale locale, CmsMessages messages, boolean initial) throws CmsConfigurationException {
        CmsObject cms = jsp.getCmsObject();
        List fieldValues = content.getValues(NODE_INPUTFIELD, locale);
        int fieldValueSize = fieldValues.size();
        CmsFieldFactory fieldFactory = CmsFieldFactory.getSharedInstance();
        Map fileUploads = (Map)jsp.getRequest().getSession().getAttribute("fileitems");
        for (int i = 0; i < fieldValueSize; ++i) {
            I_CmsXmlContentValue inputField = (I_CmsXmlContentValue)fieldValues.get(i);
            String inputFieldPath = inputField.getPath() + "/";
            A_CmsField field = null;
            String stringValue = content.getStringValue(cms, inputFieldPath + NODE_FIELDTYPE, locale);
            field = fieldFactory.getField(stringValue);
            field.setName(inputFieldPath.substring(0, inputFieldPath.length() - 1));
            stringValue = content.getStringValue(cms, inputFieldPath + NODE_FIELDLABEL, locale);
            field.setLabel(this.getConfigurationValue(stringValue, ""));
            stringValue = content.getStringValue(cms, inputFieldPath + NODE_FIELDERRORMESSAGE, locale);
            field.setErrorMessage(stringValue);
            if (initial && CmsStringUtil.isEmpty((String)this.getParameter(field.getName()))) {
                String fieldValue = content.getStringValue(cms, inputFieldPath + NODE_FIELDDEFAULTVALUE, locale);
                if (CmsStringUtil.isNotEmpty((String)fieldValue)) {
                    CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms).setJspPageContext(jsp.getJspContext());
                    field.setValue(resolver.resolveMacros(fieldValue));
                }
            } else {
                String[] parameterValues = (String[])this.m_parameterMap.get(field.getName());
                StringBuffer value = new StringBuffer();
                if (parameterValues != null) {
                    for (int j = 0; j < parameterValues.length; ++j) {
                        if (j != 0) {
                            value.append(", ");
                        }
                        value.append(parameterValues[j]);
                    }
                }
                field.setValue(value.toString());
            }
            if (!(class$org$opencms$frontend$templateone$form$CmsHiddenField == null ? CmsForm.class$("org.opencms.frontend.templateone.form.CmsHiddenField") : class$org$opencms$frontend$templateone$form$CmsHiddenField).isAssignableFrom(field.getClass())) {
                FileItem attachment;
                stringValue = content.getStringValue(cms, inputFieldPath + NODE_FIELDVALIDATION, locale);
                if ((class$org$opencms$frontend$templateone$form$CmsEmailField == null ? CmsForm.class$("org.opencms.frontend.templateone.form.CmsEmailField") : class$org$opencms$frontend$templateone$form$CmsEmailField).isAssignableFrom(field.getClass()) && CmsStringUtil.isEmpty((String)stringValue)) {
                    field.setValidationExpression("(\\w[-._\\w]*\\w@\\w[-._\\w]*\\w\\.\\w{2,4})");
                } else {
                    field.setValidationExpression(this.getConfigurationValue(stringValue, ""));
                }
                if ((class$org$opencms$frontend$templateone$form$CmsFileUploadField == null ? CmsForm.class$("org.opencms.frontend.templateone.form.CmsFileUploadField") : class$org$opencms$frontend$templateone$form$CmsFileUploadField).isAssignableFrom(field.getClass()) && fileUploads != null && (attachment = (FileItem)fileUploads.get(field.getName())) != null) {
                    ((CmsFileUploadField)field).setFileSize(attachment.get().length);
                }
                stringValue = content.getStringValue(cms, inputFieldPath + NODE_FIELDMANDATORY, locale);
                boolean isMandatory = Boolean.valueOf(stringValue);
                field.setMandatory(isMandatory);
                if (isMandatory) {
                    this.setHasMandatoryFields(true);
                }
                if (field.needsItems()) {
                    String fieldValue = content.getStringValue(cms, inputFieldPath + NODE_FIELDDEFAULTVALUE, locale);
                    if (CmsStringUtil.isNotEmpty((String)fieldValue)) {
                        StringTokenizer T = new StringTokenizer(fieldValue, "|");
                        ArrayList<CmsFieldItem> items = new ArrayList<CmsFieldItem>(T.countTokens());
                        while (T.hasMoreTokens()) {
                            String part = T.nextToken();
                            boolean isPreselected = part.indexOf(42) != -1;
                            String value = "";
                            String label = "";
                            String selected = "";
                            int delimPos = part.indexOf(58);
                            if (delimPos != -1) {
                                value = part.substring(0, delimPos);
                                label = part.substring(delimPos + 1);
                            } else {
                                label = value = part;
                            }
                            if (isPreselected) {
                                value = CmsStringUtil.substitute((String)value, (String)"*", (String)"");
                                label = CmsStringUtil.substitute((String)label, (String)"*", (String)"");
                            }
                            if (initial) {
                                if (isPreselected) {
                                    selected = Boolean.toString(true);
                                }
                            } else {
                                selected = this.readSelectedFromRequest(field, value);
                            }
                            items.add(new CmsFieldItem(value, label, Boolean.valueOf(selected)));
                        }
                        field.setItems(items);
                    } else {
                        throw new CmsConfigurationException(Messages.get().container("ERR_INIT_INPUT_FIELD_MISSING_ITEM_2", (Object)field.getName(), (Object)field.getType()));
                    }
                }
            }
            this.addField(field);
        }
        this.validateFormConfiguration(messages);
        if (this.isConfirmationMailEnabled() && this.isConfirmationMailOptional()) {
            I_CmsField confirmationMailCheckbox = this.createConfirmationMailCheckbox(messages, initial);
            this.addField(confirmationMailCheckbox);
        }
    }

    private String getParameter(String parameter) {
        try {
            return ((String[])this.m_parameterMap.get(parameter))[0];
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private void initMembers() {
        this.setConfigurationErrors(new ArrayList());
        this.setFormAttributes("");
        this.setFormCheckText("");
        this.setFormConfirmationText("");
        this.setFormFieldAttributes("");
        this.setFormText("");
        this.setMailBCC("");
        this.setMailCC("");
        this.setMailFrom("");
        this.setMailSubject("");
        this.setMailText("");
        this.setMailTextPlain("");
        this.setMailTo("");
        this.setMailType(MAILTYPE_HTML);
        this.setConfirmationMailSubject("");
        this.setConfirmationMailText("");
        this.setConfirmationMailTextPlain("");
    }

    private void validateFormConfiguration(CmsMessages messages) {
        if (this.isConfirmationMailEnabled()) {
            I_CmsField confirmField;
            try {
                confirmField = (I_CmsField)this.getFields().get(this.getConfirmationMailField());
            }
            catch (IndexOutOfBoundsException e) {
                this.getConfigurationErrors().add(messages.key("form.configuration.error.emailfield.notfound"));
                this.setConfirmationMailEnabled(false);
                return;
            }
            if (!CmsEmailField.class.isAssignableFrom(confirmField.getClass())) {
                this.getConfigurationErrors().add(messages.key("form.configuration.error.emailfield.type"));
            }
        }
    }
}

