/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.form;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.activation.DataSource;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.opencms.frontend.templateone.form.CmsCaptchaField;
import org.opencms.frontend.templateone.form.CmsFieldItem;
import org.opencms.frontend.templateone.form.CmsForm;
import org.opencms.frontend.templateone.form.CmsPrivacyField;
import org.opencms.frontend.templateone.form.I_CmsField;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.mail.CmsHtmlMail;
import org.opencms.mail.CmsSimpleMail;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.util.CmsByteArrayDataSource;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class CmsFormHandler
extends CmsJspActionElement {
    public static final String ACTION_CONFIRMED = "confirmed";
    public static final String ACTION_CORRECT_INPUT = "correct";
    public static final String ACTION_SUBMIT = "submit";
    public static final String ERROR_MANDATORY = "mandatory";
    public static final String ERROR_VALIDATION = "validation";
    public static final String PARAM_FORMACTION = "formaction";
    public static final String ATTRIBUTE_FILEITEMS = "fileitems";
    private static final Log LOG = CmsLog.getLog((Object)CmsFormHandler.class);
    private static final String MODULE = "org.opencms.frontend.templateone.form";
    private Map m_errors;
    private CmsForm m_formConfiguration;
    private String m_hiddenFields;
    private boolean m_initial;
    private CmsMessages m_messages;
    private Boolean m_isValidatedCorrect;
    private Map m_parameterMap;
    private List m_mulipartFileItems;
    static /* synthetic */ Class class$org$opencms$frontend$templateone$form$CmsCheckboxField;
    static /* synthetic */ Class class$org$opencms$frontend$templateone$form$CmsCaptchaField;

    public CmsFormHandler(PageContext context, HttpServletRequest req, HttpServletResponse res) throws Exception {
        super(context, req, res);
        this.init(req, null);
    }

    public CmsFormHandler(PageContext context, HttpServletRequest req, HttpServletResponse res, String formConfigUri) throws Exception {
        super(context, req, res);
        this.init(req, formConfigUri);
    }

    public String convertToHtmlValue(String value) {
        return this.convertValue(value, "html");
    }

    public String convertToPlainValue(String value) {
        return this.convertValue(value, "");
    }

    public String convertValue(String value, String outputType) {
        value = "html".equalsIgnoreCase(outputType) ? CmsStringUtil.escapeHtml((String)value) : CmsStringUtil.substitute((String)value, (String)"<br>", (String)"\n");
        return value;
    }

    public String createHiddenFields() {
        if (CmsStringUtil.isEmpty((String)this.m_hiddenFields)) {
            List fields = this.getFormConfiguration().getFields();
            StringBuffer result = new StringBuffer(fields.size() * 8);
            int n = fields.size();
            for (int i = 0; i < n; ++i) {
                I_CmsField currentField = (I_CmsField)fields.get(i);
                if (currentField == null) continue;
                if ((class$org$opencms$frontend$templateone$form$CmsCheckboxField == null ? CmsFormHandler.class$("org.opencms.frontend.templateone.form.CmsCheckboxField") : class$org$opencms$frontend$templateone$form$CmsCheckboxField).isAssignableFrom(currentField.getClass())) {
                    Iterator k = currentField.getItems().iterator();
                    while (k.hasNext()) {
                        CmsFieldItem item = (CmsFieldItem)k.next();
                        if (!item.isSelected()) continue;
                        result.append("<input type=\"hidden\" name=\"");
                        result.append(currentField.getName());
                        result.append("\" value=\"");
                        result.append(CmsEncoder.escapeXml((String)item.getValue()));
                        result.append("\">\n");
                    }
                    continue;
                }
                if (!CmsStringUtil.isNotEmpty((String)currentField.getValue())) continue;
                result.append("<input type=\"hidden\" name=\"");
                result.append(currentField.getName());
                result.append("\" value=\"");
                result.append(CmsEncoder.escapeXml((String)currentField.getValue()));
                result.append("\">\n");
            }
            this.m_hiddenFields = result.toString();
        }
        return this.m_hiddenFields;
    }

    public Map getErrors() {
        return this.m_errors;
    }

    public CmsForm getFormConfiguration() {
        return this.m_formConfiguration;
    }

    public CmsMessages getMessages() {
        return this.m_messages;
    }

    public boolean hasValidationErrors() {
        return !this.isInitial() && this.getErrors().size() > 0;
    }

    public void init(HttpServletRequest req, String formConfigUri) throws Exception {
        this.m_mulipartFileItems = CmsRequestUtil.readMultipartFileItems((HttpServletRequest)req);
        this.m_parameterMap = this.m_mulipartFileItems != null ? CmsRequestUtil.readParameterMapFromMultiPart((String)this.getRequestContext().getEncoding(), (List)this.m_mulipartFileItems) : new HashMap();
        if (this.m_mulipartFileItems != null) {
            HashMap<String, FileItem> fileUploads = (HashMap<String, FileItem>)req.getSession().getAttribute(ATTRIBUTE_FILEITEMS);
            if (fileUploads == null) {
                fileUploads = new HashMap<String, FileItem>();
            }
            Iterator i = this.m_mulipartFileItems.iterator();
            while (i.hasNext()) {
                FileItem fileItem = (FileItem)i.next();
                if (!CmsStringUtil.isNotEmpty((String)fileItem.getName())) continue;
                fileUploads.put(fileItem.getFieldName(), fileItem);
                this.m_parameterMap.put(fileItem.getFieldName(), new String[]{fileItem.getName()});
            }
            req.getSession().setAttribute(ATTRIBUTE_FILEITEMS, fileUploads);
        } else {
            req.getSession().removeAttribute(ATTRIBUTE_FILEITEMS);
        }
        String formAction = this.getParameter(PARAM_FORMACTION);
        this.setErrors(new HashMap());
        this.m_isValidatedCorrect = null;
        this.setInitial(CmsStringUtil.isEmpty((String)formAction));
        CmsModule module = OpenCms.getModuleManager().getModule(MODULE);
        String para = module.getParameter("message", "/org/opencms/frontend/templateone/form/workplace");
        this.setMessages(new CmsMessages(para, this.getRequestContext().getLocale()));
        this.setFormConfiguration(new CmsForm(this, this.getMessages(), this.isInitial(), formConfigUri, formAction));
    }

    public boolean isInitial() {
        return this.m_initial;
    }

    public Map getParameterMap() {
        return this.m_parameterMap;
    }

    public void sendConfirmationMail() throws Exception {
        I_CmsField mailField = (I_CmsField)this.getFormConfiguration().getFields().get(this.getFormConfiguration().getConfirmationMailField());
        String mailTo = mailField.getValue();
        if (this.getFormConfiguration().getMailType().equals("html")) {
            CmsHtmlMail theMail = new CmsHtmlMail();
            theMail.setCharset(this.getCmsObject().getRequestContext().getEncoding());
            if (CmsStringUtil.isNotEmpty((String)this.getFormConfiguration().getMailFrom())) {
                theMail.setFrom(this.getFormConfiguration().getMailFrom());
            }
            theMail.setTo((Collection)this.createInternetAddresses(mailTo));
            theMail.setSubject(this.getFormConfiguration().getMailSubjectPrefix() + this.getFormConfiguration().getConfirmationMailSubject());
            theMail.setHtmlMsg(this.createMailTextFromFields(true, true));
            theMail.setTextMsg(this.createMailTextFromFields(false, true));
            theMail.send();
        } else {
            CmsSimpleMail theMail = new CmsSimpleMail();
            theMail.setCharset(this.getCmsObject().getRequestContext().getEncoding());
            if (CmsStringUtil.isNotEmpty((String)this.getFormConfiguration().getMailFrom())) {
                theMail.setFrom(this.getFormConfiguration().getMailFrom());
            }
            theMail.setTo((Collection)this.createInternetAddresses(mailTo));
            theMail.setSubject(this.getFormConfiguration().getMailSubjectPrefix() + this.getFormConfiguration().getConfirmationMailSubject());
            theMail.setMsg(this.createMailTextFromFields(false, true));
            theMail.send();
        }
    }

    public boolean sendMail() {
        try {
            if (this.getFormConfiguration().isConfirmationMailEnabled() && (!this.getFormConfiguration().isConfirmationMailOptional() || Boolean.valueOf(this.getParameter("sendconfirmation")).booleanValue())) {
                this.sendConfirmationMail();
            }
            if (this.getFormConfiguration().getMailType().equals("html")) {
                CmsHtmlMail theMail = new CmsHtmlMail();
                theMail.setCharset(this.getCmsObject().getRequestContext().getEncoding());
                if (CmsStringUtil.isNotEmpty((String)this.getFormConfiguration().getMailFrom())) {
                    theMail.setFrom(this.getFormConfiguration().getMailFrom());
                }
                theMail.setTo((Collection)this.createInternetAddresses(this.getFormConfiguration().getMailTo()));
                theMail.setCc((Collection)this.createInternetAddresses(this.getFormConfiguration().getMailCC()));
                theMail.setBcc((Collection)this.createInternetAddresses(this.getFormConfiguration().getMailBCC()));
                theMail.setSubject(this.getFormConfiguration().getMailSubjectPrefix() + this.getFormConfiguration().getMailSubject());
                theMail.setHtmlMsg(this.createMailTextFromFields(true, false));
                theMail.setTextMsg(this.createMailTextFromFields(false, false));
                Map fileUploads = (Map)this.getRequest().getSession().getAttribute(ATTRIBUTE_FILEITEMS);
                Iterator i = fileUploads.values().iterator();
                while (i.hasNext()) {
                    FileItem attachment = (FileItem)i.next();
                    if (attachment == null) continue;
                    String filename = attachment.getName().substring(attachment.getName().lastIndexOf(File.separator) + 1);
                    theMail.attach((DataSource)new CmsByteArrayDataSource(filename, attachment.get(), OpenCms.getResourceManager().getMimeType(filename, null, "application/octet-stream")), filename, filename);
                }
                theMail.send();
            } else {
                CmsSimpleMail theMail = new CmsSimpleMail();
                theMail.setCharset(this.getCmsObject().getRequestContext().getEncoding());
                if (CmsStringUtil.isNotEmpty((String)this.getFormConfiguration().getMailFrom())) {
                    theMail.setFrom(this.getFormConfiguration().getMailFrom());
                }
                theMail.setTo((Collection)this.createInternetAddresses(this.getFormConfiguration().getMailTo()));
                theMail.setCc((Collection)this.createInternetAddresses(this.getFormConfiguration().getMailCC()));
                theMail.setBcc((Collection)this.createInternetAddresses(this.getFormConfiguration().getMailBCC()));
                theMail.setSubject(this.getFormConfiguration().getMailSubjectPrefix() + this.getFormConfiguration().getMailSubject());
                theMail.setMsg(this.createMailTextFromFields(false, false));
                theMail.send();
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            this.m_errors.put("sendmail", e.getMessage());
            return false;
        }
        return true;
    }

    private String getParameter(String parameter) {
        try {
            return ((String[])this.m_parameterMap.get(parameter))[0];
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public boolean showCheck() {
        boolean result = false;
        if (this.getFormConfiguration().getShowCheck() && ACTION_SUBMIT.equals(this.getParameter(PARAM_FORMACTION))) {
            result = true;
        } else if (this.getFormConfiguration().captchaFieldIsOnCheckPage() && ACTION_CONFIRMED.equals(this.getParameter(PARAM_FORMACTION)) && !this.validate()) {
            result = true;
        }
        return result;
    }

    public boolean showForm() {
        boolean result = false;
        if (this.isInitial()) {
            result = true;
        } else if (ACTION_CORRECT_INPUT.equalsIgnoreCase(this.getParameter(PARAM_FORMACTION))) {
            result = true;
        } else if (ACTION_SUBMIT.equalsIgnoreCase(this.getParameter(PARAM_FORMACTION)) && !this.validate()) {
            result = true;
            if (this.getFormConfiguration().hasCaptchaField() && this.getFormConfiguration().captchaFieldIsOnCheckPage()) {
                this.getFormConfiguration().removeCaptchaField();
            }
        } else if (ACTION_CONFIRMED.equalsIgnoreCase(this.getParameter(PARAM_FORMACTION)) && this.getFormConfiguration().captchaFieldIsOnCheckPage() && !this.validate()) {
            result = false;
        }
        return result;
    }

    public boolean validate() {
        if (this.m_isValidatedCorrect != null) {
            return this.m_isValidatedCorrect;
        }
        boolean allOk = true;
        List fields = this.getFormConfiguration().getFields();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            String validationError;
            I_CmsField currentField = (I_CmsField)fields.get(i);
            if (currentField == null || (class$org$opencms$frontend$templateone$form$CmsCaptchaField == null ? CmsFormHandler.class$("org.opencms.frontend.templateone.form.CmsCaptchaField") : class$org$opencms$frontend$templateone$form$CmsCaptchaField).isAssignableFrom(currentField.getClass()) || !CmsStringUtil.isNotEmpty((String)(validationError = currentField.validate(this)))) continue;
            this.getErrors().put(currentField.getName(), validationError);
            allOk = false;
        }
        CmsCaptchaField captchaField = this.m_formConfiguration.getCaptchaField();
        if (captchaField != null) {
            boolean captchaFieldIsOnCheckPage;
            boolean captchaFieldIsOnInputPage = this.getFormConfiguration().captchaFieldIsOnInputPage() && this.getFormConfiguration().isInputFormSubmitted();
            boolean bl = captchaFieldIsOnCheckPage = this.getFormConfiguration().captchaFieldIsOnCheckPage() && this.getFormConfiguration().isCheckPageSubmitted();
            if ((captchaFieldIsOnInputPage || captchaFieldIsOnCheckPage) && !captchaField.validateCaptchaPhrase(this, captchaField.getValue())) {
                this.getErrors().put(captchaField.getName(), ERROR_VALIDATION);
                allOk = false;
            }
        }
        this.m_isValidatedCorrect = allOk;
        return allOk;
    }

    protected List createInternetAddresses(String mailAddresses) throws AddressException {
        if (CmsStringUtil.isNotEmpty((String)mailAddresses)) {
            StringTokenizer T = new StringTokenizer(mailAddresses, ";");
            ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>(T.countTokens());
            while (T.hasMoreTokens()) {
                InternetAddress address = new InternetAddress(T.nextToken());
                addresses.add(address);
            }
            return addresses;
        }
        return Collections.EMPTY_LIST;
    }

    protected String createMailTextFromFields(boolean isHtmlMail, boolean isConfirmationMail) {
        List fieldValues = this.getFormConfiguration().getFields();
        StringBuffer result = new StringBuffer(fieldValues.size() * 8);
        if (isHtmlMail) {
            result.append("<html><head>\n");
            result.append("<style type=\"text/css\"><!--\n");
            String style = this.getMessages().key("form.email.style.body");
            if (CmsStringUtil.isNotEmpty((String)style)) {
                result.append("body,h1,p,td { ");
                result.append(style);
                result.append(" }\n");
            }
            if (CmsStringUtil.isNotEmpty((String)(style = this.getMessages().key("form.email.style.h1")))) {
                result.append("h1 { ");
                result.append(style);
                result.append(" }\n");
            }
            if (CmsStringUtil.isNotEmpty((String)(style = this.getMessages().key("form.email.style.p")))) {
                result.append("p { ");
                result.append(style);
                result.append(" }\n");
            }
            if (CmsStringUtil.isNotEmpty((String)(style = this.getMessages().key("form.email.style.fields")))) {
                result.append("table.fields { ");
                result.append(style);
                result.append(" }\n");
            }
            if (CmsStringUtil.isNotEmpty((String)(style = this.getMessages().key("form.email.style.fieldlabel")))) {
                result.append("td.fieldlabel { ");
                result.append(style);
                result.append(" }\n");
            }
            if (CmsStringUtil.isNotEmpty((String)(style = this.getMessages().key("form.email.style.fieldvalue")))) {
                result.append("td.fieldvalue { ");
                result.append(style);
                result.append(" }\n");
            }
            if (CmsStringUtil.isNotEmpty((String)(style = this.getMessages().key("form.email.style.misc")))) {
                result.append(this.getMessages().key("form.email.style.misc"));
            }
            result.append("//--></style>\n");
            result.append("</head><body>\n");
            if (isConfirmationMail) {
                result.append(this.getFormConfiguration().getConfirmationMailText());
            } else {
                result.append(this.getFormConfiguration().getMailText());
            }
            result.append("<table border=\"0\" class=\"fields\">\n");
        } else {
            if (isConfirmationMail) {
                result.append(this.getFormConfiguration().getConfirmationMailTextPlain());
            } else {
                result.append(this.getFormConfiguration().getMailTextPlain());
            }
            result.append("\n\n");
        }
        Iterator i = fieldValues.iterator();
        while (i.hasNext()) {
            I_CmsField current = (I_CmsField)i.next();
            if (isHtmlMail && !(current instanceof CmsPrivacyField)) {
                result.append("<tr><td class=\"fieldlabel\">");
                result.append(current.getLabel());
                result.append("</td><td class=\"fieldvalue\">");
                result.append(this.convertToHtmlValue(current.toString()));
                result.append("</td></tr>\n");
                continue;
            }
            if (current instanceof CmsPrivacyField) continue;
            result.append(current.getLabel());
            result.append("\t");
            result.append(current.toString());
            result.append("\n");
        }
        if (isHtmlMail) {
            result.append("</table>\n");
            if (!isConfirmationMail && this.getFormConfiguration().hasConfigurationErrors()) {
                result.append("<h1>");
                result.append(this.getMessages().key("form.configuration.error.headline"));
                result.append("</h1>\n<p>");
                for (int k = 0; k < this.getFormConfiguration().getConfigurationErrors().size(); ++k) {
                    result.append(this.getFormConfiguration().getConfigurationErrors().get(k));
                    result.append("<br>");
                }
                result.append("</p>\n");
            }
            result.append("</body></html>");
        } else if (!isConfirmationMail && this.getFormConfiguration().hasConfigurationErrors()) {
            result.append("\n");
            result.append(this.getMessages().key("form.configuration.error.headline"));
            result.append("\n");
            for (int k = 0; k < this.getFormConfiguration().getConfigurationErrors().size(); ++k) {
                result.append(this.getFormConfiguration().getConfigurationErrors().get(k));
                result.append("\n");
            }
        }
        return result.toString();
    }

    protected void setErrors(Map errors) {
        this.m_errors = errors;
    }

    protected void setFormConfiguration(CmsForm configuration) {
        this.m_formConfiguration = configuration;
    }

    protected void setInitial(boolean initial) {
        this.m_initial = initial;
    }

    protected void setMessages(CmsMessages messages) {
        this.m_messages = messages;
    }
}

