/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.form;

import org.opencms.frontend.templateone.form.CmsCheckboxField;
import org.opencms.frontend.templateone.form.CmsFieldItem;
import org.opencms.frontend.templateone.form.CmsFormHandler;
import org.opencms.i18n.CmsMessages;
import org.opencms.util.CmsStringUtil;

public class CmsPrivacyField
extends CmsCheckboxField {
    private static final String TYPE = "privacy";

    public static String getStaticType() {
        return TYPE;
    }

    public String buildHtml(CmsFormHandler formHandler, CmsMessages messages, String errorKey) {
        StringBuffer buf = new StringBuffer();
        String fieldLabel = this.getLabel();
        String errorMessage = "";
        String mandatory = "";
        boolean showMandatory = false;
        if (this.isMandatory()) {
            mandatory = messages.key("form.html.mandatory");
        }
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)fieldLabel)) {
            fieldLabel = fieldLabel + mandatory;
            showMandatory = true;
        } else {
            fieldLabel = "&nbsp;";
        }
        if (CmsStringUtil.isNotEmpty((String)errorKey)) {
            errorMessage = "mandatory".equals(errorKey) ? messages.key("form.error.mandatory") : (CmsStringUtil.isNotEmpty((String)this.getErrorMessage()) ? this.getErrorMessage() : messages.key("form.error.validation"));
            errorMessage = messages.key("form.html.error.start") + errorMessage + messages.key("form.html.error.end");
            fieldLabel = messages.key("form.html.label.error.start") + fieldLabel + messages.key("form.html.label.error.end");
        }
        if (this.showRowStart(messages.key("form.html.col.two"))) {
            buf.append(messages.key("form.html.row.start")).append("\n");
        }
        if (this.getItems().size() > 0) {
            String link;
            buf.append(messages.key("form.html.label.start")).append(fieldLabel).append(messages.key("form.html.label.end")).append("\n");
            buf.append(messages.key("form.html.field.start")).append("\n");
            CmsFieldItem curOption = (CmsFieldItem)this.getItems().get(0);
            String checked = "";
            if (curOption.isSelected()) {
                checked = " checked=\"checked\"";
            }
            if ((link = curOption.getLabel()).startsWith("/")) {
                link = formHandler.link(link);
            }
            buf.append("<input type=\"checkbox\" name=\"").append(this.getName()).append("\" value=\"").append(curOption.getValue()).append("\"").append(checked).append("/>");
            buf.append("<a href=\"").append(link).append("\" rel=\"_blank\">").append(curOption.getValue()).append(showMandatory ? "" : mandatory).append("</a>");
            buf.append("\n");
        }
        buf.append(errorMessage).append("\n");
        buf.append(messages.key("form.html.field.end")).append("\n");
        if (this.showRowEnd(messages.key("form.html.col.two"))) {
            buf.append(messages.key("form.html.row.end")).append("\n");
        }
        return buf.toString();
    }

    public String getType() {
        return TYPE;
    }
}

