/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCalendarWidget;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.history.CmsHistoryClear;
import org.opencms.workplace.tools.history.Messages;

public class CmsHistoryClearDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "histclear";
    public static final String[] PAGES = new String[]{"page1"};
    protected static final String CLEAR_ACTION_REPORT = "/system/workplace/admin/history/reports/clearhistory.jsp";
    protected CmsHistoryClear m_historyClear;

    public CmsHistoryClearDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsHistoryClearDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() throws IOException, ServletException {
        ArrayList<CmsIllegalArgumentException> errors = new ArrayList<CmsIllegalArgumentException>();
        this.setDialogObject(this.m_historyClear);
        if (this.m_historyClear.getKeepVersions() < 0) {
            errors.add(new CmsIllegalArgumentException(Messages.get().container("GUI_HISTORY_CLEAR_INVALID_SETTINGS_0")));
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("classname", ((Object)((Object)this)).getClass().getName());
            params.put("style", "new");
            params.put("closelink", CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)"/history"));
            this.getToolManager().jspForwardPage((CmsWorkplace)this, CLEAR_ACTION_REPORT, params);
        }
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.createWidgetBlockStart(this.key("GUI_HISTORY_CLEAR_BLOCK_LABEL_0")));
            String versionStr = OpenCms.getSystemInfo().getHistoryVersions() == -1 ? this.key("GUI_HISTORY_SETTINGS_VERSIONS_UNLIMITED_0") : String.valueOf(OpenCms.getSystemInfo().getHistoryVersions());
            result.append(this.key("GUI_HISTORY_CLEAR_VERSIONINFO_1", new Object[]{versionStr}));
            result.append("<p>");
            result.append(this.createDialogRowsHtml(0, 2));
            result.append(this.createWidgetBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initHistoryClearObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_historyClear, "keepVersions", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getVersions())));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_historyClear, "clearDeleted", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_historyClear, "clearOlderThan", PAGES[0], (I_CmsWidget)new CmsCalendarWidget()));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initHistoryClearObject() {
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) ? new CmsHistoryClear() : this.getDialogObject();
        this.m_historyClear = !(o instanceof CmsHistoryClear) ? new CmsHistoryClear() : (CmsHistoryClear)o;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    private List getVersions() {
        ArrayList<CmsSelectWidgetOption> ret = new ArrayList<CmsSelectWidgetOption>();
        int defaultHistoryVersions = OpenCms.getSystemInfo().getHistoryVersions();
        int historyVersions = 0;
        ret.add(new CmsSelectWidgetOption("-1", true, Messages.get().getBundle().key("GUI_HISTORY_CLEAR_VERSION_SELECT_0")));
        while (historyVersions < 50) {
            if (++historyVersions % 5 != 0 && historyVersions > 10) continue;
            ret.add(new CmsSelectWidgetOption(String.valueOf(historyVersions), false, String.valueOf(historyVersions)));
        }
        if (defaultHistoryVersions > historyVersions) {
            ret.add(new CmsSelectWidgetOption(String.valueOf(defaultHistoryVersions), false, String.valueOf(defaultHistoryVersions)));
        }
        return ret;
    }
}

