/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.history;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsRadioSelectWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.history.CmsHistorySettings;
import org.opencms.workplace.tools.history.Messages;

public class CmsHistorySettingsDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "histsettings";
    public static final String[] PAGES = new String[]{"page1"};
    protected CmsHistorySettings m_historySettings;

    public CmsHistorySettingsDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsHistorySettingsDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<CmsIllegalArgumentException> errors = new ArrayList<CmsIllegalArgumentException>();
        this.setDialogObject(this.m_historySettings);
        boolean enabled = this.m_historySettings.getVersions() > -2;
        int versions = this.m_historySettings.getVersions();
        int versionsDeleted = 0;
        switch (this.m_historySettings.getMode()) {
            case 0: {
                versionsDeleted = 0;
                break;
            }
            case 1: {
                versionsDeleted = 1;
                break;
            }
            case 2: {
                if (enabled) {
                    versionsDeleted = versions;
                    break;
                }
                errors.add(new CmsIllegalArgumentException(Messages.get().container("GUI_HISTORY_SETTINGS_INVALID_0")));
                break;
            }
            default: {
                versionsDeleted = 0;
            }
        }
        OpenCms.getSystemInfo().setVersionHistorySettings(enabled, versions, versionsDeleted);
        OpenCms.writeConfiguration((Class)CmsSystemConfiguration.class);
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.createWidgetBlockStart(this.key("GUI_HISTORY_SETTINGS_BLOCK_LABEL_0")));
            result.append(this.createDialogRowsHtml(0, 1));
            result.append(this.createWidgetBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initHistorySettingsObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_historySettings, "versions", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getVersions())));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_historySettings, "mode", PAGES[0], (I_CmsWidget)new CmsRadioSelectWidget(this.getModes())));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initHistorySettingsObject() {
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) ? new CmsHistorySettings() : this.getDialogObject();
        this.m_historySettings = !(o instanceof CmsHistorySettings) ? new CmsHistorySettings() : (CmsHistorySettings)o;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    private List getModes() {
        ArrayList<CmsSelectWidgetOption> ret = new ArrayList<CmsSelectWidgetOption>();
        ret.add(new CmsSelectWidgetOption(String.valueOf(0), this.m_historySettings.getMode() == 0, this.key("GUI_HISTORY_SETTINGS_MODE_DISABLED_0")));
        ret.add(new CmsSelectWidgetOption(String.valueOf(1), this.m_historySettings.getMode() == 1, this.key("GUI_HISTORY_SETTINGS_MODE_KEEP_NO_VERSIONS_0")));
        ret.add(new CmsSelectWidgetOption(String.valueOf(2), this.m_historySettings.getMode() == 2, this.key("GUI_HISTORY_SETTINGS_MODE_KEEP_WITH_VERSIONS_0")));
        return ret;
    }

    private List getVersions() {
        ArrayList<CmsSelectWidgetOption> ret = new ArrayList<CmsSelectWidgetOption>();
        int defaultHistoryVersions = OpenCms.getSystemInfo().getHistoryVersions();
        int historyVersions = 0;
        ret.add(new CmsSelectWidgetOption(String.valueOf(-2), defaultHistoryVersions == -2, this.key("GUI_HISTORY_SETTINGS_VERSIONS_DISABLED_0")));
        while (historyVersions < 50) {
            if (++historyVersions % 5 != 0 && historyVersions > 10) continue;
            boolean defaultValue = defaultHistoryVersions == historyVersions;
            ret.add(new CmsSelectWidgetOption(String.valueOf(historyVersions), defaultValue, String.valueOf(historyVersions)));
        }
        if (defaultHistoryVersions > historyVersions) {
            ret.add(new CmsSelectWidgetOption(String.valueOf(defaultHistoryVersions), true, String.valueOf(defaultHistoryVersions)));
        }
        ret.add(new CmsSelectWidgetOption(String.valueOf(-1), defaultHistoryVersions == -1, this.key("GUI_HISTORY_SETTINGS_VERSIONS_UNLIMITED_0")));
        return ret;
    }
}

