/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.administration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRfsException;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.administration.Messages;

public abstract class A_CmsImportFromHttp
extends CmsDialog {
    public static final String DIALOG_TYPE = "ImportHttp";
    public static final String PARAM_IMPORTFILE = "importfile";
    private CmsException m_exception;
    private String m_paramImportfile;

    public A_CmsImportFromHttp(CmsJspActionElement jsp) {
        super(jsp);
    }

    public A_CmsImportFromHttp(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public abstract void actionCommit() throws IOException, ServletException;

    public void displayDialog() throws IOException, JspException, ServletException {
        switch (this.getAction()) {
            case 4: {
                this.actionCloseDialog();
                break;
            }
            case 3: {
                this.setParamAction("ok");
                this.actionCommit();
                if (this.getException() == null) break;
            }
            default: {
                this.setParamAction("ok");
                JspWriter out = this.getJsp().getJspContext().getOut();
                out.print(this.defaultActionHtml());
            }
        }
    }

    public abstract String getDialogReturnUri();

    public abstract String getImportMessage();

    public String getParamImportfile() {
        return this.m_paramImportfile;
    }

    public abstract String getStarttext();

    public void setParamImportfile(String importfile) {
        this.m_paramImportfile = importfile;
    }

    protected String getAdditionalParameters() {
        return "";
    }

    protected String copyFileToServer(String destination) throws CmsIllegalArgumentException, CmsRfsException {
        Iterator i = this.getMultiPartFileItems().iterator();
        FileItem fi = null;
        while (i.hasNext() && (fi = (FileItem)i.next()).getName() == null) {
        }
        String fileName = null;
        if (fi != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)fi.getName())) {
            fileName = fi.getName();
            byte[] content = fi.get();
            fi.delete();
            fileName = CmsResource.getName((String)fileName.replace('\\', '/'));
            File discFolder = new File(OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSystemInfo().getPackagesRfsPath() + File.separator));
            if (!discFolder.exists() && !discFolder.mkdir()) {
                throw new CmsRfsException(Messages.get().container("ERR_FOLDER_NOT_CREATED_0"));
            }
            File discFile = new File(OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(destination + File.separator + fileName));
            try {
                FileOutputStream s = new FileOutputStream(discFile);
                ((OutputStream)s).write(content);
                ((OutputStream)s).close();
            }
            catch (FileNotFoundException e) {
                throw new CmsRfsException(Messages.get().container("ERR_FILE_NOT_FOUND_1", (Object)fileName, (Object)e));
            }
            catch (IOException e) {
                throw new CmsRfsException(Messages.get().container("ERR_FILE_NOT_WRITTEN_0", (Object)e));
            }
        } else {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_FILE_NOT_SPECIFIED_0"));
        }
        this.setParamImportfile(fileName);
        return fileName;
    }

    protected String createDialogErrorMessage() {
        if (this.getException() != null) {
            StringBuffer result = new StringBuffer(8);
            result.append(this.dialogBlockStart(""));
            result.append("<table border=\"0\">\n");
            result.append("<tr><td><img src=\"");
            result.append(A_CmsImportFromHttp.getSkinUri()).append("commons/");
            result.append("error.png");
            result.append("\" border=\"0\" alt=\"\"></td><td class=\"xmlTdError maxwidth\">");
            Object t = this.getException();
            while (t != null) {
                result.append(t.getLocalizedMessage());
                if ((t = t.getCause()) == null) continue;
                result.append("<br>");
            }
            result.append("</table>\n");
            result.append(this.dialogBlockEnd());
            return result.toString();
        }
        return "";
    }

    protected String defaultActionHtml() {
        StringBuffer result = new StringBuffer(32);
        result.append(this.htmlStart());
        result.append(this.bodyStart(null));
        result.append(this.dialogStart());
        result.append(this.dialogContentStart(""));
        result.append("<form name=\"main\" class=\"nomargin\" action=\"");
        result.append(this.getJsp().link(this.getDialogReturnUri()));
        result.append("\" method=\"post\" onsubmit=\"submitAction('");
        result.append("ok");
        result.append("', null, 'main');\" enctype=\"multipart/form-data\">\n");
        result.append(this.paramsAsHidden());
        if (this.getParamFramename() == null) {
            result.append("<input type=\"hidden\" name=\"");
            result.append("framename");
            result.append("\" value=\"\">");
        }
        result.append(this.createDialogErrorMessage());
        result.append(this.dialogBlockStart(this.getStarttext()));
        result.append("<table border=\"0\" width=\"100%\">\n");
        result.append("<tr>\n\t<td style=\"white-space: nowrap;\" unselectable=\"on\">");
        result.append(this.getImportMessage());
        result.append(":</td>\n");
        result.append("\t<td class=\"maxwidth\">");
        result.append("<input type=\"file\" name=\"");
        result.append(PARAM_IMPORTFILE);
        result.append("\" class=\"maxwidth\" accept=\"application/zip\">");
        result.append("</td>\n</tr>");
        result.append(this.getAdditionalParameters());
        result.append("</table>\n");
        result.append(this.dialogBlockEnd());
        result.append(this.dialogContentEnd());
        result.append(this.dialogButtonsOkCancel());
        result.append("</form>\n");
        result.append(this.dialogEnd());
        result.append(this.bodyEnd());
        result.append(this.htmlEnd());
        return result.toString();
    }

    protected CmsException getException() {
        return this.m_exception;
    }

    protected abstract void initMessages();

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(((Object)((Object)this)).getClass().getName());
        this.fillParamValues(request);
        if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
        }
    }

    protected void setException(CmsException exception) {
        this.m_exception = exception;
    }
}

