/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.administration;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.administration.CmsAdminContextHelpMenuItem;
import org.opencms.workplace.administration.CmsAdminMenuGroup;
import org.opencms.workplace.administration.CmsAdminMenuItem;
import org.opencms.workplace.administration.Messages;
import org.opencms.workplace.tools.CmsIdentifiableObjectContainer;
import org.opencms.workplace.tools.CmsTool;
import org.opencms.workplace.tools.CmsToolDialog;
import org.opencms.workplace.tools.CmsToolMacroResolver;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.I_CmsIdentifiableObjectContainer;

public class CmsAdminMenu
extends CmsToolDialog {
    public static final String DEFAULT_TARGET = "admin_content";
    private I_CmsIdentifiableObjectContainer m_groupContainer = new CmsIdentifiableObjectContainer(true, true);

    public CmsAdminMenu(CmsJspActionElement jsp) {
        super(jsp);
        try {
            this.initAdminTool();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.installMenu();
    }

    public void addGroup(CmsAdminMenuGroup group) {
        this.m_groupContainer.addIdentifiableObject(group.getName(), (Object)group);
    }

    public void addGroup(CmsAdminMenuGroup group, float position) {
        this.m_groupContainer.addIdentifiableObject(group.getName(), (Object)group, position);
    }

    public CmsAdminMenuItem addItem(String groupName, String name, String icon, String link, String helpText, boolean enabled, float position, String target) {
        CmsAdminMenuGroup group = this.getGroup(groupName = CmsToolMacroResolver.resolveMacros((String)groupName, (CmsWorkplace)this));
        if (group == null) {
            String gid = "group" + this.m_groupContainer.elementList().size();
            group = new CmsAdminMenuGroup(gid, groupName);
            this.addGroup(group, position);
        }
        String id = "item" + group.getId() + group.getMenuItems().size();
        CmsAdminMenuItem item = new CmsAdminMenuItem(id, name, icon, link, helpText, enabled, target);
        group.addMenuItem(item, position);
        return item;
    }

    public String allRequestParamsAsUrl(Collection excludes) {
        StringBuffer result = new StringBuffer(512);
        Map params = this.getJsp().getRequest().getParameterMap();
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String param = (String)entry.getKey();
            if (excludes != null && excludes.contains(param)) continue;
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(param);
            result.append("=");
            String value = entry.getValue() instanceof String[] ? ((String[])entry.getValue())[0] : (String)entry.getValue();
            String encoded = CmsEncoder.encode((String)value, (String)this.getCms().getRequestContext().getEncoding());
            result.append(encoded);
        }
        return result.toString();
    }

    public CmsAdminMenuGroup getGroup(String name) {
        return (CmsAdminMenuGroup)this.m_groupContainer.getObject(name);
    }

    public CmsToolManager getToolManager() {
        return OpenCms.getWorkplaceManager().getToolManager();
    }

    public String groupHtml(CmsWorkplace wp) {
        StringBuffer html = new StringBuffer(2048);
        Iterator itHtml = this.m_groupContainer.elementList().iterator();
        while (itHtml.hasNext()) {
            CmsAdminMenuGroup group = (CmsAdminMenuGroup)itHtml.next();
            html.append(group.groupHtml(wp));
        }
        return html.toString();
    }

    public void installMenu() {
        this.m_groupContainer.clear();
        CmsAdminMenuGroup helpMenu = new CmsAdminMenuGroup("help", Messages.get().getBundle(this.getLocale()).key("GUI_ADMIN_MENU_HELP_GROUP_0"));
        helpMenu.addMenuItem(new CmsAdminContextHelpMenuItem());
        this.addGroup(helpMenu);
        Iterator itElems = this.getToolManager().getToolsForPath((CmsWorkplace)this, this.getToolManager().getBaseToolPath((CmsWorkplace)this), false).iterator();
        while (itElems.hasNext()) {
            int pos;
            String path;
            CmsTool tool = (CmsTool)itElems.next();
            String link = tool.getHandler().getLink();
            if (link.indexOf("?") > 0) {
                link = link.substring(0, link.indexOf("?"));
            }
            if (!this.getCms().existsResource(link) || !tool.getHandler().isVisible((CmsWorkplace)this) || CmsStringUtil.isEmpty((String)(path = tool.getHandler().getPath().substring(this.getToolManager().getBaseToolPath((CmsWorkplace)this).length()))) || path.indexOf("/", (pos = tool.getHandler().getPath().indexOf("/")) + 1) >= 0) continue;
            this.addItem(tool.getHandler().getGroup(), tool.getHandler().getShortName(), tool.getHandler().getSmallIconPath(), CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)tool.getHandler().getPath()), tool.getHandler().isEnabled((CmsWorkplace)this) ? tool.getHandler().getHelpText() : tool.getHandler().getDisabledHelpText(), tool.getHandler().isEnabled((CmsWorkplace)this), tool.getHandler().getPosition(), DEFAULT_TARGET);
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
    }
}

