/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsProject;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsEncoder;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleVersion;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.report.CmsShellReport;
import org.opencms.report.I_CmsReport;
import org.opencms.setup.CmsSetupBean;
import org.opencms.setup.CmsUpdateThread;
import org.opencms.setup.Messages;
import org.opencms.setup.update6to7.CmsUpdateDBThread;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.threads.CmsXmlContentRepairSettings;
import org.opencms.workplace.threads.CmsXmlContentRepairThread;
import org.opencms.xml.CmsXmlException;

public class CmsUpdateBean
extends CmsSetupBean {
    public static final String FOLDER_UPDATE = "update" + File.separatorChar;
    private static final String C_ADMIN_GROUP = "@ADMIN_GROUP@";
    private static final String C_ADMIN_PWD = "@ADMIN_PWD@";
    private static final String C_ADMIN_USER = "@ADMIN_USER@";
    private static final String C_UPDATE_PROJECT = "@UPDATE_PROJECT@";
    private static final String C_UPDATE_SITE = "@UPDATE_SITE@";
    private static final Log LOG = CmsLog.getLog((Object)CmsUpdateBean.class);
    private static final boolean UPDATE_ALL_MODULES = false;
    protected int m_newLoggingDBOffset;
    protected int m_oldLoggingDBOffset;
    private String m_adminGroup = "_tmpUpdateGroup" + System.currentTimeMillis() % 1000L;
    private String m_adminPwd = "admin";
    private String m_adminUser = "Admin";
    private CmsUpdateDBThread m_dbUpdateThread;
    private boolean m_keepHistory;
    private List m_modulesToUpdate;
    private boolean m_needDbUpdate = false;
    private String m_updateProject = "_tmpUpdateProject" + System.currentTimeMillis() % 1000L;
    private String m_updateSite = "/sites/default/";
    private List m_uptodateModules;
    private CmsUpdateThread m_workplaceUpdateThread;

    public CmsUpdateBean() {
        this.m_modulesFolder = FOLDER_UPDATE + CmsSystemInfo.FOLDER_MODULES;
        this.m_logFile = CmsSystemInfo.FOLDER_WEBINF + CmsLog.FOLDER_LOGS + "update.log";
    }

    public String displayError(String pathPrefix) {
        if (pathPrefix == null) {
            pathPrefix = "";
        }
        StringBuffer html = new StringBuffer(512);
        html.append("<table border='0' cellpadding='5' cellspacing='0' style='width: 100%; height: 100%;'>");
        html.append("\t<tr>");
        html.append("\t\t<td style='vertical-align: middle; height: 100%;'>");
        html.append(this.getHtmlPart("C_BLOCK_START", "Error"));
        html.append("\t\t\t<table border='0' cellpadding='0' cellspacing='0' style='width: 100%;'>");
        html.append("\t\t\t\t<tr>");
        html.append("\t\t\t\t\t<td><img src='").append(pathPrefix).append("resources/error.png' border='0'></td>");
        html.append("\t\t\t\t\t<td>&nbsp;&nbsp;</td>");
        html.append("\t\t\t\t\t<td style='width: 100%;'>");
        html.append("\t\t\t\t\t\tThe Alkacon OpenCms update wizard has not been started correctly!<br>");
        html.append("\t\t\t\t\t\tPlease click <a href='").append(pathPrefix);
        html.append("index.jsp'>here</a> to restart the wizard.");
        html.append("\t\t\t\t\t</td>");
        html.append("\t\t\t\t</tr>");
        html.append("\t\t\t</table>");
        html.append(this.getHtmlPart("C_BLOCK_END"));
        html.append("\t\t</td>");
        html.append("\t</tr>");
        html.append("</table>");
        return html.toString();
    }

    public String getAdminPwd() {
        return this.m_adminPwd;
    }

    public String getAdminUser() {
        return this.m_adminUser;
    }

    public Map getInstalledModules() {
        String file = "opencms-modules.xml";
        String basePath = "/" + "opencms" + "/" + "modules" + "/" + "module" + "[?]/";
        HashMap<String, CmsModuleVersion> modules = new HashMap<String, CmsModuleVersion>();
        String name = "";
        int i = 1;
        while (name != null) {
            if (i > 1) {
                String ver = "0.1";
                try {
                    ver = this.getXmlHelper().getValue(file, CmsStringUtil.substitute((String)basePath, (String)"?", (String)("" + (i - 1))) + "version");
                }
                catch (CmsXmlException e) {
                    // empty catch block
                }
                modules.put(name, new CmsModuleVersion(ver));
            }
            try {
                name = this.getXmlHelper().getValue(file, CmsStringUtil.substitute((String)basePath, (String)"?", (String)("" + i)) + "name");
            }
            catch (CmsXmlException e) {
                // empty catch block
            }
            ++i;
        }
        return modules;
    }

    public List getModulesToUpdate() {
        if (this.m_modulesToUpdate == null) {
            this.getUptodateModules();
        }
        return this.m_modulesToUpdate;
    }

    public CmsUpdateDBThread getUpdateDBThread() {
        return this.m_dbUpdateThread;
    }

    public String getUpdateProject() {
        return this.m_updateProject;
    }

    public String getUpdateSite() {
        return this.m_updateSite;
    }

    public List getUptodateModules() {
        if (this.m_uptodateModules == null) {
            this.m_uptodateModules = new ArrayList();
            this.m_modulesToUpdate = new ArrayList();
            Map installedModules = this.getInstalledModules();
            Map availableModules = this.getAvailableModules();
            Iterator itMods = availableModules.entrySet().iterator();
            while (itMods.hasNext()) {
                boolean uptodate;
                Map.Entry entry = itMods.next();
                String name = (String)entry.getKey();
                CmsModuleVersion instVer = (CmsModuleVersion)installedModules.get(name);
                CmsModuleVersion availVer = ((CmsModule)entry.getValue()).getVersion();
                boolean bl = uptodate = instVer != null && instVer.compareTo((Object)availVer) >= 0;
                if (uptodate) {
                    this.m_uptodateModules.add(name);
                } else {
                    this.m_modulesToUpdate.add(name);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(name + " --- installed: " + instVer + " available: " + availVer + " --- uptodate: " + uptodate));
            }
        }
        return this.m_uptodateModules;
    }

    public CmsUpdateThread getWorkplaceUpdateThread() {
        return this.m_workplaceUpdateThread;
    }

    public String htmlModules() {
        StringBuffer html = new StringBuffer(1024);
        HashSet uptodate = new HashSet(this.getUptodateModules());
        Iterator itModules = this.sortModules(this.getAvailableModules().values()).iterator();
        boolean hasModules = false;
        int i = 0;
        while (itModules.hasNext()) {
            String moduleName = (String)itModules.next();
            CmsModule module = (CmsModule)this.getAvailableModules().get(moduleName);
            if (!uptodate.contains(moduleName)) {
                html.append(this.htmlModule(module, i));
                hasModules = true;
            } else {
                html.append("<input type='hidden' name='availableModules' value='");
                html.append(moduleName);
                html.append("'>\n");
            }
            ++i;
        }
        if (!hasModules) {
            html.append("\t<tr>\n");
            html.append("\t\t<td style='vertical-align: middle;'>\n");
            html.append(Messages.get().getBundle().key("GUI_WARNING_ALL_MODULES_UPTODATE_0"));
            html.append("\t\t</td>\n");
            html.append("\t</tr>\n");
        }
        return html.toString();
    }

    public void init(String webAppRfsPath, String servletMapping, String defaultWebApplication) {
        try {
            super.init(webAppRfsPath, servletMapping, defaultWebApplication);
            if (this.m_workplaceUpdateThread != null) {
                if (this.m_workplaceUpdateThread.isAlive()) {
                    this.m_workplaceUpdateThread.kill();
                }
                this.m_workplaceUpdateThread = null;
            }
            if (this.m_dbUpdateThread != null) {
                if (this.m_dbUpdateThread.isAlive()) {
                    this.m_dbUpdateThread.kill();
                }
                this.m_dbUpdateThread = null;
                this.m_newLoggingOffset = 0;
                this.m_oldLoggingOffset = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public boolean isKeepHistory() {
        return this.m_keepHistory;
    }

    public boolean isNeedDbUpdate() {
        return this.m_needDbUpdate;
    }

    public void prepareUpdateStep1() {
    }

    public void prepareUpdateStep1b() {
        if (!this.isInitialized()) {
            return;
        }
        if (this.m_dbUpdateThread != null && this.m_dbUpdateThread.isFinished()) {
            return;
        }
        if (this.m_dbUpdateThread == null) {
            this.m_dbUpdateThread = new CmsUpdateDBThread(this);
        }
        if (!this.m_dbUpdateThread.isAlive()) {
            this.m_dbUpdateThread.start();
        }
    }

    public void prepareUpdateStep1bOutput(JspWriter out) throws IOException {
        this.m_oldLoggingDBOffset = this.m_newLoggingDBOffset;
        this.m_newLoggingDBOffset = this.m_dbUpdateThread.getLoggingThread().getMessages().size();
        if (this.isInitialized()) {
            for (int i = this.m_oldLoggingDBOffset; i < this.m_newLoggingDBOffset; ++i) {
                String str = this.m_dbUpdateThread.getLoggingThread().getMessages().get(i).toString();
                str = CmsEncoder.escapeWBlanks((String)str, (String)"UTF-8");
                out.println("output[" + (i - this.m_oldLoggingDBOffset) + "] = \"" + str + "\";");
            }
        } else {
            out.println("output[0] = 'ERROR';");
        }
        boolean threadFinished = this.m_dbUpdateThread.isFinished();
        boolean allWritten = this.m_oldLoggingDBOffset >= this.m_dbUpdateThread.getLoggingThread().getMessages().size();
        out.println("function initThread() {");
        if (this.isInitialized()) {
            out.print("send();");
            if (threadFinished && allWritten) {
                out.println("setTimeout('top.display.finish()', 1000);");
            } else {
                int timeout = 5000;
                if (this.getUpdateDBThread().getLoggingThread().getMessages().size() < 20) {
                    timeout = 2000;
                }
                out.println("setTimeout('location.reload()', " + timeout + ");");
            }
        }
        out.println("}");
    }

    public void prepareUpdateStep5() {
        if (this.isInitialized()) {
            try {
                String fileName = this.getWebAppRfsPath() + FOLDER_UPDATE + "cmsupdate";
                FileInputStream fis = new FileInputStream(fileName + ".ori");
                String script = "";
                int readChar = fis.read();
                while (readChar > -1) {
                    script = script + (char)readChar;
                    readChar = fis.read();
                }
                fis.close();
                script = CmsStringUtil.substitute((String)script, (String)C_ADMIN_USER, (String)this.getAdminUser());
                script = CmsStringUtil.substitute((String)script, (String)C_ADMIN_PWD, (String)this.getAdminPwd());
                script = CmsStringUtil.substitute((String)script, (String)C_UPDATE_PROJECT, (String)this.getUpdateProject());
                script = CmsStringUtil.substitute((String)script, (String)C_UPDATE_SITE, (String)this.getUpdateSite());
                script = CmsStringUtil.substitute((String)script, (String)C_ADMIN_GROUP, (String)this.getAdminGroup());
                FileOutputStream fos = new FileOutputStream(fileName + ".txt");
                fos.write(script.getBytes());
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public void prepareUpdateStep5b() {
        if (!this.isInitialized()) {
            return;
        }
        if (this.m_workplaceUpdateThread != null && this.m_workplaceUpdateThread.isFinished()) {
            return;
        }
        if (this.m_workplaceUpdateThread == null) {
            this.m_workplaceUpdateThread = new CmsUpdateThread(this);
        }
        if (!this.m_workplaceUpdateThread.isAlive()) {
            this.m_workplaceUpdateThread.start();
        }
    }

    public void prepareUpdateStep5bOutput(JspWriter out) throws IOException {
        if (this.m_workplaceUpdateThread == null || this.m_workplaceUpdateThread.getLoggingThread() == null) {
            return;
        }
        this.m_oldLoggingOffset = this.m_newLoggingOffset;
        this.m_newLoggingOffset = this.m_workplaceUpdateThread.getLoggingThread().getMessages().size();
        if (this.isInitialized()) {
            for (int i = this.m_oldLoggingOffset; i < this.m_newLoggingOffset; ++i) {
                String str = this.m_workplaceUpdateThread.getLoggingThread().getMessages().get(i).toString();
                str = CmsEncoder.escapeWBlanks((String)str, (String)"UTF-8");
                out.println("output[" + (i - this.m_oldLoggingOffset) + "] = \"" + str + "\";");
            }
        } else {
            out.println("output[0] = 'ERROR';");
        }
        boolean threadFinished = this.m_workplaceUpdateThread.isFinished();
        boolean allWritten = this.m_oldLoggingOffset >= this.m_workplaceUpdateThread.getLoggingThread().getMessages().size();
        out.println("function initThread() {");
        if (this.isInitialized()) {
            out.print("send();");
            if (threadFinished && allWritten) {
                out.println("setTimeout('top.display.finish()', 500);");
            } else {
                int timeout = 5000;
                if (this.getWorkplaceUpdateThread().getLoggingThread().getMessages().size() < 20) {
                    timeout = 1000;
                }
                out.println("setTimeout('location.reload()', " + timeout + ");");
            }
        }
        out.println("}");
    }

    public void prepareUpdateStep6() {
        if (this.isInitialized()) {
            this.lockWizard();
            this.saveProperties(this.getProperties(), "opencms.properties", false);
        }
    }

    public void setAdminPwd(String adminPwd) {
        this.m_adminPwd = adminPwd;
    }

    public void setAdminUser(String adminUser) {
        this.m_adminUser = adminUser;
    }

    public void setKeepHistory(boolean keepHistory) {
        this.m_keepHistory = keepHistory;
    }

    public void setNeedDbUpdate(boolean needDbUpdate) {
        this.m_needDbUpdate = needDbUpdate;
    }

    public void setUpdateProject(String updateProject) {
        this.m_updateProject = updateProject;
    }

    public void setUpdateSite(String site) {
        this.m_updateSite = site;
    }

    public void shellExit() {
        System.out.println();
        System.out.println();
        System.out.println("The update is finished!\nThe OpenCms system used for the update will now shut down.");
    }

    public void shellStart() {
        System.out.println();
        System.out.println("Starting Workplace update for OpenCms!");
        String[] copy = org.opencms.main.Messages.COPYRIGHT_BY_ALKACON;
        for (int i = copy.length - 1; i >= 0; --i) {
            System.out.println(copy[i]);
        }
        System.out.println("This is OpenCms " + OpenCms.getSystemInfo().getVersionNumber());
        System.out.println();
        System.out.println();
    }

    public void updateModulesFromUpdateBean() throws Exception {
        if (this.m_cms != null && this.m_installModules != null) {
            CmsShellReport report = new CmsShellReport(this.m_cms.getRequestContext().getLocale());
            HashSet utdModules = new HashSet(this.getUptodateModules());
            for (int i = 0; i < this.m_installModules.size(); ++i) {
                String name = (String)this.m_installModules.get(i);
                if (!utdModules.contains(name)) {
                    String filename = (String)this.m_moduleFilenames.get(name);
                    try {
                        this.updateModule(name, filename, (I_CmsReport)report);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    continue;
                }
                report.println(Messages.get().container("RPT_MODULE_UPTODATE_1", (Object)name), 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public void updateRelations() throws Exception {
        if (!this.m_needDbUpdate) {
            return;
        }
        report = new CmsShellReport(this.m_cms.getRequestContext().getLocale());
        report.println(Messages.get().container("RPT_START_UPDATE_RELATIONS_0"), 2);
        storedSite = this.m_cms.getRequestContext().getSiteRoot();
        project = null;
        try {
            projectName = "Update relations project";
            try {
                project = this.m_cms.readProject(projectName);
            }
            catch (CmsException e) {
                project = this.m_cms.createProject(projectName, projectName, OpenCms.getDefaultUsers().getGroupAdministrators(), OpenCms.getDefaultUsers().getGroupAdministrators(), CmsProject.PROJECT_TYPE_TEMPORARY);
            }
            this.m_cms.getRequestContext().setSiteRoot("");
            this.m_cms.getRequestContext().setCurrentProject(project);
            types = OpenCms.getResourceManager().getResourceTypes();
            n = types.size();
            m = 0;
            itTypes = types.iterator();
            while (itTypes.hasNext()) {
                type = (I_CmsResourceType)itTypes.next();
                report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", (Object)String.valueOf(++m), (Object)String.valueOf(n)), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)type.getTypeName()));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                if (type instanceof I_CmsLinkParseable) {
                    try {
                        settings = new CmsXmlContentRepairSettings(this.m_cms);
                        settings.setIncludeSubFolders(true);
                        settings.setVfsFolder("/");
                        settings.setForce(true);
                        settings.setResourceType(type.getTypeName());
                        t = new CmsXmlContentRepairThread(this.m_cms, settings);
                        t.start();
                        var12_14 = this;
                        synchronized (var12_14) {
                            t.join();
                        }
                        report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    }
                    catch (Exception e) {
                        report.println(org.opencms.report.Messages.get().container("RPT_ERROR_0"), 5);
                        report.addError((Object)e);
                        e.printStackTrace(System.err);
                    }
                    continue;
                }
                report.println(org.opencms.report.Messages.get().container("RPT_SKIPPED_0"), 1);
            }
            var15_16 = null;
        }
        catch (Throwable var14_26) {
            block20: {
                var15_17 = null;
                try {
                    if (project == null) break block20;
                    try {
                        this.m_cms.unlockProject(project.getUuid());
                        OpenCms.getPublishManager().publishProject(this.m_cms, (I_CmsReport)report, OpenCms.getPublishManager().getPublishList(this.m_cms));
                        OpenCms.getPublishManager().waitWhileRunning();
                        var17_20 = null;
                    }
                    catch (Throwable var16_23) {
                        var17_21 = null;
                        this.m_cms.getRequestContext().setCurrentProject(this.m_cms.readProject(CmsProject.ONLINE_PROJECT_ID));
                        throw var16_23;
                    }
                    this.m_cms.getRequestContext().setCurrentProject(this.m_cms.readProject(CmsProject.ONLINE_PROJECT_ID));
                    {
                    }
                }
                finally {
                    this.m_cms.getRequestContext().setSiteRoot(storedSite);
                }
            }
            report.println(Messages.get().container("RPT_FINISH_UPDATE_RELATIONS_0"), 2);
            throw var14_26;
        }
        try {
            if (project == null) ** GOTO lbl100
            try {
                this.m_cms.unlockProject(project.getUuid());
                OpenCms.getPublishManager().publishProject(this.m_cms, (I_CmsReport)report, OpenCms.getPublishManager().getPublishList(this.m_cms));
                OpenCms.getPublishManager().waitWhileRunning();
                var17_18 = null;
            }
            catch (Throwable var16_22) {
                var17_19 = null;
                this.m_cms.getRequestContext().setCurrentProject(this.m_cms.readProject(CmsProject.ONLINE_PROJECT_ID));
                throw var16_22;
            }
            this.m_cms.getRequestContext().setCurrentProject(this.m_cms.readProject(CmsProject.ONLINE_PROJECT_ID));
            {
            }
        }
        finally {
            this.m_cms.getRequestContext().setSiteRoot(storedSite);
        }
lbl100:
        // 2 sources

        report.println(Messages.get().container("RPT_FINISH_UPDATE_RELATIONS_0"), 2);
    }

    protected String getAdminGroup() {
        return this.m_adminGroup;
    }

    protected void setAdminGroup(String adminGroup) {
        this.m_adminGroup = adminGroup;
    }

    protected void updateModule(String moduleName, String importFile, I_CmsReport report) throws Exception {
        String fileName = this.getModuleFolder() + importFile;
        report.println(Messages.get().container("RPT_BEGIN_UPDATE_MODULE_1", (Object)moduleName), 2);
        if (OpenCms.getModuleManager().getModule(moduleName) != null) {
            OpenCms.getModuleManager().deleteModule(this.m_cms, moduleName, true, report);
        }
        OpenCms.getPublishManager().waitWhileRunning();
        OpenCms.getImportExportManager().importData(this.m_cms, report, new CmsImportParameters(fileName, "/", true));
        report.println(Messages.get().container("RPT_END_UPDATE_MODULE_1", (Object)moduleName), 2);
    }
}

