/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsShell;
import org.opencms.main.I_CmsShellCommands;
import org.opencms.setup.CmsSetupLoggingThread;
import org.opencms.setup.CmsUpdateBean;
import org.opencms.setup.Messages;

public class CmsUpdateThread
extends Thread {
    public PrintStream m_tempErr;
    private CmsSetupLoggingThread m_loggingThread;
    private PipedOutputStream m_pipedOut;
    private CmsShell m_shell;
    private PrintStream m_tempOut;
    private CmsUpdateBean m_updateBean;

    public CmsUpdateThread(CmsUpdateBean updateBean) {
        super("OpenCms: Workplace update");
        this.m_updateBean = updateBean;
        this.m_pipedOut = new PipedOutputStream();
        this.m_loggingThread = new CmsSetupLoggingThread(this.m_pipedOut, this.m_updateBean.getLogName());
    }

    public CmsSetupLoggingThread getLoggingThread() {
        return this.m_loggingThread;
    }

    public boolean isFinished() {
        return this.m_loggingThread.isFinished();
    }

    public void kill() {
        if (this.m_shell != null) {
            this.m_shell.exit();
        }
        if (this.m_loggingThread != null) {
            this.m_loggingThread.stopThread();
        }
        this.m_shell = null;
        this.m_updateBean = null;
    }

    public void printToStdOut(String str) {
        this.m_tempOut.println(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_tempOut = System.out;
        this.m_tempErr = System.err;
        try {
            System.setOut(new PrintStream(this.m_pipedOut));
            System.setErr(new PrintStream(this.m_pipedOut));
            this.m_loggingThread.start();
            this.m_shell = new CmsShell(this.m_updateBean.getWebAppRfsPath() + "WEB-INF" + File.separator, this.m_updateBean.getServletMapping(), this.m_updateBean.getDefaultWebApplication(), "${user}@${project}>", (I_CmsShellCommands)this.m_updateBean);
            try {
                try {
                    if (CmsLog.INIT.isInfoEnabled()) {
                        CmsLog.INIT.info((Object)org.opencms.main.Messages.get().getBundle().key("INIT_DOT_0"));
                        CmsLog.INIT.info((Object)org.opencms.main.Messages.get().getBundle().key("INIT_DOT_0"));
                        CmsLog.INIT.info((Object)org.opencms.main.Messages.get().getBundle().key("INIT_DOT_0"));
                        CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WELCOME_UPDATE_0"));
                        CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_UPDATE_WORKPLACE_START_0"));
                        CmsLog.INIT.info((Object)org.opencms.main.Messages.get().getBundle().key("INIT_DOT_0"));
                        CmsLog.INIT.info((Object)org.opencms.main.Messages.get().getBundle().key("INIT_DOT_0"));
                        for (int i = 0; i < org.opencms.main.Messages.COPYRIGHT_BY_ALKACON.length; ++i) {
                            CmsLog.INIT.info((Object)(". " + org.opencms.main.Messages.COPYRIGHT_BY_ALKACON[i]));
                        }
                        CmsLog.INIT.info((Object)org.opencms.main.Messages.get().getBundle().key("INIT_DOT_0"));
                        CmsLog.INIT.info((Object)org.opencms.main.Messages.get().getBundle().key("INIT_DOT_0"));
                        CmsLog.INIT.info((Object)org.opencms.main.Messages.get().getBundle().key("INIT_LINE_0"));
                    }
                    this.m_shell.start(new FileInputStream(new File(this.m_updateBean.getWebAppRfsPath() + CmsUpdateBean.FOLDER_UPDATE + "cmsupdate.txt")));
                    if (CmsLog.INIT.isInfoEnabled()) {
                        CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_UPDATE_WORKPLACE_FINISHED_0"));
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                this.kill();
                this.m_pipedOut.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            System.setOut(this.m_tempOut);
            System.setErr(this.m_tempErr);
        }
    }
}

