/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.comptest;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Random;
import org.opencms.setup.CmsSetupBean;
import org.opencms.setup.comptest.CmsSetupTestResult;
import org.opencms.setup.comptest.I_CmsSetupTest;

public class CmsSetupTestFolderPermissions
implements I_CmsSetupTest {
    public static final String TEST_NAME = "Folder Permissions";

    public String getName() {
        return TEST_NAME;
    }

    public CmsSetupTestResult execute(CmsSetupBean setupBean) {
        File file1;
        CmsSetupTestResult testResult = new CmsSetupTestResult(this);
        String basePath = setupBean.getWebAppRfsPath();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        Random rnd = new Random();
        while ((file1 = new File(basePath + "test" + rnd.nextInt(1000))).exists()) {
        }
        boolean success = false;
        try {
            file1.createNewFile();
            FileWriter fw = new FileWriter(file1);
            fw.write("aA1");
            fw.close();
            success = true;
            FileReader fr = new FileReader(file1);
            success = success && fr.read() == 97;
            success = success && fr.read() == 65;
            success = success && fr.read() == 49;
            success = success && fr.read() == -1;
            fr.close();
            success = file1.delete();
            success = !file1.exists();
        }
        catch (Exception e) {
            success = false;
        }
        if (!success) {
            testResult.setRed();
            testResult.setInfo("OpenCms cannot be installed without read and write privileges for path " + basePath + "! Please check you are running your servlet container with the right user and privileges.");
            testResult.setHelp("Not enough permissions to create/read/write a file");
            testResult.setResult("failed!");
        } else {
            testResult.setGreen();
            testResult.setResult("passed");
        }
        return testResult;
    }
}

