/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.comptest;

import org.opencms.setup.CmsSetupBean;
import org.opencms.setup.comptest.CmsSetupTestResult;
import org.opencms.setup.comptest.I_CmsSetupTest;

public class CmsSetupTestJdkVersion
implements I_CmsSetupTest {
    public static final String TEST_NAME = "JDK Version";

    public String getName() {
        return TEST_NAME;
    }

    public CmsSetupTestResult execute(CmsSetupBean setupBean) {
        CmsSetupTestResult testResult = new CmsSetupTestResult(this);
        String requiredJDK = "1.4.0";
        String JDKVersion = System.getProperty("java.version");
        testResult.setResult(JDKVersion);
        boolean supportedJDK = this.compareJDKVersions(JDKVersion, requiredJDK);
        if (!supportedJDK) {
            testResult.setRed();
            testResult.setHelp("OpenCms requires at least Java version " + requiredJDK + " to run. Please update your JDK");
        } else {
            testResult.setGreen();
        }
        return testResult;
    }

    private boolean compareJDKVersions(String usedJDK, String requiredJDK) {
        int compare = usedJDK.compareTo(requiredJDK);
        return compare >= 0;
    }
}

