/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.comptest;

import java.io.File;
import org.opencms.main.CmsSystemInfo;
import org.opencms.setup.CmsSetupBean;
import org.opencms.setup.comptest.CmsSetupTestResult;
import org.opencms.setup.comptest.I_CmsSetupTest;

public class CmsSetupTestWarFileUnpacked
implements I_CmsSetupTest {
    public static final String TEST_NAME = "Unpacked WAR File";

    public String getName() {
        return TEST_NAME;
    }

    public CmsSetupTestResult execute(CmsSetupBean setupBean) {
        File file;
        CmsSetupTestResult testResult = new CmsSetupTestResult(this);
        String basePath = setupBean.getWebAppRfsPath();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        if ((file = new File(basePath + CmsSystemInfo.FOLDER_WEBINF + CmsSystemInfo.FOLDER_CONFIG + "opencms.properties")).exists() && file.canRead() && file.canWrite()) {
            testResult.setGreen();
            testResult.setResult("passed");
        } else {
            testResult.setRed();
            testResult.setInfo("OpenCms cannot be installed unless the OpenCms WAR file is unpacked! Please check the settings of your servlet container or unpack the WAR file manually.");
            testResult.setHelp("WAR file NOT unpacked");
            testResult.setResult("failed!");
        }
        return testResult;
    }
}

