/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.comptest;

import java.io.ByteArrayInputStream;
import org.apache.xerces.impl.Version;
import org.apache.xerces.parsers.DOMParser;
import org.opencms.setup.CmsSetupBean;
import org.opencms.setup.comptest.CmsSetupTestResult;
import org.opencms.setup.comptest.I_CmsSetupTest;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class CmsSetupTestXercesVersion
implements I_CmsSetupTest {
    public static final String TEST_NAME = "XML Parser";

    public String getName() {
        return TEST_NAME;
    }

    public CmsSetupTestResult execute(CmsSetupBean setupBean) throws Exception {
        CmsSetupTestResult testResult = new CmsSetupTestResult(this);
        DOMParser parser = new DOMParser();
        String document = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<test>test</test>\n";
        parser.parse(new InputSource(new ByteArrayInputStream(document.getBytes("UTF-8"))));
        Document doc = parser.getDocument();
        String versionStr = null;
        int xercesVersion = 0;
        try {
            doc.getClass().getMethod("getXmlEncoding", new Class[0]).invoke((Object)doc, new Object[0]);
            versionStr = Version.getVersion();
            xercesVersion = 2;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (versionStr == null) {
            try {
                doc.getClass().getMethod("getEncoding", new Class[0]).invoke((Object)doc, new Object[0]);
                versionStr = "Xerces version 1";
                xercesVersion = 1;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        switch (xercesVersion) {
            case 2: {
                testResult.setResult(versionStr);
                testResult.setHelp("OpenCms 6.0 requires Xerces version 2 to run. Usually this should be available as part of the servlet environment.");
                testResult.setGreen();
                break;
            }
            case 1: {
                testResult.setResult(versionStr);
                testResult.setRed();
                testResult.setInfo("OpenCms 6.0 requires Xerces version 2 to run, your Xerces version is 1. Usually Xerces 2 should be installed by default as part of the servlet environment.");
                testResult.setHelp(testResult.getInfo());
                break;
            }
            default: {
                if (versionStr == null) {
                    versionStr = "Unknown version";
                }
                testResult.setResult(versionStr);
                testResult.setRed();
                testResult.setInfo("OpenCms 6.0 requires Xerces version 2 to run. Usually Xerces 2 should be installed by default as part of the servlet environment.");
                testResult.setHelp(testResult.getInfo());
            }
        }
        return testResult;
    }
}

