/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.generic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.A_CmsUpdateDBPart;

public class CmsUpdateDBAlterTables
extends A_CmsUpdateDBPart {
    protected static final String[] CMS_OFFLINE_CONTENTS_QUERIES = new String[]{"Q_OFFLINE_CONTENTS_DROP_COLUMN"};
    protected static final List CMS_OFFLINE_CONTENTS_QUERIES_LIST = Collections.unmodifiableList(Arrays.asList(CMS_OFFLINE_CONTENTS_QUERIES));
    protected static final String[] CMS_PROPERTYDEF = new String[]{"CMS_OFFLINE_PROPERTYDEF", "CMS_ONLINE_PROPERTYDEF"};
    protected static final List CMS_PROPERTYDEF_LIST = Collections.unmodifiableList(Arrays.asList(CMS_PROPERTYDEF));
    protected static final String[] CMS_RESOURCES = new String[]{"CMS_OFFLINE_RESOURCES", "CMS_ONLINE_RESOURCES"};
    protected static final List CMS_RESOURCES_LIST = Collections.unmodifiableList(Arrays.asList(CMS_RESOURCES));
    protected static final String[] CMS_STRUCTURE = new String[]{"CMS_OFFLINE_STRUCTURE", "CMS_ONLINE_STRUCTURE"};
    protected static final List CMS_STRUCTURE_LIST = Collections.unmodifiableList(Arrays.asList(CMS_STRUCTURE));
    protected static final String COLUMN_CMS_OFFLINE_CONTENTS_CONTENT_ID = "CONTENT_ID";
    protected static final String COLUMN_CMS_PROPERTYDEF_TYPE = "PROPERTYDEF_TYPE";
    protected static final String COLUMN_CMS_STRUCTURE_STRUCTURE_VERSION = "STRUCTURE_VERSION";
    protected static final String COLUMN_PROJECTS_PROJECT_NAME = "PROJECT_NAME";
    protected static final String COLUMN_PROJECTS_TASK_ID = "TASK_ID";
    protected static final String COLUMN_RESOURCES_DATE_CONTENT = "DATE_CONTENT";
    protected static final String COLUMN_RESOURCES_RESOURCE_VERSION = "RESOURCE_VERSION";
    protected static final String REPLACEMENT_TABLENAME = "${tablename}";
    protected static final String TABLE_CMS_OFFLINE_CONTENTS = "CMS_OFFLINE_CONTENTS";
    protected static final String TABLE_CMS_PROJECTS = "CMS_PROJECTS";
    private static final String QUERY_CMS_PROJECTS_CHANGE_PROJECT_NAME = "Q_CMS_PROJECTS_CHANGE_PROJECT_NAME_SIZE";
    private static final String QUERY_CMS_PROJECTS_DROP_TASK_ID = "Q_CMS_PROJECTS_DROP_TASK_ID";
    private static final String QUERY_CMS_PROJECTS_UPDATE_PROJECT_FLAGS = "Q_CMS_PROJECTS_UPDATE_PROJECT_FLAGS";
    private static final String QUERY_CMS_STRUCTURE_ADD_STRUCTURE_VERSION = "Q_CMS_STRUCTURE_ADD_STRUCTURE_VERSION";
    private static final String QUERY_PROPERTY_FILE = "generic/cms_alter_remaining_queries.properties";
    private static final String QUERY_PROPERTYDEF_TYPE = "Q_CMS_PROPERTYDEF";
    private static final String QUERY_SELECT_CMS_STRUCTURE_VERSION = "Q_SELECT_CMS_STRUCTURE_VERSION";
    private static final String QUERY_UPDATE_RESOURCES_DATE_CONTENT = "Q_UPDATE_RESOURCES_DATE_CONTENT";
    private static final String QUERY_UPDATE_RESOURCES_RESOURCE_VERSION = "Q_UPDATE_RESOURCES_RESOURCE_VERSION";
    private static final String QUERY_UPDATE_STRUCTURE_VERSION = "Q_UPDATE_STRUCTURE_VERSION";

    public CmsUpdateDBAlterTables() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/generic/cms_alter_remaining_queries.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalExecute(CmsSetupDb dbCon) throws SQLException {
        HashMap<String, String> replacer;
        String table;
        Iterator it;
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (dbCon.hasTableOrColumn(TABLE_CMS_OFFLINE_CONTENTS, COLUMN_CMS_OFFLINE_CONTENTS_CONTENT_ID)) {
            it = CMS_OFFLINE_CONTENTS_QUERIES_LIST.iterator();
            while (it.hasNext()) {
                String query = this.readQuery((String)it.next());
                dbCon.updateSqlStatement(query, null, null);
            }
        } else {
            System.out.println("no column CONTENT_ID in table CMS_OFFLINE_CONTENTS");
        }
        it = CMS_PROPERTYDEF_LIST.iterator();
        while (it.hasNext()) {
            table = (String)it.next();
            if (!dbCon.hasTableOrColumn(table, COLUMN_CMS_PROPERTYDEF_TYPE)) {
                String query = this.readQuery(QUERY_PROPERTYDEF_TYPE);
                replacer = new HashMap<String, String>();
                replacer.put(REPLACEMENT_TABLENAME, table);
                dbCon.updateSqlStatement(query, replacer, null);
                replacer.clear();
                continue;
            }
            System.out.println("column PROPERTYDEF_TYPE in table " + table + " already exists");
        }
        it = CMS_STRUCTURE_LIST.iterator();
        while (it.hasNext()) {
            table = (String)it.next();
            if (!dbCon.hasTableOrColumn(table, COLUMN_CMS_STRUCTURE_STRUCTURE_VERSION)) {
                String addColumn = this.readQuery(QUERY_CMS_STRUCTURE_ADD_STRUCTURE_VERSION);
                replacer = new HashMap();
                replacer.put(REPLACEMENT_TABLENAME, table);
                dbCon.updateSqlStatement(addColumn, replacer, null);
                String structureVersion = this.readQuery(QUERY_SELECT_CMS_STRUCTURE_VERSION);
                CmsSetupDBWrapper db = null;
                try {
                    db = dbCon.executeSqlStatement(structureVersion, replacer);
                    while (db.getResultSet().next()) {
                        String updateQuery = this.readQuery(QUERY_UPDATE_STRUCTURE_VERSION);
                        String structureId = db.getResultSet().getString("STRUCTURE_ID");
                        int version = db.getResultSet().getInt(COLUMN_CMS_STRUCTURE_STRUCTURE_VERSION);
                        ArrayList<Object> params = new ArrayList<Object>();
                        params.add(new Integer(version));
                        params.add(structureId);
                        dbCon.updateSqlStatement(updateQuery, replacer, params);
                    }
                    continue;
                }
                finally {
                    if (db != null) {
                        db.close();
                    }
                    continue;
                }
            }
            System.out.println("column STRUCTURE_VERSION in table " + table + " already exists");
        }
        if (dbCon.hasTableOrColumn(TABLE_CMS_PROJECTS, COLUMN_PROJECTS_TASK_ID)) {
            String dropTaskId = this.readQuery(QUERY_CMS_PROJECTS_DROP_TASK_ID);
            dbCon.updateSqlStatement(dropTaskId, null, null);
        } else {
            System.out.println("no column TASK_ID in table CMS_PROJECTS");
        }
        if (dbCon.hasTableOrColumn(TABLE_CMS_PROJECTS, COLUMN_PROJECTS_PROJECT_NAME)) {
            String changeProjectName = this.readQuery(QUERY_CMS_PROJECTS_CHANGE_PROJECT_NAME);
            dbCon.updateSqlStatement(changeProjectName, null, null);
        } else {
            System.out.println("no column PROJECT_NAME in table CMS_PROJECTS");
        }
        if (dbCon.hasTableOrColumn(TABLE_CMS_PROJECTS, null)) {
            String updateProjectFlags = this.readQuery(QUERY_CMS_PROJECTS_UPDATE_PROJECT_FLAGS);
            dbCon.updateSqlStatement(updateProjectFlags, null, null);
        } else {
            System.out.println("table CMS_PROJECTS does not exists");
        }
        it = CMS_RESOURCES_LIST.iterator();
        while (it.hasNext()) {
            table = (String)it.next();
            HashMap<String, String> replacer2 = new HashMap<String, String>();
            replacer2.put(REPLACEMENT_TABLENAME, table);
            if (!dbCon.hasTableOrColumn(table, COLUMN_RESOURCES_DATE_CONTENT)) {
                String addDateContent = this.readQuery(QUERY_UPDATE_RESOURCES_DATE_CONTENT);
                dbCon.updateSqlStatement(addDateContent, replacer2, null);
            } else {
                System.out.println("column DATE_CONTENT in table " + table + " already exists");
            }
            if (!dbCon.hasTableOrColumn(table, COLUMN_RESOURCES_RESOURCE_VERSION)) {
                String addResourceVersion = this.readQuery(QUERY_UPDATE_RESOURCES_RESOURCE_VERSION);
                dbCon.updateSqlStatement(addResourceVersion, replacer2, null);
                continue;
            }
            System.out.println("column RESOURCE_VERSION in table " + table + " already exists");
        }
    }
}

