/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.generic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.A_CmsUpdateDBPart;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsUpdateDBCmsUsers
extends A_CmsUpdateDBPart {
    protected static final String QUERY_CREATE_TABLE_USERDATA = "Q_CREATE_TABLE_USERDATA";
    protected static final String QUERY_INSERT_CMS_USERDATA = "Q_INSERT_CMS_USERDATA";
    private static final String CHECK_CMS_USERDATA = "CMS_USERDATA";
    private static final String CMS_USERS_TABLE = "CMS_USERS";
    private static final String QUERY_ADD_USER_DATECREATED_COLUMN = "Q_ADD_USER_DATECREATED";
    private static final String QUERY_ADD_WEBUSERS_TO_GROUP = "Q_ADD_WEBUSERS_TO_GROUP";
    private static final String QUERY_CREATE_WEBUSERS_GROUP = "Q_CREATE_WEBUSERS_GROUP";
    private static final String QUERY_DROP_USER_ADDRESS_COLUMN = "Q_DROP_USER_ADDRESS_COLUMN";
    private static final String QUERY_DROP_USER_DESCRIPTION_COLUMN = "Q_DROP_USER_DESCRIPTION_COLUMN";
    private static final String QUERY_DROP_USER_INFO_COLUMN = "Q_DROP_USER_INFO_COLUMN";
    private static final String QUERY_DROP_USER_TYPE_COLUMN = "Q_DROP_USER_TYPE_COLUMN";
    private static final String QUERY_PROPERTY_FILE = "generic/cms_users_queries.properties";
    private static final String QUERY_SELECT_USER_DATA = "Q_SELECT_USER_DATA";
    private static final String QUERY_SET_USER_DATECREATED = "Q_SET_USER_DATECREATED";
    private static final String RESULTSET_USER_ID = "USER_ID";
    private static final String RESULTSET_USER_INFO = "USER_INFO";
    private static final String USER_ADDRESS = "USER_ADDRESS";
    private static final String USER_DATECREATED = "USER_DATECREATED";
    private static final String USER_DESCRIPTION = "USER_DESCRIPTION";
    private static final String USER_INFO = "USER_INFO";
    private static final String USER_TYPE = "USER_TYPE";

    public CmsUpdateDBCmsUsers() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/generic/cms_users_queries.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalExecute(CmsSetupDb dbCon) {
        block18: {
            System.out.println(new Exception().getStackTrace()[0].toString());
            try {
                if (dbCon.hasTableOrColumn(CMS_USERS_TABLE, USER_TYPE)) {
                    CmsUUID id = this.createWebusersGroup(dbCon);
                    this.addWebusersToGroup(dbCon, id);
                } else {
                    System.out.println("table CMS_USERDATA already exists");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (!this.checkUserDataTable(dbCon)) {
                    this.createUserDataTable(dbCon);
                    String query = this.readQuery(QUERY_SELECT_USER_DATA);
                    CmsSetupDBWrapper db = null;
                    try {
                        db = dbCon.executeSqlStatement(query, null);
                        while (db.getResultSet().next()) {
                            String userID = (String)db.getResultSet().getObject(RESULTSET_USER_ID);
                            System.out.println("UserId: " + userID);
                            try {
                                String userDescription;
                                String userAddress;
                                Blob blob = db.getResultSet().getBlob("USER_INFO");
                                ByteArrayInputStream bin = new ByteArrayInputStream(blob.getBytes(1L, (int)blob.length()));
                                ObjectInputStream oin = new ObjectInputStream(bin);
                                HashMap<String, String> infos = (HashMap<String, String>)oin.readObject();
                                if (infos == null) {
                                    infos = new HashMap<String, String>();
                                }
                                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)(userAddress = (String)db.getResultSet().getObject(USER_ADDRESS)))) {
                                    infos.put(USER_ADDRESS, userAddress);
                                }
                                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)(userDescription = (String)db.getResultSet().getObject(USER_DESCRIPTION)))) {
                                    infos.put(USER_DESCRIPTION, userDescription);
                                }
                                this.writeAdditionalUserInfo(dbCon, userID, infos);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    finally {
                        if (db != null) {
                            db.close();
                        }
                    }
                    this.addUserDateCreated(dbCon);
                    this.removeUnnecessaryColumns(dbCon);
                    break block18;
                }
                System.out.println("table CMS_USERDATA already exists");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected void addUserDateCreated(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (!dbCon.hasTableOrColumn(CMS_USERS_TABLE, USER_DATECREATED)) {
            String addUserDateCreated = this.readQuery(QUERY_ADD_USER_DATECREATED_COLUMN);
            dbCon.updateSqlStatement(addUserDateCreated, null, null);
            String setUserDateCreated = this.readQuery(QUERY_SET_USER_DATECREATED);
            ArrayList<Long> param = new ArrayList<Long>();
            param.add(new Long(System.currentTimeMillis()));
            dbCon.updateSqlStatement(setUserDateCreated, null, param);
        } else {
            System.out.println("column USER_DATECREATED in table CMS_USERS already exists");
        }
    }

    protected void addWebusersToGroup(CmsSetupDb dbCon, CmsUUID id) throws SQLException {
        String sql = this.readQuery(QUERY_ADD_WEBUSERS_TO_GROUP);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("${GROUP_ID}", id.toString());
        dbCon.updateSqlStatement(sql, replacements, null);
    }

    protected boolean checkUserDataTable(CmsSetupDb dbCon) {
        System.out.println(new Exception().getStackTrace()[0].toString());
        return dbCon.hasTableOrColumn(CHECK_CMS_USERDATA, null);
    }

    protected void createUserDataTable(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        String createStatement = this.readQuery(QUERY_CREATE_TABLE_USERDATA);
        dbCon.updateSqlStatement(createStatement, null, null);
    }

    protected CmsUUID createWebusersGroup(CmsSetupDb dbCon) throws SQLException {
        String sql = this.readQuery(QUERY_CREATE_WEBUSERS_GROUP);
        ArrayList<Object> params = new ArrayList<Object>();
        CmsUUID id = new CmsUUID();
        params.add(id.toString());
        params.add(CmsUUID.getNullUUID().toString());
        params.add("allWebusersFromUpgrade6to7");
        params.add("This group was created by the OpenCms Upgrade Wizard to facilitate the handling of former called WebUsers, can be deleted if needed.");
        params.add(new Integer(0));
        params.add("/");
        dbCon.updateSqlStatement(sql, null, params);
        return id;
    }

    protected void removeUnnecessaryColumns(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        String dropUserInfo = this.readQuery(QUERY_DROP_USER_INFO_COLUMN);
        String dropUserAddress = this.readQuery(QUERY_DROP_USER_ADDRESS_COLUMN);
        String dropUserDescription = this.readQuery(QUERY_DROP_USER_DESCRIPTION_COLUMN);
        String dropUserType = this.readQuery(QUERY_DROP_USER_TYPE_COLUMN);
        if (dbCon.hasTableOrColumn(CMS_USERS_TABLE, "USER_INFO")) {
            dbCon.updateSqlStatement(dropUserInfo, null, null);
        } else {
            System.out.println("no column USER_INFO in table CMS_USERS found");
        }
        if (dbCon.hasTableOrColumn(CMS_USERS_TABLE, USER_ADDRESS)) {
            dbCon.updateSqlStatement(dropUserAddress, null, null);
        } else {
            System.out.println("no column USER_ADDRESS in table CMS_USERS found");
        }
        if (dbCon.hasTableOrColumn(CMS_USERS_TABLE, USER_DESCRIPTION)) {
            dbCon.updateSqlStatement(dropUserDescription, null, null);
        } else {
            System.out.println("no column USER_DESCRIPTION in table CMS_USERS found");
        }
        if (dbCon.hasTableOrColumn(CMS_USERS_TABLE, USER_TYPE)) {
            dbCon.updateSqlStatement(dropUserType, null, null);
        } else {
            System.out.println("no column USER_TYPE in table CMS_USERS found");
        }
    }

    protected void writeAdditionalUserInfo(CmsSetupDb dbCon, String id, Map additionalInfo) {
        Iterator entries = additionalInfo.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.writeUserInfo(dbCon, id, (String)entry.getKey(), entry.getValue());
        }
    }

    protected void writeUserInfo(CmsSetupDb dbCon, String id, String key, Object value) {
        String query = this.readQuery(QUERY_INSERT_CMS_USERDATA);
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(id);
            params.add(key);
            params.add(value);
            params.add(value.getClass().getName());
            dbCon.updateSqlStatement(query, null, params);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

