/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.generic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.A_CmsUpdateDBPart;

public class CmsUpdateDBDropBackupTables
extends A_CmsUpdateDBPart {
    protected static final String[] BACKUP_TABLES = new String[]{"CMS_BACKUP_PROJECTRESOURCES", "CMS_BACKUP_PROJECTS", "CMS_BACKUP_PROPERTIES", "CMS_BACKUP_PROPERTYDEF", "CMS_BACKUP_RESOURCES", "CMS_BACKUP_STRUCTURE"};
    protected static final List BACKUP_TABLES_LIST = Collections.unmodifiableList(Arrays.asList(BACKUP_TABLES));
    protected static final String REPLACEMENT_TABLENAME = "${tablename}";
    private static final String QUERY_DROP_TABLE = "Q_DROP_TABLE";
    private static final String QUERY_PROPERTY_FILE = "generic/cms_drop_backup_tables_queries.properties";

    public CmsUpdateDBDropBackupTables() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/generic/cms_drop_backup_tables_queries.properties");
    }

    protected void internalExecute(CmsSetupDb dbCon) {
        System.out.println(new Exception().getStackTrace()[0].toString());
        String dropQuery = this.readQuery(QUERY_DROP_TABLE);
        Iterator it = BACKUP_TABLES_LIST.iterator();
        while (it.hasNext()) {
            String table = (String)it.next();
            HashMap<String, String> replacer = new HashMap<String, String>();
            replacer.put(REPLACEMENT_TABLENAME, table);
            try {
                dbCon.updateSqlStatement(dropQuery, replacer, null);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

