/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.generic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.A_CmsUpdateDBPart;

public class CmsUpdateDBDropUnusedTables
extends A_CmsUpdateDBPart {
    private static final String QUERY_DROP_TABLE = "Q_DROP_TABLE";
    private static final String QUERY_PROPERTY_FILE = "generic/cms_drop_unused_tables_queries.properties";
    private static final String REPLACEMENT_TABLENAME = "${tablename}";
    private static final String[] UNUSED_TABLES = new String[]{"CMS_SYSTEMID", "CMS_TASK", "CMS_TASKLOG", "CMS_TASKPAR", "CMS_TASKTYPE", "TEMP_PROJECT_UUIDS"};
    private static final List UNUSED_TABLES_LIST = Collections.unmodifiableList(Arrays.asList(UNUSED_TABLES));

    public CmsUpdateDBDropUnusedTables() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/generic/cms_drop_unused_tables_queries.properties");
    }

    protected void internalExecute(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        Iterator it = UNUSED_TABLES_LIST.iterator();
        while (it.hasNext()) {
            String table = (String)it.next();
            if (dbCon.hasTableOrColumn(table, null)) {
                HashMap<String, String> replacer = new HashMap<String, String>();
                replacer.put(REPLACEMENT_TABLENAME, table);
                dbCon.updateSqlStatement(this.readQuery(QUERY_DROP_TABLE), replacer, null);
                continue;
            }
            System.out.println("table " + table + " not found");
        }
    }
}

