/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.generic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.A_CmsUpdateDBPart;

public class CmsUpdateDBUpdateOU
extends A_CmsUpdateDBPart {
    protected static final String GROUP_OU_COLUMN = "GROUP_OU";
    protected static final String PROJECT_OU_COLUMN = "PROJECT_OU";
    protected static final String QUERY_ADD_OUS_TO_TABLE = "Q_ADD_OUS_TO_TABLE";
    protected static final String QUERY_KEY_ALTER_TABLE = "Q_ALTER_TABLE_ADD_OU_COLUMN";
    protected static final String REPLACEMENT_COLUMNNAME = "${columnname}";
    protected static final String REPLACEMENT_TABLENAME = "${tablename}";
    protected static final String TABLE_BACKUP_PROJECTS = "CMS_BACKUP_PROJECTS";
    protected static final String TABLE_CMS_GROUPS = "CMS_GROUPS";
    protected static final String TABLE_CMS_USERS = "CMS_USERS";
    protected static final String TABLE_PROJECTS = "CMS_PROJECTS";
    protected static final String USER_OU_COLUMN = "USER_OU";
    private static final String QUERY_PROPERTY_FILE = "generic/cms_ou_query.properties";

    public CmsUpdateDBUpdateOU() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/generic/cms_ou_query.properties");
    }

    protected boolean findOUColumn(CmsSetupDb dbCon, String table, String ouColumn) {
        System.out.println(new Exception().getStackTrace()[0].toString());
        return dbCon.hasTableOrColumn(table, ouColumn);
    }

    protected void internalExecute(CmsSetupDb dbCon) {
        System.out.println(new Exception().getStackTrace()[0].toString());
        this.updateOUs(dbCon, TABLE_CMS_USERS, USER_OU_COLUMN);
        this.updateOUs(dbCon, TABLE_CMS_GROUPS, GROUP_OU_COLUMN);
        this.updateOUs(dbCon, TABLE_PROJECTS, PROJECT_OU_COLUMN);
        this.updateOUs(dbCon, TABLE_BACKUP_PROJECTS, PROJECT_OU_COLUMN);
    }

    protected int updateOUs(CmsSetupDb dbCon, String table, String ouColumn) {
        System.out.println(new Exception().getStackTrace()[0].toString());
        int result = 1;
        try {
            if (!this.findOUColumn(dbCon, table, ouColumn)) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put(REPLACEMENT_TABLENAME, table);
                replacements.put(REPLACEMENT_COLUMNNAME, ouColumn);
                String alterQuery = this.readQuery(QUERY_KEY_ALTER_TABLE);
                dbCon.updateSqlStatement(alterQuery, replacements, null);
                String insertQuery = this.readQuery(QUERY_ADD_OUS_TO_TABLE);
                dbCon.updateSqlStatement(insertQuery, replacements, null);
                result = 0;
            } else {
                System.out.println("column " + ouColumn + " in table " + table + " already exists");
            }
            result = 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            result = 1;
        }
        return result;
    }
}

