/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.oracle;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.opencms.db.oracle.CmsUserDriver;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;
import org.opencms.util.CmsDataTypeUtil;

public class CmsUpdateDBCmsUsers
extends org.opencms.setup.update6to7.generic.CmsUpdateDBCmsUsers {
    private static final String QUERY_ORACLE_USERDATA_UPDATE = "Q_ORACLE_USERDATA_UPDATE";
    private static final String QUERY_PROPERTY_FILE = "oracle/cms_users_queries.properties";
    private static final String REPLACEMENT_TABLEINDEX_SPACE = "${indexTablespace}";

    public CmsUpdateDBCmsUsers() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/oracle/cms_users_queries.properties");
    }

    protected void createUserDataTable(CmsSetupDb dbCon) throws SQLException {
        String indexTablespace = (String)this.m_poolData.get("indexTablespace");
        HashMap<String, String> replacer = new HashMap<String, String>();
        replacer.put(REPLACEMENT_TABLEINDEX_SPACE, indexTablespace);
        String createStatement = this.readQuery("Q_CREATE_TABLE_USERDATA");
        dbCon.updateSqlStatement(createStatement, replacer, null);
        ArrayList<String> indexElements = new ArrayList<String>();
        indexElements.add("CMS_USERDATA_01_IDX_INDEX");
        indexElements.add("CMS_USERDATA_02_IDX_INDEX");
        Iterator iter = indexElements.iterator();
        while (iter.hasNext()) {
            String stmt = this.readQuery((String)iter.next());
            try {
                dbCon.updateSqlStatement(stmt, replacer, null);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeUserInfo(CmsSetupDb dbCon, String id, String key, Object value) {
        block45: {
            String query = this.readQuery("Q_INSERT_CMS_USERDATA");
            try {
                ArrayList<String> params = new ArrayList<String>();
                params.add(id);
                params.add(key);
                params.add(value.getClass().getName());
                dbCon.updateSqlStatement(query, null, params);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            boolean wasInTransaction = false;
            CmsSetupDBWrapper db = null;
            boolean bl = wasInTransaction = !dbCon.getConnection().getAutoCommit();
            if (!wasInTransaction) {
                dbCon.getConnection().setAutoCommit(false);
            }
            String stmt = this.readQuery(QUERY_ORACLE_USERDATA_UPDATE);
            ArrayList<String> params = new ArrayList<String>();
            params.add(id);
            params.add(key);
            db = dbCon.executeSqlStatement(stmt, null, params);
            if (db.getResultSet().next()) {
                OutputStream output = CmsUserDriver.getOutputStreamFromBlob((ResultSet)db.getResultSet(), (String)"DATA_VALUE");
                output.write(CmsDataTypeUtil.dataSerialize((Object)value));
                output.close();
            } else {
                System.out.println("Could not insert blob");
            }
            if (!wasInTransaction) {
                CmsSetupDBWrapper db2 = null;
                try {
                    String commit = this.readQuery("Q_COMMIT");
                    db2 = dbCon.executeSqlStatement(commit, null);
                }
                finally {
                    if (db2 != null) {
                        db2.close();
                    }
                }
            }
            Object var14_16 = null;
            if (db != null) {
                db.close();
            }
            CmsSetupDBWrapper db2 = null;
            try {
                if (!wasInTransaction) {
                    String rollback = this.readQuery("Q_ROLLBACK");
                    db2 = dbCon.executeSqlStatement(rollback, null);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                if (db2 != null) {
                    db2.close();
                }
            }
            try {
                if (!wasInTransaction) {
                    dbCon.getConnection().setAutoCommit(true);
                }
                break block45;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block45;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    Object var14_17 = null;
                    if (db != null) {
                        db.close();
                    }
                    db2 = null;
                    try {
                        if (!wasInTransaction) {
                            String rollback = this.readQuery("Q_ROLLBACK");
                            db2 = dbCon.executeSqlStatement(rollback, null);
                        }
                        if (db2 != null) {
                            db2.close();
                        }
                    }
                    catch (Exception e2) {
                        try {}
                        catch (Throwable throwable) {
                            if (db2 != null) {
                                db2.close();
                            }
                            throw throwable;
                        }
                        e2.printStackTrace();
                        if (db2 != null) {
                            db2.close();
                        }
                    }
                    try {
                        if (!wasInTransaction) {
                            dbCon.getConnection().setAutoCommit(true);
                        }
                        break block45;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (db != null) {
                    db.close();
                }
                db2 = null;
                try {
                    if (!wasInTransaction) {
                        String rollback = this.readQuery("Q_ROLLBACK");
                        db2 = dbCon.executeSqlStatement(rollback, null);
                    }
                    if (db2 != null) {
                        db2.close();
                    }
                }
                catch (Exception e2) {
                    try {}
                    catch (Throwable throwable2) {
                        if (db2 != null) {
                            db2.close();
                        }
                        throw throwable2;
                    }
                    e2.printStackTrace();
                    if (db2 != null) {
                        db2.close();
                    }
                }
                try {
                    if (!wasInTransaction) {
                        dbCon.getConnection().setAutoCommit(true);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }
}

