/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.oracle;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;

public class CmsUpdateDBCreateIndexes7
extends org.opencms.setup.update6to7.generic.CmsUpdateDBCreateIndexes7 {
    private static final String FIELD_CONSTRAINT = "CONSTRAINT_NAME";
    private static final String FIELD_INDEX = "INDEX_NAME";
    private static final String QUERY_DROP_CONSTRAINT = "Q_DROP_CONSTRAINT";
    private static final String QUERY_DROP_INDEX = "Q_DROP_INDEX";
    private static final String QUERY_PROPERTY_FILE = "oracle/cms_add_new_indexes_queries.properties";
    private static final String QUERY_SHOW_CONSTRAINTS = "Q_SHOW_CONSTRAINTS";
    private static final String REPLACEMENT_INDEXNAME = "${indexname}";
    private static final String REPLACEMENT_TABLEINDEX_SPACE = "${indexTablespace}";

    public CmsUpdateDBCreateIndexes7() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/oracle/cms_add_new_indexes_queries.properties");
    }

    protected void internalExecute(CmsSetupDb dbCon) {
        System.out.println(new Exception().getStackTrace()[0].toString());
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("CMS_CONTENTS");
        elements.add("CMS_GROUPS");
        elements.add("CMS_GROUPUSERS");
        elements.add("CMS_OFFLINE_ACCESSCONTROL");
        elements.add("CMS_OFFLINE_CONTENTS");
        elements.add("CMS_OFFLINE_PROPERTIES");
        elements.add("CMS_OFFLINE_PROPERTYDEF");
        elements.add("CMS_OFFLINE_RESOURCES");
        elements.add("CMS_OFFLINE_STRUCTURE");
        elements.add("CMS_ONLINE_ACCESSCONTROL");
        elements.add("CMS_ONLINE_PROPERTIES");
        elements.add("CMS_ONLINE_PROPERTYDEF");
        elements.add("CMS_ONLINE_RESOURCES");
        elements.add("CMS_ONLINE_STRUCTURE");
        elements.add("CMS_PROJECTRESOURCES");
        elements.add("CMS_PROJECTS");
        elements.add("CMS_PUBLISH_HISTORY");
        elements.add("CMS_STATICEXPORT_LINKS");
        elements.add("CMS_USERS");
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            String tablename = (String)it.next();
            if (dbCon.hasTableOrColumn(tablename, null)) {
                Iterator iter;
                try {
                    List constraints = this.getConstraintsTopDrop(dbCon, tablename);
                    iter = constraints.iterator();
                    while (iter.hasNext()) {
                        String constraint = (String)iter.next();
                        String dropConstraint = this.readQuery(QUERY_DROP_CONSTRAINT);
                        HashMap<String, String> replacer = new HashMap<String, String>();
                        replacer.put("${tablename}", tablename);
                        replacer.put(REPLACEMENT_INDEXNAME, constraint);
                        dbCon.updateSqlStatement(dropConstraint, replacer, null);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                try {
                    List indexes = this.getIndexesToDrop(dbCon, tablename);
                    iter = indexes.iterator();
                    while (iter.hasNext()) {
                        String index = (String)iter.next();
                        String dropIndex = this.readQuery(QUERY_DROP_INDEX);
                        HashMap<String, String> replacerIndex = new HashMap<String, String>();
                        replacerIndex.put(REPLACEMENT_INDEXNAME, index);
                        dbCon.updateSqlStatement(dropIndex, replacerIndex, null);
                    }
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            System.out.println("Table " + tablename + "does not exist.");
        }
        this.createNewIndexes(dbCon);
    }

    private void createNewIndexes(CmsSetupDb dbCon) {
        ArrayList<String> indexElements = new ArrayList<String>();
        indexElements.add("CMS_CONTENTS_PRIMARY_KEY");
        indexElements.add("CMS_CONTENTS_01_IDX_INDEX");
        indexElements.add("CMS_CONTENTS_02_IDX_INDEX");
        indexElements.add("CMS_CONTENTS_03_IDX_INDEX");
        indexElements.add("CMS_CONTENTS_04_IDX_INDEX");
        indexElements.add("CMS_CONTENTS_05_IDX_INDEX");
        indexElements.add("CMS_GROUPS_PRIMARY_KEY");
        indexElements.add("CMS_GROUPS_UNIQUE_KEY_GROUPS");
        indexElements.add("CMS_GROUPS_01_IDX_INDEX");
        indexElements.add("CMS_GROUPS_02_IDX_INDEX");
        indexElements.add("CMS_GROUPS_03_IDX_INDEX");
        indexElements.add("CMS_GROUPUSERS_PRIMARY_KEY");
        indexElements.add("CMS_GROUPUSERS_01_IDX_INDEX");
        indexElements.add("CMS_GROUPUSERS_02_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_ACCESSCONTROL_PRIMARY_KEY");
        indexElements.add("CMS_OFFLINE_ACCESSCONTROL_01_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_ACCESSCONTROL_02_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_CONTENTS_PRIMARY_KEY");
        indexElements.add("CMS_OFFLINE_PROPERTIES_PRIMARY_KEY");
        indexElements.add("CMS_OFFLINE_PROPERTIES_UNIQUE_KEY_PROPERTIES");
        indexElements.add("CMS_OFFLINE_PROPERTIES_01_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_PROPERTIES_02_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_PROPERTYDEF_PRIMARY_KEY");
        indexElements.add("CMS_OFFLINE_PROPERTYDEF_UNIQUE_KEY_PROPERTYDEF");
        indexElements.add("CMS_OFFLINE_RESOURCES_PRIMARY_KEY");
        indexElements.add("CMS_OFFLINE_RESOURCES_01_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_RESOURCES_02_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_RESOURCES_03_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_RESOURCES_04_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_RESOURCES_05_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_STRUCTURE_PRIMARY_KEY");
        indexElements.add("CMS_OFFLINE_STRUCTURE_01_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_STRUCTURE_02_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_STRUCTURE_03_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_STRUCTURE_04_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_STRUCTURE_05_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_STRUCTURE_06_IDX_INDEX");
        indexElements.add("CMS_OFFLINE_STRUCTURE_07_IDX_INDEX");
        indexElements.add("CMS_ONLINE_ACCESSCONTROL_PRIMARY_KEY");
        indexElements.add("CMS_ONLINE_ACCESSCONTROL_01_IDX_INDEX");
        indexElements.add("CMS_ONLINE_ACCESSCONTROL_02_IDX_INDEX");
        indexElements.add("CMS_ONLINE_PROPERTIES_PRIMARY_KEY");
        indexElements.add("CMS_ONLINE_PROPERTIES_UNIQUE_KEY_PROPERTIES");
        indexElements.add("CMS_ONLINE_PROPERTIES_01_IDX_INDEX");
        indexElements.add("CMS_ONLINE_PROPERTIES_02_IDX_INDEX");
        indexElements.add("CMS_ONLINE_PROPERTYDEF_PRIMARY_KEY");
        indexElements.add("CMS_ONLINE_PROPERTYDEF_UNIQUE_KEY_PROPERTYDEF");
        indexElements.add("CMS_ONLINE_RESOURCES_PRIMARY_KEY");
        indexElements.add("CMS_ONLINE_RESOURCES_01_IDX_INDEX");
        indexElements.add("CMS_ONLINE_RESOURCES_02_IDX_INDEX");
        indexElements.add("CMS_ONLINE_RESOURCES_03_IDX_INDEX");
        indexElements.add("CMS_ONLINE_RESOURCES_04_IDX_INDEX");
        indexElements.add("CMS_ONLINE_RESOURCES_05_IDX_INDEX");
        indexElements.add("CMS_ONLINE_STRUCTURE_PRIMARY_KEY");
        indexElements.add("CMS_ONLINE_STRUCTURE_01_IDX_INDEX");
        indexElements.add("CMS_ONLINE_STRUCTURE_02_IDX_INDEX");
        indexElements.add("CMS_ONLINE_STRUCTURE_03_IDX_INDEX");
        indexElements.add("CMS_ONLINE_STRUCTURE_04_IDX_INDEX");
        indexElements.add("CMS_ONLINE_STRUCTURE_05_IDX_INDEX");
        indexElements.add("CMS_ONLINE_STRUCTURE_06_IDX_INDEX");
        indexElements.add("CMS_ONLINE_STRUCTURE_07_IDX_INDEX");
        indexElements.add("CMS_PROJECTRESOURCES_PRIMARY_KEY");
        indexElements.add("CMS_PROJECTRESOURCES_01_IDX_INDEX");
        indexElements.add("CMS_PROJECTS_PRIMARY_KEY");
        indexElements.add("CMS_PROJECTS_UNIQUE_KEY_PROJECTS");
        indexElements.add("CMS_PROJECTS_01_IDX_INDEX");
        indexElements.add("CMS_PROJECTS_02_IDX_INDEX");
        indexElements.add("CMS_PROJECTS_03_IDX_INDEX");
        indexElements.add("CMS_PROJECTS_04_IDX_INDEX");
        indexElements.add("CMS_PROJECTS_05_IDX_INDEX");
        indexElements.add("CMS_PROJECTS_06_IDX_INDEX");
        indexElements.add("CMS_PROJECTS_07_IDX_INDEX");
        indexElements.add("CMS_PUBLISH_HISTORY_PRIMARY_KEY");
        indexElements.add("CMS_PUBLISH_HISTORY_01_IDX_INDEX");
        indexElements.add("CMS_STATICEXPORT_LINKS_PRIMARY_KEY");
        indexElements.add("CMS_STATICEXPORT_LINKS_01_IDX_INDEX");
        indexElements.add("CMS_USERS_PRIMARY_KEY");
        indexElements.add("CMS_USERS_UNIQUE_KEY_USERS");
        indexElements.add("CMS_USERS_01_IDX_INDEX");
        indexElements.add("CMS_USERS_02_IDX_INDEX");
        String indexTablespace = (String)this.m_poolData.get("indexTablespace");
        Iterator createIndexes = indexElements.iterator();
        while (createIndexes.hasNext()) {
            String queryToRead = (String)createIndexes.next();
            String query = this.readQuery(queryToRead);
            try {
                HashMap<String, String> replacer = new HashMap<String, String>();
                replacer.put(REPLACEMENT_TABLEINDEX_SPACE, indexTablespace);
                dbCon.updateSqlStatement(query, replacer, null);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getConstraintsTopDrop(CmsSetupDb dbCon, String tablename) throws SQLException {
        ArrayList<String> constraints = new ArrayList<String>();
        String tableConstraints = this.readQuery(QUERY_SHOW_CONSTRAINTS);
        HashMap<String, String> replacer = new HashMap<String, String>();
        replacer.put("${tablename}", tablename);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(tableConstraints, replacer);
            while (db.getResultSet().next()) {
                String constraint = db.getResultSet().getString(FIELD_CONSTRAINT);
                if (constraints.contains(constraint)) continue;
                constraints.add(constraint);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return constraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getIndexesToDrop(CmsSetupDb dbCon, String tablename) {
        ArrayList<String> indexes = new ArrayList<String>();
        String tableIndex = this.readQuery("QUERY_SHOW_INDEX");
        HashMap<String, String> replacer = new HashMap<String, String>();
        replacer.put("${tablename}", tablename);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(tableIndex, replacer);
            while (db.getResultSet().next()) {
                String index = db.getResultSet().getString(FIELD_INDEX);
                if (indexes.contains(index)) continue;
                indexes.add(index);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return indexes;
    }
}

