/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.oracle;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;

public class CmsUpdateDBDropOldIndexes
extends org.opencms.setup.update6to7.generic.CmsUpdateDBDropOldIndexes {
    private static final String FIELD_CONSTRAINT_ORACLE = "CONSTRAINT_NAME";
    private static final String FIELD_INDEX_ORACLE = "INDEX_NAME";
    private static final String QUERY_DROP_CONSTRAINT = "Q_DROP_CONSTRAINT";
    private static final String QUERY_PROPERTY_FILE_ORACLE = "oracle/cms_drop_all_indexes_queries.properties";
    private static final String QUERY_SHOW_CONSTRAINTS = "Q_SHOW_CONSTRAINTS";
    private static final String REPLACEMENT_INDEX_ORACLE = "${indexname}";
    private static final String[] TEMP_INDEXES = new String[]{"CMS_BACKUP_CONTENTS_INDEX_1", "CMS_BACKUP_CONTENTS_INDEX_2", "CMS_BACKUP_PROJECTRESOURCES_INDEX_1", "CMS_BACKUP_PROJECTS_INDEX_1", "CMS_BACKUP_PROJECTS_INDEX_2", "CMS_BACKUP_PROJECTS_INDEX_3", "CMS_BACKUP_PROJECTS_INDEX_4", "CMS_BACKUP_PROJECTS_INDEX_5", "CMS_BACKUP_PROJECTS_INDEX_6", "CMS_BACKUP_PROPERTIES_INDEX_1", "CMS_BACKUP_PROPERTIES_INDEX_2", "CMS_BACKUP_PROPERTIES_INDEX_3", "CMS_BACKUP_PROPERTYDEF_INDEX_1", "CMS_BACKUP_RESOURCES_INDEX_1", "CMS_BACKUP_RESOURCES_INDEX_2", "CMS_BACKUP_RESOURCES_INDEX_3", "CMS_BACKUP_RESOURCES_INDEX_4", "CMS_BACKUP_RESOURCES_INDEX_5", "CMS_BACKUP_STRUCTURE_INDEX_1", "CMS_BACKUP_STRUCTURE_INDEX_2", "CMS_BACKUP_STRUCTURE_INDEX_3", "CMS_BACKUP_STRUCTURE_INDEX_4", "CMS_GROUPS_INDEX_1", "CMS_OFFLINE_CONTENTS_INDEX_1", "CMS_OFFLINE_RESOURCES_INDEX_1", "CMS_OFFLINE_RESOURCES_INDEX_2", "CMS_OFFLINE_RESOURCES_INDEX_3", "CMS_OFFLINE_RESOURCES_INDEX_4", "CMS_OFFLINE_STRUCTURE_INDEX_1", "CMS_OFFLINE_STRUCTURE_INDEX_2", "CMS_OFFLINE_STRUCTURE_INDEX_3", "CMS_ONLINE_CONTENTS_INDEX_1", "CMS_ONLINE_RESOURCES_INDEX_1", "CMS_ONLINE_RESOURCES_INDEX_2", "CMS_ONLINE_RESOURCES_INDEX_3", "CMS_ONLINE_RESOURCES_INDEX_4", "CMS_ONLINE_STRUCTURE_INDEX_1", "CMS_ONLINE_STRUCTURE_INDEX_2", "CMS_ONLINE_STRUCTURE_INDEX_3", "CMS_PROJECTRESOURCES_INDEX_1", "CMS_PROJECTS_INDEX_1", "CMS_PROJECTS_INDEX_2", "CMS_PROJECTS_INDEX_3", "CMS_PROJECTS_INDEX_4", "CMS_PUBLISH_HISTORY_INDEX_1", "CMS_PUBLISH_HISTORY_INDEX_2"};
    private static final List TEMP_INDEXES_LIST = Collections.unmodifiableList(Arrays.asList(TEMP_INDEXES));

    public CmsUpdateDBDropOldIndexes() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/oracle/cms_drop_all_indexes_queries.properties");
    }

    protected void internalExecute(CmsSetupDb dbCon) {
        List tablenames = CMS_TABLES_LIST;
        Iterator tableIterator = tablenames.iterator();
        while (tableIterator.hasNext()) {
            String tablename = (String)tableIterator.next();
            System.out.println("dropping indexes for table " + tablename);
            if (!dbCon.hasTableOrColumn(tablename, null)) continue;
            try {
                List constraints = this.getConstraints(dbCon, tablename);
                Iterator iter = constraints.iterator();
                while (iter.hasNext()) {
                    String constraint = (String)iter.next();
                    String dropConstraint = this.readQuery(QUERY_DROP_CONSTRAINT);
                    HashMap<String, String> replacer = new HashMap<String, String>();
                    replacer.put("${tablename}", tablename);
                    replacer.put(REPLACEMENT_INDEX_ORACLE, constraint);
                    dbCon.updateSqlStatement(dropConstraint, replacer, null);
                }
                List indexes = this.getIndexes(dbCon, tablename);
                iter = indexes.iterator();
                while (iter.hasNext()) {
                    String index = (String)iter.next();
                    String dropIndex = this.readQuery("Q_DROP_INDEX");
                    HashMap<String, String> replacerIndex = new HashMap<String, String>();
                    replacerIndex.put(REPLACEMENT_INDEX_ORACLE, index);
                    dbCon.updateSqlStatement(dropIndex, replacerIndex, null);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Iterator tempIndexes = TEMP_INDEXES_LIST.iterator();
        while (tempIndexes.hasNext()) {
            try {
                String createIndex = (String)tempIndexes.next();
                String creationQuery = this.readQuery(createIndex);
                dbCon.updateSqlStatement(creationQuery, null, null);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getConstraints(CmsSetupDb dbCon, String tablename) throws SQLException {
        ArrayList<String> constraints = new ArrayList<String>();
        String tableConstraints = this.readQuery(QUERY_SHOW_CONSTRAINTS);
        HashMap<String, String> replacer = new HashMap<String, String>();
        replacer.put("${tablename}", tablename);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(tableConstraints, replacer);
            while (db.getResultSet().next()) {
                String constraint = db.getResultSet().getString(FIELD_CONSTRAINT_ORACLE);
                if (constraints.contains(constraint)) continue;
                constraints.add(constraint);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return constraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getIndexes(CmsSetupDb dbCon, String tablename) throws SQLException {
        ArrayList<String> indexes = new ArrayList<String>();
        String tableIndex = this.readQuery("Q_SHOW_INDEXES");
        HashMap<String, String> replacer = new HashMap<String, String>();
        replacer.put("${tablename}", tablename);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(tableIndex, replacer);
            while (db.getResultSet().next()) {
                String index = db.getResultSet().getString(FIELD_INDEX_ORACLE);
                if (indexes.contains(index)) continue;
                indexes.add(index);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return indexes;
    }
}

