/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.postgresql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.opencms.setup.CmsSetupDb;

public class CmsUpdateDBAlterTables
extends org.opencms.setup.update6to7.generic.CmsUpdateDBAlterTables {
    private static final String QUERY_ALTER_FIELD = "Q_ALTER_FIELD_TYPE";
    private static final String QUERY_SET_DEFAULT_VALUE = "Q_ALTER_FIELD_SET_DEFAULT";
    private static final String QUERY_DROP_DEFAULT_VALUE = "Q_ALTER_FIELD_DROP_DEFAULT";
    private static final String QUERY_SET_NOT_NULL = "Q_ALTER_FIELD_SET_NOT_NULL";
    private static final String QUERY_DROP_NOT_NULL = "Q_ALTER_FIELD_DROP_NOT_NULL";
    private static final String REPLACEMENT_FIELD_NAME = "${fieldname}";
    private static final String REPLACEMENT_FIELD_TYPE = "${fieldtype}";
    private static final String REPLACEMENT_FIELD_DEFAULT_VALUE = "${defaultvalue}";
    private static final String QUERY_PROPERTY_FILE_ORACLE = "postgresql/cms_alter_remaining_queries.properties";
    private static final String DROP_NOT_NULL = "0";
    private static final String SET_NOT_NULL = "1";
    private static final String NO_CHANGE = "2";
    private static final String DV_NO_CHANGE = null;
    private static final String DV_DROP = "-- droping the default value --";
    private static final String[][] DB_ARRAY = new String[][]{{"cms_groups", "group_name", "varchar(128)", "2", DV_NO_CHANGE}, {"cms_groups", "group_ou", "", "1", DV_NO_CHANGE}, {"cms_offline_properties", "property_value", "varchar(2048)", "2", DV_NO_CHANGE}, {"cms_offline_propertydef", "propertydef_type", "", "2", "-- droping the default value --"}, {"cms_offline_resources", "date_content", "", "2", "-- droping the default value --"}, {"cms_offline_resources", "project_lastmodified", "", "1", DV_NO_CHANGE}, {"cms_offline_resources", "resource_version", "", "1", "-- droping the default value --"}, {"cms_offline_structure", "resource_path", "varchar(1024)", "0", DV_NO_CHANGE}, {"cms_offline_structure", "structure_state", "integer", "2", DV_NO_CHANGE}, {"cms_offline_structure", "date_released", "", "1", DV_NO_CHANGE}, {"cms_offline_structure", "date_expired", "", "1", DV_NO_CHANGE}, {"cms_offline_structure", "structure_version", "", "2", "-- droping the default value --"}, {"cms_online_properties", "property_value", "varchar(2048)", "2", DV_NO_CHANGE}, {"cms_online_propertydef", "propertydef_type", "", "2", "-- droping the default value --"}, {"cms_online_resources", "resource_state", "integer", "2", DV_NO_CHANGE}, {"cms_online_resources", "date_content", "", "2", "-- droping the default value --"}, {"cms_online_resources", "project_lastmodified", "", "1", DV_NO_CHANGE}, {"cms_online_resources", "resource_version", "", "2", "-- droping the default value --"}, {"cms_online_structure", "resource_path", "varchar(1024)", "0", DV_NO_CHANGE}, {"cms_online_structure", "structure_state", "integer", "2", DV_NO_CHANGE}, {"cms_online_structure", "structure_version", "", "2", "-- droping the default value --"}, {"cms_projectresources", "resource_path", "varchar(1024)", "2", DV_NO_CHANGE}, {"cms_projects", "project_ou", "", "1", DV_NO_CHANGE}, {"cms_publish_history", "resource_path", "varchar(1024)", "2", DV_NO_CHANGE}, {"cms_resource_locks", "resource_path", "", "0", DV_NO_CHANGE}, {"cms_staticexport_links", "link_rfs_path", "varchar(1024)", "0", DV_NO_CHANGE}, {"cms_staticexport_links", "link_parameter", "varchar(1024)", "2", DV_NO_CHANGE}, {"cms_staticexport_links", "link_timestamp", "", "1", DV_NO_CHANGE}, {"cms_users", "user_name", "varchar(128)", "2", DV_NO_CHANGE}, {"cms_users", "user_password", "varchar(64)", "2", DV_NO_CHANGE}, {"cms_users", "user_firstname", "varchar(128)", "2", DV_NO_CHANGE}, {"cms_users", "user_lastname", "varchar(128)", "2", DV_NO_CHANGE}, {"cms_users", "user_email", "varchar(128)", "2", DV_NO_CHANGE}, {"cms_users", "user_ou", "", "1", DV_NO_CHANGE}, {"cms_users", "user_datecreated", "", "2", "-- droping the default value --"}};

    public CmsUpdateDBAlterTables() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/postgresql/cms_alter_remaining_queries.properties");
    }

    public void internalExecute(CmsSetupDb dbCon) throws SQLException {
        super.internalExecute(dbCon);
        this.fixSchema(dbCon);
    }

    private void initReplaceser(HashMap replacer, String tableName, String fieldName) {
        replacer.clear();
        replacer.put("${tablename}", tableName);
        replacer.put(REPLACEMENT_FIELD_NAME, fieldName);
    }

    private void fixSchema(CmsSetupDb dbCon) throws SQLException {
        HashMap<String, String> replacer = new HashMap<String, String>();
        for (int i = 0; i < DB_ARRAY.length; ++i) {
            String query;
            String tableName = DB_ARRAY[i][0];
            String fieldName = DB_ARRAY[i][1];
            String fieldType = DB_ARRAY[i][2];
            String nullAcceptInfo = DB_ARRAY[i][3];
            String defaultValue = DB_ARRAY[i][4];
            if (fieldType != null && fieldType.length() > 0) {
                this.initReplaceser(replacer, tableName, fieldName);
                replacer.put(REPLACEMENT_FIELD_TYPE, fieldType);
                query = this.readQuery(QUERY_ALTER_FIELD);
                dbCon.updateSqlStatement(query, replacer, null);
            }
            if (nullAcceptInfo != null && !nullAcceptInfo.equals(NO_CHANGE)) {
                String q = nullAcceptInfo.equals(DROP_NOT_NULL) ? QUERY_DROP_NOT_NULL : QUERY_SET_NOT_NULL;
                query = this.readQuery(q);
                this.initReplaceser(replacer, tableName, fieldName);
                dbCon.updateSqlStatement(query, replacer, null);
            }
            if (defaultValue == null || defaultValue.length() <= 0) continue;
            this.initReplaceser(replacer, tableName, fieldName);
            if (defaultValue.equals(DV_DROP)) {
                query = this.readQuery(QUERY_DROP_DEFAULT_VALUE);
                dbCon.updateSqlStatement(query, replacer, null);
                continue;
            }
            query = this.readQuery(QUERY_SET_DEFAULT_VALUE);
            replacer.put(REPLACEMENT_FIELD_DEFAULT_VALUE, defaultValue);
            dbCon.updateSqlStatement(query, replacer, null);
        }
    }
}

