/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.postgresql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsUpdateDBCmsUsers
extends org.opencms.setup.update6to7.generic.CmsUpdateDBCmsUsers {
    private static final String QUERY_PROPERTY_FILE = "postgresql/cms_users_queries.properties";
    private static final String REPLACEMENT_TABLEINDEX_SPACE = "${indexTablespace}";
    private static final String CHECK_CMS_USERDATA = "CMS_USERDATA";
    private static final String CMS_USERS_TABLE = "CMS_USERS";
    private static final String RESULTSET_USER_ID = "USER_ID";
    private static final String RESULTSET_USER_INFO = "USER_INFO";
    private static final String USER_ADDRESS = "USER_ADDRESS";
    private static final String USER_DESCRIPTION = "USER_DESCRIPTION";
    private static final String USER_TYPE = "USER_TYPE";
    private static final String QUERY_SELECT_USER_DATA = "Q_SELECT_USER_DATA";

    public CmsUpdateDBCmsUsers() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/postgresql/cms_users_queries.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalExecute(CmsSetupDb dbCon) {
        block18: {
            System.out.println(new Exception().getStackTrace()[0].toString());
            try {
                if (dbCon.hasTableOrColumn(CMS_USERS_TABLE, USER_TYPE)) {
                    CmsUUID id = this.createWebusersGroup(dbCon);
                    this.addWebusersToGroup(dbCon, id);
                } else {
                    System.out.println("table CMS_USERDATA already exists");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (!this.checkUserDataTable(dbCon)) {
                    this.createUserDataTable(dbCon);
                    String query = this.readQuery(QUERY_SELECT_USER_DATA);
                    CmsSetupDBWrapper db = null;
                    try {
                        db = dbCon.executeSqlStatement(query, null);
                        while (db.getResultSet().next()) {
                            String userID = (String)db.getResultSet().getObject(RESULTSET_USER_ID);
                            try {
                                String userDescription;
                                String userAddress;
                                byte[] blob = db.getResultSet().getBytes(RESULTSET_USER_INFO);
                                ByteArrayInputStream bin = new ByteArrayInputStream(blob);
                                ObjectInputStream oin = new ObjectInputStream(bin);
                                HashMap<String, String> infos = (HashMap<String, String>)oin.readObject();
                                if (infos == null) {
                                    infos = new HashMap<String, String>();
                                }
                                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)(userAddress = (String)db.getResultSet().getObject(USER_ADDRESS)))) {
                                    infos.put(USER_ADDRESS, userAddress);
                                }
                                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)(userDescription = (String)db.getResultSet().getObject(USER_DESCRIPTION)))) {
                                    infos.put(USER_DESCRIPTION, userDescription);
                                }
                                this.writeAdditionalUserInfo(dbCon, userID, infos);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    finally {
                        if (db != null) {
                            db.close();
                        }
                    }
                    this.addUserDateCreated(dbCon);
                    this.removeUnnecessaryColumns(dbCon);
                    break block18;
                }
                System.out.println("table CMS_USERDATA already exists");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected void createUserDataTable(CmsSetupDb dbCon) throws SQLException {
        String indexTablespace = (String)this.m_poolData.get("indexTablespace");
        HashMap<String, String> replacer = new HashMap<String, String>();
        replacer.put(REPLACEMENT_TABLEINDEX_SPACE, indexTablespace);
        String createStatement = this.readQuery("Q_CREATE_TABLE_USERDATA");
        dbCon.updateSqlStatement(createStatement, replacer, null);
        ArrayList<String> indexElements = new ArrayList<String>();
        indexElements.add("CMS_USERDATA_01_IDX_INDEX");
        indexElements.add("CMS_USERDATA_02_IDX_INDEX");
        Iterator iter = indexElements.iterator();
        while (iter.hasNext()) {
            String stmt = this.readQuery((String)iter.next());
            try {
                dbCon.updateSqlStatement(stmt, replacer, null);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected void writeUserInfo(CmsSetupDb dbCon, String id, String key, Object value) {
        Connection conn = dbCon.getConnection();
        try {
            PreparedStatement p = conn.prepareStatement(this.readQuery("Q_INSERT_CMS_USERDATA"));
            p.setString(1, id);
            p.setString(2, key);
            p.setBytes(3, CmsDataTypeUtil.dataSerialize((Object)value));
            p.setString(4, value.getClass().getName());
            p.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

