/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.postgresql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;

public class CmsUpdateDBProjectId
extends org.opencms.setup.update6to7.generic.CmsUpdateDBProjectId {
    private static final String COLUMN_PROJECT_ID_RESOURCE_PATH = "PROJECT_ID,RESOURCE_PATH";
    private static final String QUERY_PROPERTY_FILE = "postgresql/cms_projectid_queries.properties";
    private static final String REPLACEMENT_TABLEINDEX_SPACE = "${indexTablespace}";

    public CmsUpdateDBProjectId() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/postgresql/cms_projectid_queries.properties");
    }

    protected void addPrimaryKey(CmsSetupDb dbCon, String tablename, String primaryKey) throws SQLException {
        String indexTablespace = (String)this.m_poolData.get("indexTablespace");
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (dbCon.hasTableOrColumn(tablename, null)) {
            String query = this.readQuery("Q_ADD_PRIMARY_KEY");
            HashMap<String, String> replacer = new HashMap<String, String>();
            replacer.put("${tablename}", tablename);
            replacer.put("${primarykeycolumn}", primaryKey);
            replacer.put(REPLACEMENT_TABLEINDEX_SPACE, indexTablespace);
            dbCon.updateSqlStatement(query, replacer, null);
        } else {
            System.out.println("table " + tablename + " does not exists");
        }
    }

    protected void addUUIDColumnToTable(CmsSetupDb dbCon, String tablename, String column) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (!dbCon.hasTableOrColumn(tablename, column)) {
            String query = this.readQuery("Q_ADD_COLUMN");
            if (!RESOURCES_TABLES_LIST.contains(tablename)) {
                // empty if block
            }
            HashMap<String, String> replacer = new HashMap<String, String>();
            replacer.put("${tablename}", tablename);
            replacer.put("${column}", column);
            dbCon.updateSqlStatement(query, replacer, null);
        } else {
            System.out.println("column " + column + " in table " + tablename + " already exists");
        }
    }

    protected boolean checkColumnTypeProjectId(int type) {
        return type == 4;
    }

    protected void createHistProjectsTable(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (!dbCon.hasTableOrColumn("CMS_HISTORY_PROJECTS", null)) {
            String createStatement = this.readQuery("Q_CREATE_HISTORY_PROJECTS_TABLE");
            String indexTablespace = (String)this.m_poolData.get("indexTablespace");
            HashMap<String, String> replacer = new HashMap<String, String>();
            replacer.put(REPLACEMENT_TABLEINDEX_SPACE, indexTablespace);
            dbCon.updateSqlStatement(createStatement, replacer, null);
            this.transferDataToHistoryTable(dbCon);
        } else {
            System.out.println("table CMS_HISTORY_PROJECTS already exists");
        }
    }

    protected void createTempTable(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (!dbCon.hasTableOrColumn("TEMP_PROJECT_UUIDS", null)) {
            String createStatement = this.readQuery("Q_CREATE_TEMPORARY_TABLE_UUIDS");
            String indexTablespace = (String)this.m_poolData.get("indexTablespace");
            HashMap<String, String> replacer = new HashMap<String, String>();
            replacer.put(REPLACEMENT_TABLEINDEX_SPACE, indexTablespace);
            dbCon.updateSqlStatement(createStatement, replacer, null);
        } else {
            System.out.println("table TEMP_PROJECT_UUIDS already exists");
        }
    }

    protected String getColumnProjectIdResourcePath() {
        return COLUMN_PROJECT_ID_RESOURCE_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean needsUpdating(CmsSetupDb dbCon, String tablename) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        boolean result = true;
        String query = this.readQuery("Q_DESCRIBE_TABLE");
        HashMap<String, String> replacer = new HashMap<String, String>();
        replacer.put("${tablename}", tablename);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(query, replacer);
            while (db.getResultSet().next()) {
                String fieldname = db.getResultSet().getString("COLUMN_NAME");
                if (!fieldname.equals("PROJECT_ID") && !fieldname.equals("PROJECT_LASTMODIFIED")) continue;
                try {
                    String fieldtype = db.getResultSet().getString("DATA_TYPE");
                    if (fieldtype.indexOf("VARCHAR") <= -1) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (SQLException e) {
                    result = true;
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return result;
    }
}

